/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.editor.wizards;

import java.util.List;
import org.eclipse.egf.model.editor.EGFModelEditorPlugin;
import org.eclipse.egf.model.editor.commands.InvokeActivityCommand;
import org.eclipse.egf.model.editor.dialogs.EGFWizardDialog;
import org.eclipse.egf.model.editor.wizards.ActivitySelectionPage;
import org.eclipse.egf.model.editor.wizards.ContractSelectionPage;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.Contract;
import org.eclipse.egf.model.fprod.ProductionPlan;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class InvokeActivityWizard
extends Wizard
implements INewWizard {
    protected IStructuredSelection _selection;
    protected IWorkbench _workbench;
    protected ActivitySelectionPage _activitySelectionPage;
    protected ContractSelectionPage _contractSelectionPage;
    public boolean _isCanceled;

    protected ProductionPlan getProductionPlan() {
        if (this._selection == null || this._selection.size() != 1) {
            return null;
        }
        Object object = this._selection.getFirstElement();
        if (object instanceof ProductionPlan) {
            return (ProductionPlan)object;
        }
        return null;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this._workbench = workbench;
        this._selection = selection;
        this.setWindowTitle(EGFModelEditorPlugin.INSTANCE.getString("_UI_Wizard_Invoke_Activity_label"));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(EGFModelEditorPlugin.INSTANCE.getImage("full/wizban/NewFcore")));
        this.setNeedsProgressMonitor(true);
    }

    public boolean performCancel() {
        this._isCanceled = true;
        return true;
    }

    public void finishWizardDialog() {
        if (this.getContainer() instanceof EGFWizardDialog) {
            ((EGFWizardDialog)this.getContainer()).finishDialog();
        }
    }

    public void addPages() {
        this._activitySelectionPage = new ActivitySelectionPage();
        this.addPage((IWizardPage)this._activitySelectionPage);
        this._contractSelectionPage = new ContractSelectionPage();
        this.addPage((IWizardPage)this._contractSelectionPage);
    }

    public boolean performFinish() {
        Object result = this._activitySelectionPage.getFirstSelection();
        if (!(result instanceof Activity)) {
            return true;
        }
        ProductionPlan productionPlan = this.getProductionPlan();
        if (productionPlan == null) {
            return true;
        }
        EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)productionPlan);
        if (domain == null) {
            return false;
        }
        Activity activity = (Activity)domain.getResourceSet().getEObject(EcoreUtil.getURI((EObject)((Activity)result)), true);
        UniqueEList contracts = new UniqueEList();
        if (this._contractSelectionPage.getResult() != null) {
            Object[] objectArray = this._contractSelectionPage.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof Contract) {
                    contracts.add((Contract)domain.getResourceSet().getEObject(EcoreUtil.getURI((EObject)((Contract)object)), true));
                }
                ++n2;
            }
        }
        Command[] command = new Command[]{new InvokeActivityCommand(domain, productionPlan, activity, (List<Contract>)contracts)};
        if (domain instanceof TransactionalEditingDomain) {
            domain.getCommandStack().execute(new RecordingCommand((TransactionalEditingDomain)domain){

                protected void doExecute() {
                }
            }.chain(command[0]));
        } else {
            domain.getCommandStack().execute(command[0]);
        }
        return true;
    }
}

