/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.platform.internal.pde;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.egf.common.helper.CollectionHelper;
import org.eclipse.egf.core.platform.EGFPlatformPlugin;
import org.eclipse.egf.core.platform.internal.pde.AbstractPlatformExtensionPoint;
import org.eclipse.egf.core.platform.l10n.CorePlatformMessages;
import org.eclipse.egf.core.platform.pde.IPlatformBundle;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPoint;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PlatformBundle
implements IPlatformBundle {
    private IPluginModelBase _base;
    private String _previousBundleId;
    private Map<Class<?>, Map<String, Object>> _extensions = new HashMap();

    private static <T extends IPlatformExtensionPoint> IPlatformExtensionPointFactory<T> getPlatformExtensionPointFactory(Class<T> clazz) {
        return EGFPlatformPlugin.getPlatformExtensionPointFactories().get(clazz);
    }

    public PlatformBundle(IPluginModelBase base) {
        Assert.isNotNull((Object)base);
        Assert.isNotNull((Object)base.getBundleDescription());
        Assert.isNotNull((Object)BundleHelper.getBundleId((IPluginModelBase)base));
        this._base = base;
        this._previousBundleId = BundleHelper.getBundleId((IPluginModelBase)base);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._base == null ? 0 : this._base.hashCode());
        result = 31 * result + (this._previousBundleId == null ? 0 : this._previousBundleId.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof IPlatformBundle)) {
            return false;
        }
        return this.getPluginModelBase() == ((IPlatformBundle)object).getPluginModelBase();
    }

    @Override
    public String getBundleId() {
        return BundleHelper.getBundleId((IPluginModelBase)this.getPluginModelBase());
    }

    @Override
    public String getPreviousBundleId() {
        return this._previousBundleId;
    }

    @Override
    public IPluginBase getPluginBase() {
        return this.getPluginModelBase().getPluginBase();
    }

    @Override
    public IPluginModelBase getPluginModelBase() {
        return this._base;
    }

    @Override
    public boolean isFragment() {
        return this.getPluginModelBase().isFragmentModel();
    }

    @Override
    public IProject getProject() {
        if (!this.isTarget()) {
            return this.getPluginModelBase().getUnderlyingResource().getProject();
        }
        return null;
    }

    @Override
    public Bundle getBundle() {
        if (this.isTarget()) {
            return Platform.getBundle((String)this.getBundleId());
        }
        return null;
    }

    @Override
    public BundleDescription getBundleDescription() {
        return this.getPluginModelBase().getBundleDescription();
    }

    @Override
    public boolean isTarget() {
        return this.getPluginModelBase().getUnderlyingResource() == null;
    }

    @Override
    public void addPlatformExtensionPoint(Class<? extends IPlatformExtensionPoint> clazz, IPluginExtension extension) {
        if (extension == null || extension.getPluginModel() == null) {
            return;
        }
        IPluginObject[] iPluginObjectArray = extension.getChildren();
        int n = iPluginObjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginObject pluginObject = iPluginObjectArray[n2];
            if (pluginObject instanceof IPluginElement) {
                this.addPlatformExtensionPoint(clazz, (IPluginElement)pluginObject);
            }
            ++n2;
        }
    }

    private <T extends IPlatformExtensionPoint> T addPlatformExtensionPoint(Class<T> clazz, IPluginElement pluginElement) {
        T extensionPoint;
        block9: {
            Map<String, Object> extensionPoints;
            block8: {
                if (pluginElement == null) {
                    return null;
                }
                if (!pluginElement.isValid()) {
                    EGFPlatformPlugin.getDefault().logWarning(NLS.bind((String)"PlatformPlugin.addPlatformExtensionPoint(..) _ Bundle ''{0}'' invalid PluginElement ''{1}''.", (Object)this.getBundleId(), (Object)pluginElement.getName()));
                    return null;
                }
                IPlatformExtensionPointFactory<T> extensionPointFactory = PlatformBundle.getPlatformExtensionPointFactory(clazz);
                if (extensionPointFactory == null) {
                    return null;
                }
                extensionPoint = extensionPointFactory.createExtensionPoint(this, pluginElement);
                if (extensionPoint == null) {
                    return null;
                }
                extensionPoints = this._extensions.get(clazz);
                if (extensionPoints == null) {
                    extensionPoints = new HashMap<String, Object>();
                    this._extensions.put(clazz, extensionPoints);
                }
                try {
                    if (extensionPoints.get(extensionPoint.getId()) == null) break block8;
                    EGFPlatformPlugin.getDefault().logWarning(NLS.bind((String)"PlatformPlugin.addPlatformExtensionPoint(..) _ Bundle ''{0}'' already contains such Extension Point ''{1}''.", (Object)this.getBundleId(), (Object)extensionPoint.getId()));
                }
                catch (Throwable t) {
                    EGFPlatformPlugin.getDefault().logError("PlatformPlugin.addPlatformExtensionPoint(..)", t);
                    return null;
                }
                return null;
            }
            if (extensionPoints.put(extensionPoint.getId(), extensionPoint) == null) break block9;
            EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"PlatformPlugin.addPlatformExtensionPoint(..) _ Bundle ''{0}'' unable to add Extension Point ''{1}''.", (Object)this.getBundleId(), (Object)extensionPoint.getId()));
            return null;
        }
        return (T)((IPlatformExtensionPoint)clazz.cast(extensionPoint));
    }

    @Override
    public void addPlatformExtensionPoint(Class<? extends IPlatformExtensionPoint> clazz, IPlatformExtensionPoint extensionPoint) {
        if (extensionPoint == null) {
            return;
        }
        Map<String, Object> extensionPoints = this._extensions.get(clazz);
        if (extensionPoints == null) {
            extensionPoints = new HashMap<String, Object>();
            this._extensions.put(clazz, extensionPoints);
        }
        try {
            if (extensionPoints.get(extensionPoint.getId()) != null) {
                EGFPlatformPlugin.getDefault().logWarning(NLS.bind((String)"PlatformPlugin.addPlatformExtensionPoint(..) _ Bundle ''{0}'' already contains such Extension Point ''{1}''.", (Object)this.getBundleId(), (Object)extensionPoint.getId()));
            }
            if (extensionPoints.put(extensionPoint.getId(), extensionPoint) != null) {
                EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"PlatformPlugin.addPlatformExtensionPoint(..) _ Bundle ''{0}'' unable to add Extension Point ''{1}''.", (Object)this.getBundleId(), (Object)extensionPoint.getId()));
            }
            ((AbstractPlatformExtensionPoint)((Object)extensionPoint)).setPlatformBundle(this);
        }
        catch (Throwable t) {
            EGFPlatformPlugin.getDefault().logError("PlatformPlugin.addPlatformExtensionPoint(..)", t);
        }
    }

    @Override
    public IPlatformExtensionPoint[] getPlatformExtensionPoints() {
        ArrayList<Object> extensionPoints = new ArrayList<Object>();
        for (Map<String, Object> extensionPoint : this._extensions.values()) {
            extensionPoints.addAll(extensionPoint.values());
        }
        return extensionPoints.toArray(new IPlatformExtensionPoint[extensionPoints.size()]);
    }

    @Override
    public <T extends IPlatformExtensionPoint> T[] getPlatformExtensionPoints(Class<T> clazz) {
        Map<String, Object> extensions;
        ArrayList<Object> extensionPoints = new ArrayList<Object>();
        if (clazz != null && EGFPlatformPlugin.getPlatformExtensionPointClasses().contains(clazz) && (extensions = this._extensions.get(clazz)) != null) {
            extensionPoints.addAll(extensions.values());
        }
        return (IPlatformExtensionPoint[])CollectionHelper.toArray(extensionPoints, clazz);
    }

    @Override
    public boolean removePlatformExtensionPoint(Class<? extends IPlatformExtensionPoint> clazz, IPlatformExtensionPoint extensionPoint) {
        if (clazz == null || !EGFPlatformPlugin.getPlatformExtensionPointClasses().contains(clazz) || extensionPoint == null) {
            return false;
        }
        if (this._extensions.get(clazz) != null && this._extensions.get(clazz).remove(extensionPoint.getId()) != null) {
            ((AbstractPlatformExtensionPoint)((Object)extensionPoint)).dispose();
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        for (Class<? extends IPlatformExtensionPoint> clazz : EGFPlatformPlugin.getPlatformExtensionPointClasses()) {
            if (this._extensions.get(clazz) == null || this._extensions.get(clazz).size() <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasPlatformExtensionPoint(IPlatformExtensionPoint extensionPoint) {
        if (extensionPoint == null) {
            return false;
        }
        for (Class<? extends IPlatformExtensionPoint> clazz : EGFPlatformPlugin.getPlatformExtensionPointClasses()) {
            if (!this.hasPlatformExtensionPoint(clazz, extensionPoint)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasPlatformExtensionPoint(Class<? extends IPlatformExtensionPoint> clazz, IPlatformExtensionPoint extensionPoint) {
        if (clazz == null || !EGFPlatformPlugin.getPlatformExtensionPointClasses().contains(clazz) || extensionPoint == null) {
            return false;
        }
        return this._extensions.get(clazz) != null && this._extensions.get(clazz).get(extensionPoint.getId()) != null;
    }

    @Override
    public String getInstallLocation() {
        return this.getPluginModelBase().getInstallLocation();
    }

    @Override
    public URI getUnrootedBase() {
        return URI.createURI((String)("platform:/plugin/" + this.getBundleId()));
    }

    @Override
    public URI getRootedBase() {
        return URI.createURI((String)("platform:/plugin/" + this.getBundleId() + "/"));
    }

    public String toString() {
        IPluginBase pluginBase = this.getPluginModelBase().getPluginBase();
        String id = this.getBundleId();
        String previousId = this.getPreviousBundleId();
        String version = pluginBase.getVersion();
        StringBuilder text = new StringBuilder();
        if (version != null && version.length() > 0) {
            text.append(id).append(" ").append(pluginBase.getVersion());
        } else {
            text.append(id);
        }
        if (!id.equals(previousId)) {
            text.append(" PreviousId: ").append(previousId);
        }
        if (pluginBase.getModel() != null && !pluginBase.getModel().isInSync()) {
            text.append(" ").append(CorePlatformMessages.PlatformManager_outOfSync);
        }
        if (this.isTarget()) {
            text.append(" [Target]");
        } else {
            text.append(" [Workspace]");
        }
        if (this.getInstallLocation() != null) {
            text.append(" [").append(this.getInstallLocation()).append("]");
        }
        return text.toString();
    }
}

