/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.platform.internal.pde;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.egf.common.helper.CollectionHelper;
import org.eclipse.egf.core.platform.EGFPlatformPlugin;
import org.eclipse.egf.core.platform.internal.pde.PlatformBundle;
import org.eclipse.egf.core.platform.internal.pde.PlatformExtensionPointDelta;
import org.eclipse.egf.core.platform.pde.IPlatformBundle;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPoint;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointDelta;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointListener;
import org.eclipse.egf.core.platform.pde.IPlatformManager;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.IExtensionDeltaEvent;
import org.eclipse.pde.internal.core.IExtensionDeltaListener;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelDelta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PlatformManager
implements IPlatformManager,
IPluginModelListener,
IExtensionDeltaListener {
    private Object __lockPlatformManager = new Object();
    private Map<String, IPlatformBundle> _platformBundles;
    private Map<Class<?>, List<Object>> _workspaceRegistry;
    private Map<Class<?>, List<Object>> _targetRegistry;
    private List<IPlatformExtensionPointListener> _listeners;

    public PlatformManager() {
        this.initialize();
        PDECore.getDefault().getModelManager().addPluginModelListener((IPluginModelListener)this);
        PDECore.getDefault().getModelManager().addExtensionDeltaListener((IExtensionDeltaListener)this);
    }

    public void dispose() {
        PDECore.getDefault().getModelManager().removePluginModelListener((IPluginModelListener)this);
        PDECore.getDefault().getModelManager().removeExtensionDeltaListener((IExtensionDeltaListener)this);
        if (this._platformBundles != null) {
            this._platformBundles.clear();
        }
        if (this._targetRegistry != null) {
            this._targetRegistry.clear();
        }
        if (this._workspaceRegistry != null) {
            this._workspaceRegistry.clear();
        }
        if (this._listeners != null) {
            this._listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPlatformBundle getPlatformBundle(String id) {
        if (id == null) {
            return null;
        }
        Object object = this.__lockPlatformManager;
        synchronized (object) {
            return this._platformBundles.get(id);
        }
    }

    @Override
    public IPlatformBundle getPlatformBundle(IPluginModelBase base) {
        if (base == null) {
            return null;
        }
        String id = BundleHelper.getBundleId((IPluginModelBase)base);
        if (id == null) {
            return null;
        }
        return this.getPlatformBundle(id);
    }

    @Override
    public IPlatformBundle getPlatformBundle(IProject project) {
        if (project == null) {
            return null;
        }
        IPluginModelBase base = BundleHelper.getPluginModelBase((IProject)project);
        if (base == null) {
            return null;
        }
        String id = BundleHelper.getBundleId((IPluginModelBase)base);
        if (id == null) {
            return null;
        }
        return this.getPlatformBundle(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPlatformBundle[] getPlatformBundles() {
        Object object = this.__lockPlatformManager;
        synchronized (object) {
            return this._platformBundles.values().toArray(new IPlatformBundle[this._platformBundles.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IPlatformExtensionPoint> T[] getWorkspacePlatformExtensionPoints(Class<T> clazz) {
        Object object = this.__lockPlatformManager;
        synchronized (object) {
            ArrayList extensionPoints = new ArrayList();
            if (clazz != null && this._workspaceRegistry.get(clazz) != null) {
                extensionPoints.addAll(this._workspaceRegistry.get(clazz));
            }
            return (IPlatformExtensionPoint[])CollectionHelper.toArray(extensionPoints, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IPlatformExtensionPoint> T[] getTargetPlatformExtensionPoints(Class<T> clazz) {
        Object object = this.__lockPlatformManager;
        synchronized (object) {
            ArrayList extensionPoints = new ArrayList();
            if (clazz != null && this._targetRegistry.get(clazz) != null) {
                extensionPoints.addAll(this._targetRegistry.get(clazz));
            }
            return (IPlatformExtensionPoint[])CollectionHelper.toArray(extensionPoints, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IPlatformExtensionPoint> T[] getPlatformExtensionPoints(Class<T> clazz) {
        Object object = this.__lockPlatformManager;
        synchronized (object) {
            block4: {
                if (clazz != null && EGFPlatformPlugin.getPlatformExtensionPointClasses().contains(clazz)) break block4;
                return null;
            }
            IPlatformExtensionPoint[] targetExtensionPoints = this.getTargetPlatformExtensionPoints(clazz);
            IPlatformExtensionPoint[] workspaceExtensionPoints = this.getWorkspacePlatformExtensionPoints(clazz);
            IPlatformExtensionPoint[] extensionPoints = (IPlatformExtensionPoint[])Array.newInstance(clazz, targetExtensionPoints.length + workspaceExtensionPoints.length);
            System.arraycopy(targetExtensionPoints, 0, extensionPoints, 0, targetExtensionPoints.length);
            System.arraycopy(workspaceExtensionPoints, 0, extensionPoints, targetExtensionPoints.length, workspaceExtensionPoints.length);
            return extensionPoints;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IPlatformExtensionPoint> T[] getPlatformExtensionPoints(IProject project, Class<T> clazz) {
        Object object = this.__lockPlatformManager;
        synchronized (object) {
            IPlatformBundle platformBundle;
            if (project != null && clazz != null && EGFPlatformPlugin.getPlatformExtensionPointClasses().contains(clazz) && (platformBundle = this.getPlatformBundle(project)) != null) {
                return platformBundle.getPlatformExtensionPoints(clazz);
            }
            return (IPlatformExtensionPoint[])CollectionHelper.toArray(new ArrayList(0), clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IPlatformExtensionPoint> T[] getPlatformExtensionPoints(String id, Class<T> clazz) {
        Object object = this.__lockPlatformManager;
        synchronized (object) {
            IPlatformBundle platformBundle;
            if (id != null && clazz != null && EGFPlatformPlugin.getPlatformExtensionPointClasses().contains(clazz) && (platformBundle = this._platformBundles.get(id)) != null) {
                return platformBundle.getPlatformExtensionPoints(clazz);
            }
            return (IPlatformExtensionPoint[])CollectionHelper.toArray(new ArrayList(0), clazz);
        }
    }

    private void initialize() {
        if (this._platformBundles != null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        IPluginModelBase[] models = PluginRegistry.getActiveModels((boolean)true);
        this._platformBundles = new TreeMap<String, IPlatformBundle>();
        this._workspaceRegistry = new HashMap();
        this._targetRegistry = new HashMap();
        IPluginModelBase[] iPluginModelBaseArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase base = iPluginModelBaseArray[n2];
            this.addPlatformBundle(BundleHelper.getBundleId((IPluginModelBase)base), this.createPlatformBundle(base), null);
            ++n2;
        }
        long endTime = System.currentTimeMillis();
        if (EGFPlatformPlugin.getDefault().isDebugging()) {
            long time = endTime - startTime;
            EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"PlatformManager _ found {0} Platform Bundle{1} in ''{2}'' ms", (Object[])new Object[]{this._platformBundles.size(), this._platformBundles.size() < 2 ? "" : "s", time}));
            for (Class<? extends IPlatformExtensionPoint> clazz : EGFPlatformPlugin.getPlatformExtensionPointClasses()) {
                List<Object> workspaceObjects;
                int workspace;
                List<Object> targetObjects = this._targetRegistry.get(clazz);
                int target = targetObjects != null ? targetObjects.size() : 0;
                int extension = target + (workspace = (workspaceObjects = this._workspaceRegistry.get(clazz)) != null ? workspaceObjects.size() : 0);
                if (extension == 0) continue;
                EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"{0} Extension{1} ''{2}''", (Object[])new Object[]{extension, extension < 2 ? "" : "s", clazz.getName()}), 1);
                if (target != 0) {
                    EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"{0} target Extension{1}", (Object[])new Object[]{target, target < 2 ? "" : "s", clazz.getName()}), 2);
                }
                if (workspace == 0) continue;
                EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"{0} workspace Extension{1}", (Object[])new Object[]{workspace, workspace < 2 ? "" : "s", clazz.getName()}), 2);
            }
        }
    }

    private void firePlatformExtensionPoint(IPlatformExtensionPointDelta delta) {
        if (this._listeners != null) {
            for (IPlatformExtensionPointListener listener : this._listeners) {
                listener.platformExtensionPointChanged(delta);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPlatformExtensionPointListener(IPlatformExtensionPointListener listener) {
        Object object = this.__lockPlatformManager;
        synchronized (object) {
            if (this._listeners == null) {
                this._listeners = new ArrayList<IPlatformExtensionPointListener>();
            }
            if (!this._listeners.contains(listener)) {
                this._listeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePlatformExtensionPointListener(IPlatformExtensionPointListener listener) {
        Object object = this.__lockPlatformManager;
        synchronized (object) {
            if (this._listeners == null) {
                return;
            }
            this._listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extensionsChanged(IExtensionDeltaEvent event) {
        Object object = this.__lockPlatformManager;
        synchronized (object) {
            IPlatformBundle existingPlatformBundle;
            String id;
            IPluginModelBase base;
            PlatformExtensionPointDelta delta = new PlatformExtensionPointDelta();
            IPluginModelBase[] iPluginModelBaseArray = event.getRemovedModels();
            int n = iPluginModelBaseArray.length;
            int n2 = 0;
            while (n2 < n) {
                base = iPluginModelBaseArray[n2];
                id = BundleHelper.getBundleId((IPluginModelBase)base);
                if (id != null && (existingPlatformBundle = this._platformBundles.get(id)) != null && base.equals(existingPlatformBundle.getPluginModelBase())) {
                    this.removePlatformBundle(id, existingPlatformBundle, delta);
                }
                ++n2;
            }
            iPluginModelBaseArray = event.getChangedModels();
            n = iPluginModelBaseArray.length;
            n2 = 0;
            while (n2 < n) {
                base = iPluginModelBaseArray[n2];
                this.handleChange(base, delta);
                ++n2;
            }
            iPluginModelBaseArray = event.getAddedModels();
            n = iPluginModelBaseArray.length;
            n2 = 0;
            while (n2 < n) {
                base = iPluginModelBaseArray[n2];
                id = BundleHelper.getBundleId((IPluginModelBase)base);
                if (id != null) {
                    existingPlatformBundle = this._platformBundles.get(id);
                    if (existingPlatformBundle != null && !base.equals(existingPlatformBundle.getPluginModelBase())) {
                        this.removePlatformBundle(id, existingPlatformBundle, delta);
                    }
                    this.addPlatformBundle(id, this.createPlatformBundle(base), delta);
                }
                ++n2;
            }
            if (!delta.isEmpty()) {
                if (EGFPlatformPlugin.getDefault().isDebugging()) {
                    this.trace(delta);
                }
                this.firePlatformExtensionPoint(delta);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modelsChanged(PluginModelDelta event) {
        Object object = this.__lockPlatformManager;
        synchronized (object) {
            ModelEntry entry;
            int n;
            int n2;
            ModelEntry[] modelEntryArray;
            PlatformExtensionPointDelta delta = new PlatformExtensionPointDelta();
            if ((event.getKind() & 2) != 0) {
                modelEntryArray = event.getRemovedEntries();
                n2 = modelEntryArray.length;
                n = 0;
                while (n < n2) {
                    IPlatformBundle existingPlatformBundle;
                    entry = modelEntryArray[n];
                    String id = entry.getId();
                    if (id != null && (existingPlatformBundle = this._platformBundles.get(id)) != null) {
                        this.removePlatformBundle(id, existingPlatformBundle, delta);
                    }
                    ++n;
                }
            }
            if ((event.getKind() & 1) != 0) {
                modelEntryArray = event.getAddedEntries();
                n2 = modelEntryArray.length;
                n = 0;
                while (n < n2) {
                    entry = modelEntryArray[n];
                    for (IPluginModelBase base : this.getExtensionPointModels(entry)) {
                        String id = BundleHelper.getBundleId((IPluginModelBase)base);
                        if (id == null) continue;
                        IPlatformBundle existingPlatformBundle = this._platformBundles.get(id);
                        if (existingPlatformBundle != null && !base.equals(existingPlatformBundle.getPluginModelBase())) {
                            this.removePlatformBundle(id, existingPlatformBundle, delta);
                        }
                        this.addPlatformBundle(id, this.createPlatformBundle(base), delta);
                    }
                    ++n;
                }
            }
            if ((event.getKind() & 4) != 0) {
                modelEntryArray = event.getChangedEntries();
                n2 = modelEntryArray.length;
                n = 0;
                while (n < n2) {
                    entry = modelEntryArray[n];
                    for (IPluginModelBase base : this.getExtensionPointModels(entry)) {
                        this.handleChange(base, delta);
                    }
                    ++n;
                }
            }
            if (!delta.isEmpty()) {
                if (EGFPlatformPlugin.getDefault().isDebugging()) {
                    this.trace(delta);
                }
                this.firePlatformExtensionPoint(delta);
            }
        }
    }

    private IPlatformBundle createPlatformBundle(IPluginModelBase base) {
        PlatformBundle platformBundle = new PlatformBundle(base);
        IPluginExtension[] iPluginExtensionArray = base.getExtensions(false).getExtensions();
        int n = iPluginExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginExtension extension = iPluginExtensionArray[n2];
            Class<? extends IPlatformExtensionPoint> clazz = EGFPlatformPlugin.getPlatformExtensionPoints().get(extension.getPoint());
            if (clazz != null) {
                platformBundle.addPlatformExtensionPoint(clazz, extension);
            }
            ++n2;
        }
        return platformBundle;
    }

    private void handleChange(IPluginModelBase base, PlatformExtensionPointDelta delta) {
        String id = BundleHelper.getBundleId((IPluginModelBase)base);
        IPlatformBundle existingPlatformBundle = this._platformBundles.get(id);
        if (base.isEnabled()) {
            if (existingPlatformBundle != null && base == existingPlatformBundle.getPluginModelBase()) {
                this.mergePlatformBundle(existingPlatformBundle, this.createPlatformBundle(base), delta);
            } else {
                if (existingPlatformBundle != null && base != existingPlatformBundle.getPluginModelBase()) {
                    this.removePlatformBundle(id, existingPlatformBundle, delta);
                }
                this.addPlatformBundle(id, this.createPlatformBundle(base), delta);
            }
        } else {
            this.removePlatformBundle(id, existingPlatformBundle, delta);
        }
    }

    private void mergePlatformBundle(IPlatformBundle existingPlatformBundle, IPlatformBundle newPlatformBundle, PlatformExtensionPointDelta delta) {
        if (existingPlatformBundle == null || newPlatformBundle == null) {
            return;
        }
        for (Class<? extends IPlatformExtensionPoint> clazz : EGFPlatformPlugin.getPlatformExtensionPointClasses()) {
            int n;
            int n2;
            IPlatformExtensionPoint[] iPlatformExtensionPointArray;
            IPlatformExtensionPoint[] iPlatformExtensionPointArray2 = existingPlatformBundle.getPlatformExtensionPoints(clazz);
            int n3 = iPlatformExtensionPointArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                block28: {
                    IPlatformExtensionPoint existingExtensionPoint = iPlatformExtensionPointArray2[n4];
                    iPlatformExtensionPointArray = newPlatformBundle.getPlatformExtensionPoints(clazz);
                    n2 = iPlatformExtensionPointArray.length;
                    n = 0;
                    while (n < n2) {
                        IPlatformExtensionPoint newExtensionPoint = iPlatformExtensionPointArray[n];
                        if (!existingExtensionPoint.equals(newExtensionPoint)) {
                            ++n;
                            continue;
                        }
                        break block28;
                    }
                    if (!existingPlatformBundle.removePlatformExtensionPoint(clazz, existingExtensionPoint)) {
                        EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"PlatformManager.mergePlatformBundle(..) _ ''{0}'' unable to remove Extension Point from PlatformBundle.", (Object)existingExtensionPoint));
                    }
                    if (existingPlatformBundle.isTarget()) {
                        if (this._targetRegistry.get(clazz).remove(existingExtensionPoint)) {
                            if (this._targetRegistry.get(clazz).isEmpty()) {
                                this._targetRegistry.remove(clazz);
                            }
                            if (delta != null) {
                                delta.storeRemovedPlatformExtensionPoint(clazz, existingExtensionPoint);
                            }
                        }
                    } else if (this._workspaceRegistry.get(clazz).remove(existingExtensionPoint)) {
                        if (this._workspaceRegistry.get(clazz).isEmpty()) {
                            this._workspaceRegistry.remove(clazz);
                        }
                        if (delta != null) {
                            delta.storeRemovedPlatformExtensionPoint(clazz, existingExtensionPoint);
                        }
                    }
                }
                ++n4;
            }
            iPlatformExtensionPointArray2 = newPlatformBundle.getPlatformExtensionPoints(clazz);
            n3 = iPlatformExtensionPointArray2.length;
            n4 = 0;
            while (n4 < n3) {
                block29: {
                    List<Object> extensionPoints;
                    IPlatformExtensionPoint newExtensionPoint = iPlatformExtensionPointArray2[n4];
                    iPlatformExtensionPointArray = existingPlatformBundle.getPlatformExtensionPoints(clazz);
                    n2 = iPlatformExtensionPointArray.length;
                    n = 0;
                    while (n < n2) {
                        IPlatformExtensionPoint existingExtensionPoint = iPlatformExtensionPointArray[n];
                        if (!existingExtensionPoint.equals(newExtensionPoint)) {
                            ++n;
                            continue;
                        }
                        break block29;
                    }
                    existingPlatformBundle.addPlatformExtensionPoint(clazz, newExtensionPoint);
                    if (existingPlatformBundle.isTarget()) {
                        extensionPoints = this._targetRegistry.get(clazz);
                        if (extensionPoints == null) {
                            extensionPoints = new ArrayList<Object>();
                            this._targetRegistry.put(clazz, extensionPoints);
                        }
                        if (!extensionPoints.add(newExtensionPoint)) {
                            EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"PlatformManager.mergePlatformBundle(..) _ ''{0}'' unable to add Extension Point in target registry.", (Object)newExtensionPoint));
                        } else if (delta != null) {
                            delta.storeAddedPlatformExtensionPoint(clazz, newExtensionPoint);
                        }
                    } else {
                        extensionPoints = this._workspaceRegistry.get(clazz);
                        if (extensionPoints == null) {
                            extensionPoints = new ArrayList<Object>();
                            this._workspaceRegistry.put(clazz, extensionPoints);
                        }
                        if (!extensionPoints.add(newExtensionPoint)) {
                            EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"PlatformManager.mergePlatformBundle(..) _ ''{0}'' unable to add Extension Point in workspace registry.", (Object)newExtensionPoint));
                        } else if (delta != null) {
                            delta.storeAddedPlatformExtensionPoint(clazz, newExtensionPoint);
                        }
                    }
                }
                ++n4;
            }
        }
        if (existingPlatformBundle.isEmpty() && !existingPlatformBundle.equals(this._platformBundles.remove(existingPlatformBundle.getBundleId()))) {
            EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"PlatformManager.mergePlatformBundle(..) _ ''{0}'' unknown PlatformBundle.", (Object)existingPlatformBundle.getBundleId()));
        }
    }

    private void removePlatformBundle(String id, IPlatformBundle platformBundle, PlatformExtensionPointDelta delta) {
        if (id == null || platformBundle == null) {
            return;
        }
        if (!platformBundle.equals(this._platformBundles.remove(id))) {
            EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"PlatformManager.removePlatformBundle(..) _ ''{0}'' unknown PlatformBundle.", (Object)id));
        }
        for (Class<? extends IPlatformExtensionPoint> clazz : EGFPlatformPlugin.getPlatformExtensionPointClasses()) {
            IPlatformExtensionPoint[] iPlatformExtensionPointArray = platformBundle.getPlatformExtensionPoints(clazz);
            int n = iPlatformExtensionPointArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPlatformExtensionPoint extensionPoint = iPlatformExtensionPointArray[n2];
                if (platformBundle.isTarget()) {
                    if (this._targetRegistry.get(clazz).remove(extensionPoint)) {
                        if (this._targetRegistry.get(clazz).isEmpty()) {
                            this._targetRegistry.remove(clazz);
                        }
                        if (delta != null) {
                            delta.storeRemovedPlatformExtensionPoint(clazz, extensionPoint);
                        }
                    }
                } else if (this._workspaceRegistry.get(clazz).remove(extensionPoint)) {
                    if (this._workspaceRegistry.get(clazz).isEmpty()) {
                        this._workspaceRegistry.remove(clazz);
                    }
                    if (delta != null) {
                        delta.storeRemovedPlatformExtensionPoint(clazz, extensionPoint);
                    }
                }
                ++n2;
            }
        }
    }

    private void addPlatformBundle(String id, IPlatformBundle newPlatformBundle, PlatformExtensionPointDelta delta) {
        if (id == null || newPlatformBundle == null || newPlatformBundle.isEmpty()) {
            return;
        }
        IPlatformBundle existingPlatformBundle = this._platformBundles.get(id);
        if (existingPlatformBundle != null) {
            return;
        }
        this._platformBundles.put(id, newPlatformBundle);
        for (Class<? extends IPlatformExtensionPoint> clazz : EGFPlatformPlugin.getPlatformExtensionPointClasses()) {
            IPlatformExtensionPoint[] iPlatformExtensionPointArray = newPlatformBundle.getPlatformExtensionPoints(clazz);
            int n = iPlatformExtensionPointArray.length;
            int n2 = 0;
            while (n2 < n) {
                List<Object> extensionPoints;
                IPlatformExtensionPoint extensionPoint = iPlatformExtensionPointArray[n2];
                if (newPlatformBundle.isTarget()) {
                    extensionPoints = this._targetRegistry.get(clazz);
                    if (extensionPoints == null) {
                        extensionPoints = new ArrayList<Object>();
                        this._targetRegistry.put(clazz, extensionPoints);
                    }
                    if (!extensionPoints.add(extensionPoint)) {
                        EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"PlatformManager.addPlatformBundle(..) _ ''{0}'' unable to add Extension Point in target registry.", (Object)extensionPoint.getId()));
                    } else if (delta != null) {
                        delta.storeAddedPlatformExtensionPoint(clazz, extensionPoint);
                    }
                } else {
                    extensionPoints = this._workspaceRegistry.get(clazz);
                    if (extensionPoints == null) {
                        extensionPoints = new ArrayList<Object>();
                        this._workspaceRegistry.put(clazz, extensionPoints);
                    }
                    if (!extensionPoints.add(extensionPoint)) {
                        EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"PlatformManager.addPlatformBundle(..) _ ''{0}'' unable to add Extension Point in workspace registry.", (Object)extensionPoint.getId()));
                    } else if (delta != null) {
                        delta.storeAddedPlatformExtensionPoint(clazz, extensionPoint);
                    }
                }
                ++n2;
            }
        }
    }

    private List<IPluginModelBase> getExtensionPointModels(ModelEntry entry) {
        UniqueEList plugins = new UniqueEList();
        IPluginModelBase[] iPluginModelBaseArray = entry.hasWorkspaceModels() ? entry.getWorkspaceModels() : entry.getExternalModels();
        int n = iPluginModelBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            if (model.getExtensions(false) != null && model.getExtensions(false).getExtensions() != null) {
                IPluginExtension[] iPluginExtensionArray = model.getExtensions(false).getExtensions();
                int n3 = iPluginExtensionArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IPluginExtension extension = iPluginExtensionArray[n4];
                    Class<? extends IPlatformExtensionPoint> clazz = EGFPlatformPlugin.getPlatformExtensionPoints().get(extension.getPoint());
                    if (clazz != null) {
                        plugins.add(model);
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return plugins;
    }

    private void trace(IPlatformExtensionPointDelta delta) {
        IPlatformExtensionPoint[] workspace;
        IPlatformExtensionPoint[] target;
        IPlatformExtensionPoint[] added = delta.getAddedPlatformExtensionPoints();
        IPlatformExtensionPoint[] removed = delta.getRemovedPlatformExtensionPoints();
        if (removed.length != 0) {
            target = delta.getTargetRemovedPlatformExtensionPoints();
            if (target.length != 0) {
                EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"PlatformManager removed {0} target Extension{1}.", (Object)target.length, (Object)(target.length < 2 ? "" : "s")));
            }
            if ((workspace = delta.getWorkspaceRemovedPlatformExtensionPoints()).length != 0) {
                EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"PlatformManager removed {0} workspace Extension{1}.", (Object)workspace.length, (Object)(workspace.length < 2 ? "" : "s")));
            }
        }
        if (added.length != 0) {
            target = delta.getTargetAddedPlatformExtensionPoints();
            if (target.length != 0) {
                EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"PlatformManager added {0} target Extension{1}.", (Object)target.length, (Object)(target.length < 2 ? "" : "s")));
            }
            if ((workspace = delta.getWorkspaceAddedPlatformExtensionPoints()).length != 0) {
                EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"PlatformManager added {0} workspace Extension{1}.", (Object)workspace.length, (Object)(workspace.length < 2 ? "" : "s")));
            }
        }
    }
}

