/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.ui;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.emf.importer.l10n.TargetPlatformEMFImporterMessages;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.importer.ui.EMFModelWizard;
import org.eclipse.emf.importer.ui.contribution.ModelImporterDescriptor;
import org.eclipse.emf.importer.ui.contribution.ModelImporterManager;

public class TargetPlatformEMFModelWizard
extends EMFModelWizard {
    public TargetPlatformEMFModelWizard() {
        this.setWindowTitle(TargetPlatformEMFImporterMessages._UI_EMFWizardModel_title);
    }

    public TargetPlatformEMFModelWizard(IFile reloadFile) {
        super(reloadFile);
        this.setWindowTitle(TargetPlatformEMFImporterMessages._UI_ReloadWizard_title);
    }

    protected ModelImporterDescriptor computeSuggestedDescriptor() {
        Object element;
        ModelImporterDescriptor descriptor = null;
        if (this.defaultDescriptorID != null && (descriptor = ModelImporterManager.INSTANCE.getModelImporterDescriptor(this.defaultDescriptorID)) != null) {
            return descriptor;
        }
        if (this.reloadFile != null) {
            Object content;
            URI reloadURI = URI.createPlatformResourceURI((String)this.reloadFile.getFullPath().toString(), (boolean)true);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resourceSet.setURIConverter((URIConverter)EGFCorePlugin.getTargetPlatformURIConverter());
            Resource reloadResource = null;
            try {
                reloadResource = resourceSet.getResource(reloadURI, true);
            }
            catch (RuntimeException e) {
                reloadResource = resourceSet.getResource(reloadURI, false);
            }
            if (reloadResource != null && !reloadResource.getContents().isEmpty() && (content = reloadResource.getContents().get(0)) instanceof GenModel) {
                GenModel genModel = (GenModel)content;
                if (genModel.getImporterID() != null) {
                    descriptor = ModelImporterManager.INSTANCE.getModelImporterDescriptor(genModel.getImporterID());
                } else if (!genModel.getForeignModel().isEmpty()) {
                    String foreignModel = (String)genModel.getForeignModel().get(0);
                    if (foreignModel.endsWith(".mdl")) {
                        descriptor = ModelImporterManager.INSTANCE.getModelImporterDescriptor("org.eclipse.emf.importer.rose");
                    } else if (foreignModel.endsWith(".xsd") || foreignModel.endsWith(".wsdl")) {
                        descriptor = ModelImporterManager.INSTANCE.getModelImporterDescriptor("org.eclipse.xsd.ecore.importer");
                    } else if (foreignModel.endsWith("@model")) {
                        descriptor = ModelImporterManager.INSTANCE.getModelImporterDescriptor("org.eclipse.emf.importer.java");
                    } else if (foreignModel.endsWith(".ecore") || foreignModel.endsWith(".emof")) {
                        descriptor = ModelImporterManager.INSTANCE.getModelImporterDescriptor("org.eclipse.emf.importer.ecore");
                    }
                }
            }
        }
        if (descriptor == null && this.selection != null && !this.selection.isEmpty() && (element = this.selection.getFirstElement()) instanceof IFile) {
            List descriptors;
            String fileExtension = ((IFile)element).getFileExtension();
            descriptor = ModelImporterManager.INSTANCE.getModelImporterDescriptor(this.selectionPage.getLastModelConverterDescriptorId());
            if (!(descriptor != null && descriptor.getExtensions().contains(fileExtension) || (descriptors = ModelImporterManager.INSTANCE.filterModelImporterDescriptors(fileExtension)).isEmpty())) {
                descriptor = (ModelImporterDescriptor)descriptors.get(0);
            }
            if (descriptor != null) {
                this.modelFile = (IFile)element;
            }
        }
        return descriptor;
    }
}

