/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.platform.internal.pde;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.registry.Handle;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.egf.common.EGFCommonPlugin;
import org.eclipse.egf.common.helper.BundleHelper;
import org.eclipse.egf.common.helper.CollectionHelper;
import org.eclipse.egf.core.platform.EGFPlatformPlugin;
import org.eclipse.egf.core.platform.internal.pde.AbstractPlatformExtensionPoint;
import org.eclipse.egf.core.platform.internal.pde.AbstractPlatformManager;
import org.eclipse.egf.core.platform.internal.pde.PlatformBundle;
import org.eclipse.egf.core.platform.internal.pde.PlatformExtensionPointDelta;
import org.eclipse.egf.core.platform.pde.IPlatformBundle;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPoint;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointDelta;
import org.eclipse.egf.core.platform.pde.IPlatformExtensionPointURI;
import org.eclipse.egf.core.platform.pde.IRuntimePlatformManager;
import org.eclipse.emf.ecore.xml.type.internal.DataValue;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RuntimePlatformManager
extends AbstractPlatformManager
implements IRuntimePlatformManager {
    private Map<String, IPlatformBundle> _bundleRegistry;
    private Map<Class<?>, Set<Object>> _runtimeRegistry;
    private Set<RuntimeRegistryListener> _registryListeners = new HashSet<RuntimeRegistryListener>();

    public RuntimePlatformManager() {
        for (Map.Entry<String, Class<? extends IPlatformExtensionPoint>> entry : EGFPlatformPlugin.getPlatformExtensionPoints().entrySet()) {
            this._registryListeners.add(new RuntimeRegistryListener(entry.getKey(), entry.getValue()));
        }
    }

    @Override
    public int getPlatformBundleSize() {
        return this._bundleRegistry.size();
    }

    @Override
    public int getPlatformExtensionPointSize() {
        int size = 0;
        for (Map.Entry<Class<?>, Set<Object>> entry : this._runtimeRegistry.entrySet()) {
            size += entry.getValue().size();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = this._lockPlatformManager;
        synchronized (object) {
            super.dispose();
            if (this._registryListeners != null) {
                for (RuntimeRegistryListener listener : this._registryListeners) {
                    listener.dispose();
                }
                this._registryListeners.clear();
            }
            if (this._bundleRegistry != null) {
                this._bundleRegistry.clear();
            }
            if (this._runtimeRegistry != null) {
                this._runtimeRegistry.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPlatformBundle getPlatformBundle(String id) {
        if (id == null) {
            return null;
        }
        Object object = this._lockPlatformManager;
        synchronized (object) {
            return this._bundleRegistry.get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IPlatformBundle[] getPlatformBundles() {
        Object object = this._lockPlatformManager;
        synchronized (object) {
            return this._bundleRegistry.values().toArray(new IPlatformBundle[this._bundleRegistry.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IPlatformExtensionPoint> T[] getPlatformExtensionPoints(Class<T> clazz) {
        Object object = this._lockPlatformManager;
        synchronized (object) {
            return RuntimePlatformManager.getPlatformExtensionPoints(this._runtimeRegistry, clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IPlatformExtensionPoint> T[] getPlatformExtensionPoints(String id, Class<T> clazz) {
        Object object = this._lockPlatformManager;
        synchronized (object) {
            IPlatformBundle platformBundle;
            if (id != null && clazz != null && EGFPlatformPlugin.getPlatformExtensionPoints().values().contains(clazz) && (platformBundle = this._bundleRegistry.get(id)) != null) {
                return platformBundle.getPlatformExtensionPoints(clazz);
            }
            return (IPlatformExtensionPoint[])CollectionHelper.toArray(new ArrayList(0), clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initialize() {
        long startRuntimeTime = System.currentTimeMillis();
        Object object = this._lockPlatformManager;
        synchronized (object) {
            this.initializeRegistry();
        }
        long endRuntimeTime = System.currentTimeMillis();
        if (EGFPlatformPlugin.getDefault().isDebugging()) {
            EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"RuntimePlatformManager _ found {0} Platform Bundle{1}, ''{2}'' Runtime Extension Point{3},in ''{4}'' ms", (Object[])new Object[]{this.getPlatformBundleSize(), this.getPlatformBundleSize() < 2 ? "" : "s", this.getPlatformExtensionPointSize(), this.getPlatformExtensionPointSize() < 2 ? "" : "s", endRuntimeTime - startRuntimeTime}));
            for (Class<? extends IPlatformExtensionPoint> clazz : EGFPlatformPlugin.getPlatformExtensionPoints().values()) {
                int extension;
                Set<Object> runtimeObjects = this._runtimeRegistry.get(clazz);
                int n = extension = runtimeObjects != null ? runtimeObjects.size() : 0;
                if (extension == 0) continue;
                EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"{0} Extension{1} ''{2}''", (Object[])new Object[]{extension, extension < 2 ? "" : "s", clazz.getName()}), 1);
            }
        }
    }

    @Override
    protected void initializeRegistry() {
        if (this._bundleRegistry != null) {
            return;
        }
        this._bundleRegistry = new HashMap<String, IPlatformBundle>();
        this._runtimeRegistry = new HashMap();
        for (Map.Entry<String, Class<? extends IPlatformExtensionPoint>> entry : EGFPlatformPlugin.getPlatformExtensionPoints().entrySet()) {
            IConfigurationElement[] elements = RegistryFactory.getRegistry().getConfigurationElementsFor(entry.getKey());
            if (elements == null) continue;
            IConfigurationElement[] iConfigurationElementArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement element = iConfigurationElementArray[n2];
                this.addElement(element, entry.getValue(), null, true);
                ++n2;
            }
        }
    }

    protected void addElement(IConfigurationElement element, Class<? extends IPlatformExtensionPoint> clazz, PlatformExtensionPointDelta delta, boolean init) {
        IPlatformExtensionPoint extensionPoint;
        IContributor contributor;
        Bundle bundle = BundleHelper.getBundle((IContributor)element.getDeclaringExtension().getContributor());
        if (bundle == null && element.isValid() && (contributor = element.getDeclaringExtension().getContributor()) instanceof RegistryContributor) {
            try {
                long id = Long.parseLong(((RegistryContributor)contributor).getActualId());
                BundleContext context = EGFCommonPlugin.getDefault().getBundle().getBundleContext();
                if (context != null && (bundle = context.getBundle(id)) == null && (bundle = Platform.getBundle((String)contributor.getName())) != null) {
                    try {
                        bundle.start(1);
                    }
                    catch (BundleException e) {
                        EGFPlatformPlugin.getDefault().logError(e);
                    }
                }
            }
            catch (NumberFormatException id) {
                // empty catch block
            }
        }
        if (bundle == null || !element.isValid()) {
            return;
        }
        PlatformBundle platformBundle = (PlatformBundle)this._bundleRegistry.get(bundle.getSymbolicName());
        if (platformBundle == null) {
            platformBundle = new PlatformBundle(bundle);
        }
        if ((extensionPoint = platformBundle.createPlatformExtensionPoint(clazz, element)) == null) {
            return;
        }
        if (!init && extensionPoint instanceof AbstractPlatformExtensionPoint) {
            ((AbstractPlatformExtensionPoint)((Object)extensionPoint)).setPlatformBundle(platformBundle);
        }
        this._bundleRegistry.put(bundle.getSymbolicName(), platformBundle);
        Set<Object> objects = this._runtimeRegistry.get(clazz);
        if (objects == null) {
            objects = new HashSet<Object>();
            this._runtimeRegistry.put(clazz, objects);
        }
        objects.add(extensionPoint);
        if (delta != null) {
            delta.storeAddedPlatformExtensionPoint(clazz, extensionPoint);
        }
    }

    private void trace(IPlatformExtensionPointDelta delta) {
        IPlatformExtensionPoint extensionPoint;
        int n;
        int n2;
        IPlatformExtensionPoint[] iPlatformExtensionPointArray;
        IPlatformExtensionPoint[] runtime;
        IPlatformExtensionPoint[] added = delta.getAddedPlatformExtensionPoints();
        IPlatformExtensionPoint[] removed = delta.getRemovedPlatformExtensionPoints();
        if (removed.length != 0 && (runtime = delta.getRemovedPlatformExtensionPoints()).length != 0) {
            EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"RuntimePlatformManager removed {0} Extension{1}.", (Object)runtime.length, (Object)(runtime.length < 2 ? "" : "s")));
            iPlatformExtensionPointArray = removed;
            n2 = removed.length;
            n = 0;
            while (n < n2) {
                extensionPoint = iPlatformExtensionPointArray[n];
                if (extensionPoint instanceof IPlatformExtensionPointURI) {
                    EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"Removed {0}", (Object)DataValue.URI.encode((String)((IPlatformExtensionPointURI)extensionPoint).getURI().toString())), 1);
                } else {
                    EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"Removed {0}", (Object)extensionPoint.getId()), 1);
                }
                ++n;
            }
        }
        if (added.length != 0 && (runtime = delta.getAddedPlatformExtensionPoints()).length != 0) {
            EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"RuntimePlatformManager added {0} Extension{1}.", (Object)runtime.length, (Object)(runtime.length < 2 ? "" : "s")));
            iPlatformExtensionPointArray = added;
            n2 = added.length;
            n = 0;
            while (n < n2) {
                extensionPoint = iPlatformExtensionPointArray[n];
                if (extensionPoint instanceof IPlatformExtensionPointURI) {
                    EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"Added {0}", (Object)DataValue.URI.encode((String)((IPlatformExtensionPointURI)extensionPoint).getURI().toString())), 1);
                } else {
                    EGFPlatformPlugin.getDefault().logInfo(NLS.bind((String)"Added {0}", (Object)extensionPoint.getId()), 1);
                }
                ++n;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RuntimeRegistryListener
    implements IRegistryEventListener {
        private Class<? extends IPlatformExtensionPoint> _clazz;

        public RuntimeRegistryListener(String point, Class<? extends IPlatformExtensionPoint> clazz) {
            Assert.isNotNull((Object)point);
            Assert.isLegal((point.trim().length() != 0 ? 1 : 0) != 0);
            Assert.isNotNull(clazz);
            this._clazz = clazz;
            RegistryFactory.getRegistry().addListener((IRegistryEventListener)this, point.trim());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removed(IExtension[] extensions) {
            PlatformExtensionPointDelta delta = new PlatformExtensionPointDelta();
            Object object = RuntimePlatformManager.this._lockPlatformManager;
            synchronized (object) {
                if (extensions == null) {
                    return;
                }
                IExtension[] iExtensionArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    Iterator it = RuntimePlatformManager.this._bundleRegistry.values().iterator();
                    while (it.hasNext()) {
                        PlatformBundle bundle = (PlatformBundle)it.next();
                        IPlatformExtensionPoint[] iPlatformExtensionPointArray = bundle.getPlatformExtensionPoints(this._clazz);
                        int n3 = iPlatformExtensionPointArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IPlatformExtensionPoint extensionPoint = iPlatformExtensionPointArray[n4];
                            if (this.originatesFrom(extension, extensionPoint.getUniqueIdentifier(), extensionPoint.getHandleId())) {
                                if (!bundle.removePlatformExtensionPoint(this._clazz, extensionPoint)) {
                                    EGFPlatformPlugin.getDefault().logError(NLS.bind((String)"RuntimePlatformManager$RuntimeRegistryListener.removed(..) _ ''{0}'' unable to remove Extension Point from IPlatformBundle.", (Object)extensionPoint));
                                }
                                RuntimePlatformManager.removeExtensionPoint(extensionPoint, this._clazz, RuntimePlatformManager.this._runtimeRegistry, delta);
                            }
                            ++n4;
                        }
                        if (!bundle.isEmpty()) continue;
                        it.remove();
                    }
                    ++n2;
                }
            }
            if (!delta.isEmpty()) {
                if (EGFPlatformPlugin.getDefault().isDebugging()) {
                    RuntimePlatformManager.this.trace(delta);
                }
                RuntimePlatformManager.this.firePlatformExtensionPoint(delta);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void added(IExtension[] extensions) {
            PlatformExtensionPointDelta delta = new PlatformExtensionPointDelta();
            Object object = RuntimePlatformManager.this._lockPlatformManager;
            synchronized (object) {
                IExtension[] iExtensionArray = extensions;
                int n = extensions.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        RuntimePlatformManager.this.addElement(element, this._clazz, delta, false);
                        ++n4;
                    }
                    ++n2;
                }
            }
            if (!delta.isEmpty()) {
                if (EGFPlatformPlugin.getDefault().isDebugging()) {
                    RuntimePlatformManager.this.trace(delta);
                }
                RuntimePlatformManager.this.firePlatformExtensionPoint(delta);
            }
        }

        public void added(IExtensionPoint[] extensionPoints) {
        }

        public void removed(IExtensionPoint[] extensionPoints) {
        }

        public void dispose() {
            RegistryFactory.getRegistry().removeListener((IRegistryEventListener)this);
        }

        public boolean originatesFrom(IExtension extension, String uniqueIdentifier, int handleId) {
            String id = extension.getUniqueIdentifier();
            if (id != null) {
                return id.equals(uniqueIdentifier);
            }
            if (!(extension instanceof Handle)) {
                return false;
            }
            return handleId == ((Handle)extension).getId();
        }
    }
}

