/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.genchain.tools.utils;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.egf.model.domain.Domain;
import org.eclipse.egf.model.domain.DomainFactory;
import org.eclipse.egf.model.domain.DomainViewpoint;
import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.egf.model.domain.TypeDomain;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.Contract;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.model.fcore.FcoreFactory;
import org.eclipse.egf.model.fcore.Invocation;
import org.eclipse.egf.model.fcore.InvocationContract;
import org.eclipse.egf.model.fcore.InvocationContractContainer;
import org.eclipse.egf.model.fcore.Orchestration;
import org.eclipse.egf.model.fcore.OrchestrationParameter;
import org.eclipse.egf.model.fcore.ViewpointContainer;
import org.eclipse.egf.model.fprod.FprodFactory;
import org.eclipse.egf.model.fprod.ProductionPlan;
import org.eclipse.egf.model.fprod.ProductionPlanInvocation;
import org.eclipse.egf.model.pattern.PatternFactory;
import org.eclipse.egf.model.types.Type;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityInvocationHelper {
    public static final String GENERATION_EXTENSION_PARAMETER_NAME = "generation extension";

    public static void clearOrchestration(FactoryComponent fc) {
        ProductionPlan pp = (ProductionPlan)fc.getOrchestration();
        Object[] objectArray = pp.getInvocations().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            EcoreUtil.delete((EObject)((EObject)obj), (boolean)true);
            ++n2;
        }
    }

    public static FactoryComponent createDefaultFC(String name) {
        FactoryComponent fc = FcoreFactory.eINSTANCE.createFactoryComponent();
        fc.setName(name);
        ProductionPlan pp = FprodFactory.eINSTANCE.createProductionPlan();
        fc.setOrchestration((Orchestration)pp);
        pp.setOrchestrationParameterContainer(FcoreFactory.eINSTANCE.createOrchestrationParameterContainer());
        OrchestrationParameter parameter = FcoreFactory.eINSTANCE.createOrchestrationParameter();
        parameter.setName(GENERATION_EXTENSION_PARAMETER_NAME);
        parameter.setType((Type)PatternFactory.eINSTANCE.createTypePatternSubstitution());
        pp.getOrchestrationParameterContainer().getOrchestrationParameters().add((Object)parameter);
        ViewpointContainer viewpointContainer = FcoreFactory.eINSTANCE.createViewpointContainer();
        fc.setViewpointContainer(viewpointContainer);
        DomainViewpoint domainViewpoint = DomainFactory.eINSTANCE.createDomainViewpoint();
        viewpointContainer.getViewpoints().add((Object)domainViewpoint);
        return fc;
    }

    public static void addInvocation(ProductionPlan pp, Activity activity) {
        ActivityInvocationHelper.addInvocation(pp, activity, new HashMap<String, Type>());
    }

    public static void addInvocation(ProductionPlan pp, Activity activity, Map<String, Type> contract2type) {
        ActivityInvocationHelper.addInvocation(pp, activity, contract2type, new HashMap<String, OrchestrationParameter>());
    }

    public static EMFDomain getDomain(DomainViewpoint dvp, URI uri) {
        for (Domain domain : dvp.getDomains()) {
            EMFDomain emfDomain;
            if (!(domain instanceof EMFDomain) || !uri.equals((Object)(emfDomain = (EMFDomain)domain).getUri())) continue;
            return emfDomain;
        }
        EMFDomain emfDomain = DomainFactory.eINSTANCE.createEMFDomain();
        emfDomain.setUri(uri);
        dvp.getDomains().add((Object)emfDomain);
        return emfDomain;
    }

    public static void addInvocation(ProductionPlan pp, Activity activity, Map<String, Type> contract2type, Map<String, OrchestrationParameter> contract2parameter) {
        InvocationContract invocationContract;
        ProductionPlanInvocation productionPlanInvocation = FprodFactory.eINSTANCE.createProductionPlanInvocation();
        productionPlanInvocation.setName(String.valueOf(activity.getName()) + " invocation");
        productionPlanInvocation.setProductionPlan(pp);
        productionPlanInvocation.setInvokedActivity(activity);
        InvocationContractContainer invocationContractContainer = FcoreFactory.eINSTANCE.createInvocationContractContainer();
        invocationContractContainer.setInvocation((Invocation)productionPlanInvocation);
        for (Map.Entry<String, Type> entry : contract2type.entrySet()) {
            invocationContract = FcoreFactory.eINSTANCE.createInvocationContract();
            invocationContractContainer.getInvocationContracts().add((Object)invocationContract);
            Contract contract = activity.getContract(entry.getKey());
            if (contract == null) {
                throw new IllegalStateException();
            }
            invocationContract.setInvokedContract(contract);
            invocationContract.setType(entry.getValue());
        }
        for (Map.Entry<String, Type> entry : contract2parameter.entrySet()) {
            invocationContract = FcoreFactory.eINSTANCE.createInvocationContract();
            invocationContractContainer.getInvocationContracts().add((Object)invocationContract);
            invocationContract.setInvokedContract(activity.getContract(entry.getKey()));
            invocationContract.setOrchestrationParameter((OrchestrationParameter)entry.getValue());
        }
    }

    public static void addInvocation(ProductionPlan pp, EMFDomain genModelEMFDomain, Activity activity) {
        ProductionPlanInvocation productionPlanInvocation = FprodFactory.eINSTANCE.createProductionPlanInvocation();
        productionPlanInvocation.setName(String.valueOf(activity.getName()) + " invocation");
        productionPlanInvocation.setProductionPlan(pp);
        productionPlanInvocation.setInvokedActivity(activity);
        InvocationContractContainer invocationContractContainer = FcoreFactory.eINSTANCE.createInvocationContractContainer();
        invocationContractContainer.setInvocation((Invocation)productionPlanInvocation);
        InvocationContract invocationContract = FcoreFactory.eINSTANCE.createInvocationContract();
        invocationContractContainer.getInvocationContracts().add((Object)invocationContract);
        invocationContract.setInvokedContract((Contract)activity.getContracts().get(0));
        TypeDomain typeEMFDomain = DomainFactory.eINSTANCE.createTypeDomain();
        typeEMFDomain.setDomain((Domain)genModelEMFDomain);
        invocationContract.setType((Type)typeEMFDomain);
    }

    public static void addEEFInvocation(ProductionPlan pp, EMFDomain genModelEMFDomain, EMFDomain eefEMFDomain, Activity activity, String invocationName) {
        ProductionPlanInvocation eefGen = FprodFactory.eINSTANCE.createProductionPlanInvocation();
        eefGen.setName(invocationName);
        eefGen.setProductionPlan(pp);
        eefGen.setInvokedActivity(activity);
        InvocationContractContainer invocationContractContainer = FcoreFactory.eINSTANCE.createInvocationContractContainer();
        invocationContractContainer.setInvocation((Invocation)eefGen);
        InvocationContract invocationContract = FcoreFactory.eINSTANCE.createInvocationContract();
        invocationContract.setInvocationContractContainer(invocationContractContainer);
        invocationContract.setInvokedContract((Contract)activity.getContracts().get(0));
        TypeDomain typeEMFDomain = DomainFactory.eINSTANCE.createTypeDomain();
        typeEMFDomain.setDomain((Domain)genModelEMFDomain);
        invocationContract.setType((Type)typeEMFDomain);
        InvocationContract inContract = FcoreFactory.eINSTANCE.createInvocationContract();
        inContract.setInvocationContractContainer(invocationContractContainer);
        inContract.setInvokedContract((Contract)activity.getContracts().get(1));
        typeEMFDomain = DomainFactory.eINSTANCE.createTypeDomain();
        typeEMFDomain.setDomain((Domain)eefEMFDomain);
        inContract.setType((Type)typeEMFDomain);
    }
}

