/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.genmodel.presentation;

import java.util.ArrayList;
import java.util.EventObject;
import org.eclipse.emf.codegen.ecore.genmodel.presentation.GenModelEditor;
import org.eclipse.emf.codegen.ecore.genmodel.presentation.TargetPlatformAdapterFactoryEditingDomain;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;

public class TargetPlatformGenModelEditor
extends GenModelEditor
implements IPluginModelListener {
    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        PDECore.getDefault().getModelManager().addPluginModelListener((IPluginModelListener)this);
    }

    public void dispose() {
        PDECore.getDefault().getModelManager().removePluginModelListener((IPluginModelListener)this);
        super.dispose();
    }

    public void modelsChanged(PluginModelDelta event) {
        if ((event.getKind() & 2) != 0) {
            ModelEntry[] modelEntryArray = event.getRemovedEntries();
            int n = modelEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                ModelEntry entry = modelEntryArray[n2];
                String id = entry.getId();
                if (id != null && entry.getModel() != null && entry.getModel().getUnderlyingResource() == null) {
                    this.handleRemove(entry.getModel());
                }
                ++n2;
            }
        }
    }

    private void handleRemove(IPluginModelBase base) {
        final ArrayList<Resource> innerRemovedResources = new ArrayList<Resource>();
        String model = URI.createPlatformPluginURI((String)(String.valueOf(base.getPluginBase().getId()) + "/"), (boolean)false).toString();
        for (Resource resource : this.editingDomain.getResourceSet().getResources()) {
            if (!resource.getURI().toString().startsWith(model)) continue;
            innerRemovedResources.add(resource);
        }
        if (!innerRemovedResources.isEmpty()) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    TargetPlatformGenModelEditor.this.removedResources.addAll(innerRemovedResources);
                    if (!TargetPlatformGenModelEditor.this.isDirty()) {
                        TargetPlatformGenModelEditor.this.getSite().getPage().closeEditor((IEditorPart)TargetPlatformGenModelEditor.this, false);
                    }
                }
            });
        }
    }

    protected void initializeEditingDomain() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(final EventObject event) {
                TargetPlatformGenModelEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        TargetPlatformGenModelEditor.this.firePropertyChange(257);
                        Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                        if (mostRecentCommand != null) {
                            TargetPlatformGenModelEditor.this.setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                        }
                        if ((this).TargetPlatformGenModelEditor.this.propertySheetPage != null && !(this).TargetPlatformGenModelEditor.this.propertySheetPage.getControl().isDisposed()) {
                            (this).TargetPlatformGenModelEditor.this.propertySheetPage.refresh();
                        }
                    }
                });
            }
        });
        this.editingDomain = new TargetPlatformAdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack){

            public boolean isReadOnly(Resource resource) {
                return super.isReadOnly(resource) || this.getResourceSet().getResources().indexOf((Object)resource) != 0;
            }
        };
    }
}

