/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gymnast.runtime.core.templates.ext;

import java.util.ArrayList;
import org.eclipse.gymnast.runtime.core.templates.ext.ExtTemplateVariable;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateTranslator;
import org.eclipse.jface.text.templates.TemplateVariable;

public class ExtTemplateTranslator
extends TemplateTranslator {
    private String _errorMessage;
    private final String _EndMarker = "${^END}";

    public String getErrorMessage() {
        return this._errorMessage;
    }

    public TemplateBuffer translate(Template template) throws TemplateException {
        return this.translate(template.getPattern());
    }

    public TemplateBuffer translate(String string) {
        try {
            return new TemplateBuffer(string, (TemplateVariable[])this.findVariables(string));
        }
        catch (Exception ex) {
            this._errorMessage = ex.getMessage();
            return null;
        }
    }

    private ExtTemplateVariable[] findVariables(String input) throws Exception {
        ArrayList<ExtTemplateVariable> vars = new ArrayList<ExtTemplateVariable>();
        int pos = 0;
        ExtTemplateVariable var = this.parseVariable(input, pos);
        while (var != null) {
            vars.add(var);
            pos = var.getDefaultOffset() + var.getLength();
            var = this.parseVariable(input, pos);
        }
        return vars.toArray(new ExtTemplateVariable[vars.size()]);
    }

    private ExtTemplateVariable parseVariable(String input, int startPos) throws Exception {
        String id;
        boolean isNestingVariable = false;
        if ((startPos = input.indexOf(36, startPos)) == -1) {
            return null;
        }
        int pos = startPos + 1;
        char c = input.charAt(pos);
        switch (c) {
            case '$': {
                return new ExtTemplateVariable.Simple("$$", "$", startPos);
            }
            case '{': {
                break;
            }
            default: {
                return new ExtTemplateVariable.Identity("$", startPos);
            }
        }
        c = input.charAt(++pos);
        if (c == '^') {
            isNestingVariable = true;
            ++pos;
        }
        if ((c = input.charAt(pos += (id = this.parseId(input, pos)).length())) != '}') {
            String varText = input.substring(startPos, pos);
            throw new Exception("Badly formed variable: " + varText);
        }
        ++pos;
        if ("".equals(id)) {
            String value = input.substring(startPos, pos);
            return new ExtTemplateVariable.Removal(value, startPos);
        }
        if (isNestingVariable) {
            int endPos = this.findTerminator(input, pos);
            if (endPos == -1) {
                String varText = input.substring(startPos, pos);
                throw new Exception("Can't find ${^END} terminator for " + varText);
            }
            String varText = input.substring(startPos, endPos);
            String nestedText = input.substring(pos, endPos - "${^END}".length());
            return new ExtTemplateVariable.Nested(String.valueOf('^') + id, varText, nestedText, startPos);
        }
        String varText = input.substring(startPos, pos);
        return new ExtTemplateVariable(id, varText, startPos);
    }

    private int findTerminator(String input, int startPos) {
        int tPos = input.indexOf("${^END}", startPos);
        if (tPos != -1) {
            return tPos += "${^END}".length();
        }
        return -1;
    }

    private String parseId(String input, int startPos) {
        int pos = startPos;
        char c = input.charAt(pos);
        while (this.isIdChar(c)) {
            c = input.charAt(++pos);
        }
        return input.substring(startPos, pos);
    }

    private boolean isIdChar(char c) {
        return Character.isUnicodeIdentifierPart(c) || c == '@' || c == '.';
    }
}

