/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.changeTracking;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.impl.IdEObjectCollectionImpl;
import org.eclipse.emf.emfstore.internal.common.model.impl.ProjectImpl;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.NotificationInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AttributeOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.ContainmentType;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.FeatureOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiAttributeMoveOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiAttributeOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiAttributeSetOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiReferenceMoveOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiReferenceOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.MultiReferenceSetOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.OperationsFactory;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.ReferenceOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.SingleReferenceOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.UnsetType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NotificationToOperationConverter {
    private final IdEObjectCollectionImpl project;

    public NotificationToOperationConverter(IdEObjectCollectionImpl project) {
        this.project = project;
    }

    public AbstractOperation convert(NotificationInfo n) {
        if (n.isTouch() || n.isTransient() || !n.isValid()) {
            return null;
        }
        switch (n.getEventType()) {
            case 1: {
                if (n.isAttributeNotification()) {
                    return this.handleSetAttribute(n);
                }
                return this.handleSetReference(n);
            }
            case 2: {
                if (n.isAttributeNotification()) {
                    return this.handleUnsetAttribute(n);
                }
                return this.handleUnsetReference(n);
            }
            case 3: {
                if (n.isAttributeNotification()) {
                    return this.handleMultiAttribute(n);
                }
                return this.handleMultiReference(n);
            }
            case 5: {
                if (n.isAttributeNotification()) {
                    return this.handleMultiAttribute(n);
                }
                return this.handleMultiReference(n);
            }
            case 4: {
                if (n.isAttributeNotification()) {
                    return this.handleMultiAttribute(n);
                }
                return this.handleMultiReference(n);
            }
            case 6: {
                if (n.isAttributeNotification()) {
                    return this.handleMultiAttribute(n);
                }
                return this.handleMultiReference(n);
            }
            case 7: {
                if (n.isAttributeNotification()) {
                    return this.handleAttributeMove(n);
                }
                return this.handleReferenceMove(n);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private AbstractOperation handleMultiAttribute(NotificationInfo n) {
        MultiAttributeOperation operation = OperationsFactory.eINSTANCE.createMultiAttributeOperation();
        NotificationToOperationConverter.setCommonValues(this.project, (AbstractOperation)operation, n.getNotifierModelElement());
        operation.setFeatureName(n.getAttribute().getName());
        operation.setAdd(n.isAddEvent() || n.isAddManyEvent());
        List<Object> list = null;
        switch (n.getEventType()) {
            case 3: {
                list = new ArrayList();
                operation.getIndexes().add((Object)n.getPosition());
                list.add(n.getNewValue());
                break;
            }
            case 5: {
                void var4_5;
                list = (List)n.getNewValue();
                boolean bl = false;
                while (var4_5 < list.size()) {
                    operation.getIndexes().add((Object)(n.getPosition() + var4_5));
                    ++var4_5;
                }
                break;
            }
            case 4: {
                list = new ArrayList();
                operation.getIndexes().add((Object)n.getPosition());
                list.add(n.getOldValue());
                break;
            }
            case 6: {
                list = (List)n.getOldValue();
                if (n.getNewValue() == null) {
                    void var4_7;
                    boolean bl = false;
                    while (var4_7 < list.size()) {
                        operation.getIndexes().add((Object)((int)var4_7));
                        ++var4_7;
                    }
                } else {
                    int[] nArray = (int[])n.getNewValue();
                    int n2 = nArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        int n4 = nArray[n3];
                        operation.getIndexes().add((Object)n4);
                        ++n3;
                    }
                }
                break;
            }
        }
        if (list != null) {
            for (Object e : list) {
                operation.getReferencedValues().add(e);
            }
        }
        if (n.wasUnset()) {
            operation.setUnset(UnsetType.WAS_UNSET);
        }
        return operation;
    }

    private AbstractOperation handleMultiReference(NotificationInfo n) {
        ArrayList<EObject> list = new ArrayList<EObject>();
        switch (n.getEventType()) {
            case 3: {
                list.add(n.getNewModelElementValue());
                break;
            }
            case 5: {
                list = (List)n.getNewValue();
                break;
            }
            case 4: {
                list.add(n.getOldModelElementValue());
                break;
            }
            case 6: {
                list = (List)n.getOldValue();
                break;
            }
        }
        boolean isAdd = n.isAddEvent() || n.isAddManyEvent();
        MultiReferenceOperation multiRefOp = NotificationToOperationConverter.createMultiReferenceOperation(this.project, n.getNotifierModelElement(), n.getReference(), list, isAdd, n.getPosition());
        if (n.wasUnset()) {
            multiRefOp.setUnset(UnsetType.WAS_UNSET);
        }
        return multiRefOp;
    }

    public static MultiReferenceOperation createMultiReferenceOperation(IdEObjectCollectionImpl collection, EObject modelElement, EReference reference, List<EObject> referencedElements, boolean isAdd, int position) {
        MultiReferenceOperation op = OperationsFactory.eINSTANCE.createMultiReferenceOperation();
        NotificationToOperationConverter.setCommonValues(collection, (AbstractOperation)op, modelElement);
        NotificationToOperationConverter.setBidirectionalAndContainmentInfo((ReferenceOperation)op, reference);
        op.setFeatureName(reference.getName());
        op.setAdd(isAdd);
        op.setIndex(position);
        EList referencedModelElements = op.getReferencedModelElements();
        for (EObject valueElement : referencedElements) {
            ModelElementId id = collection.getModelElementId(valueElement);
            if (id == null) {
                id = collection.getDeletedModelElementId(valueElement);
            }
            if (id != null) {
                referencedModelElements.add(id);
                continue;
            }
            if (ModelUtil.getProject((EObject)valueElement) != collection) continue;
            throw new IllegalStateException("Element in Project does not have an ID: " + valueElement);
        }
        return op;
    }

    private AbstractOperation handleReferenceMove(NotificationInfo n) {
        MultiReferenceMoveOperation op = OperationsFactory.eINSTANCE.createMultiReferenceMoveOperation();
        NotificationToOperationConverter.setCommonValues(this.project, (AbstractOperation)op, n.getNotifierModelElement());
        op.setFeatureName(n.getReference().getName());
        op.setReferencedModelElementId(this.project.getModelElementId(n.getNewModelElementValue()));
        op.setNewIndex(n.getPosition());
        op.setOldIndex(((Integer)n.getOldValue()).intValue());
        return op;
    }

    private AbstractOperation handleAttributeMove(NotificationInfo n) {
        MultiAttributeMoveOperation operation = OperationsFactory.eINSTANCE.createMultiAttributeMoveOperation();
        NotificationToOperationConverter.setCommonValues(this.project, (AbstractOperation)operation, n.getNotifierModelElement());
        operation.setFeatureName(n.getAttribute().getName());
        operation.setNewIndex(n.getPosition());
        operation.setOldIndex(((Integer)n.getOldValue()).intValue());
        operation.setReferencedValue(n.getNewValue());
        return operation;
    }

    private AbstractOperation handleSetAttribute(NotificationInfo n) {
        if (!n.getAttribute().isMany()) {
            AttributeOperation op = null;
            op = OperationsFactory.eINSTANCE.createAttributeOperation();
            NotificationToOperationConverter.setCommonValues(this.project, (AbstractOperation)op, n.getNotifierModelElement());
            op.setFeatureName(n.getAttribute().getName());
            op.setNewValue(n.getNewValue());
            op.setOldValue(n.getOldValue());
            if (n.wasUnset()) {
                op.setUnset(UnsetType.WAS_UNSET);
            }
            return op;
        }
        MultiAttributeSetOperation setOperation = OperationsFactory.eINSTANCE.createMultiAttributeSetOperation();
        NotificationToOperationConverter.setCommonValues(this.project, (AbstractOperation)setOperation, n.getNotifierModelElement());
        setOperation.setFeatureName(n.getAttribute().getName());
        setOperation.setNewValue(n.getNewValue());
        setOperation.setOldValue(n.getOldValue());
        setOperation.setIndex(n.getPosition());
        if (n.wasUnset()) {
            setOperation.setUnset(UnsetType.WAS_UNSET);
        }
        return setOperation;
    }

    public static SingleReferenceOperation createSingleReferenceOperation(IdEObjectCollectionImpl collection, ModelElementId oldReference, ModelElementId newReference, EReference reference, EObject modelElement) {
        SingleReferenceOperation op = OperationsFactory.eINSTANCE.createSingleReferenceOperation();
        NotificationToOperationConverter.setCommonValues(collection, (AbstractOperation)op, modelElement);
        op.setFeatureName(reference.getName());
        NotificationToOperationConverter.setBidirectionalAndContainmentInfo((ReferenceOperation)op, reference);
        op.setOldValue(oldReference);
        op.setNewValue(newReference);
        return op;
    }

    private AbstractOperation handleSetReference(NotificationInfo n) {
        ModelElementId oldModelElementId = this.project.getModelElementId(n.getOldModelElementValue());
        ModelElementId newModelElementId = this.project.getModelElementId(n.getNewModelElementValue());
        if (oldModelElementId == null) {
            oldModelElementId = ((ProjectImpl)this.project).getDeletedModelElementId(n.getOldModelElementValue());
        }
        if (newModelElementId == null) {
            newModelElementId = ((ProjectImpl)this.project).getDeletedModelElementId(n.getNewModelElementValue());
        }
        if (!n.getReference().isMany()) {
            SingleReferenceOperation singleRefOperation = NotificationToOperationConverter.createSingleReferenceOperation(this.project, oldModelElementId, newModelElementId, n.getReference(), n.getNotifierModelElement());
            if (n.wasUnset()) {
                singleRefOperation.setUnset(UnsetType.WAS_UNSET);
            }
            return singleRefOperation;
        }
        MultiReferenceSetOperation setOperation = OperationsFactory.eINSTANCE.createMultiReferenceSetOperation();
        NotificationToOperationConverter.setCommonValues(this.project, (AbstractOperation)setOperation, (EObject)n.getNotifier());
        setOperation.setFeatureName(n.getReference().getName());
        NotificationToOperationConverter.setBidirectionalAndContainmentInfo((ReferenceOperation)setOperation, n.getReference());
        setOperation.setIndex(n.getPosition());
        if (n.getOldValue() != null) {
            setOperation.setOldValue(oldModelElementId);
        }
        if (n.getNewValue() != null) {
            setOperation.setNewValue(newModelElementId);
        }
        if (n.wasUnset()) {
            setOperation.setUnset(UnsetType.WAS_UNSET);
        }
        return setOperation;
    }

    private static void setCommonValues(IdEObjectCollectionImpl collection, AbstractOperation operation, EObject modelElement) {
        operation.setClientDate(new Date());
        ModelElementId id = collection.getModelElementId(modelElement);
        if (id == null) {
            id = collection.getDeletedModelElementId(modelElement);
        }
        if (id == null) {
            WorkspaceUtil.handleException(new IllegalStateException("Model Element does not have an ID: " + modelElement));
        }
        operation.setModelElementId(id);
    }

    private static void setBidirectionalAndContainmentInfo(ReferenceOperation referenceOperation, EReference reference) {
        if (reference.getEOpposite() != null) {
            referenceOperation.setBidirectional(true);
            referenceOperation.setOppositeFeatureName(reference.getEOpposite().getName());
        } else {
            referenceOperation.setBidirectional(false);
        }
        if (reference.isContainer()) {
            referenceOperation.setContainmentType(ContainmentType.CONTAINER);
        }
        if (reference.isContainment()) {
            referenceOperation.setContainmentType(ContainmentType.CONTAINMENT);
        }
    }

    private AbstractOperation handleUnsetAttribute(NotificationInfo n) {
        FeatureOperation op = (FeatureOperation)this.handleSetAttribute(n);
        op.setUnset(UnsetType.IS_UNSET);
        return op;
    }

    private AbstractOperation handleUnsetReference(NotificationInfo n) {
        FeatureOperation op = !n.getReference().isMany() ? (FeatureOperation)this.handleSetReference(n) : (FeatureOperation)this.handleMultiReference(n);
        op.setUnset(UnsetType.IS_UNSET);
        return op;
    }
}

