/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.fuzzy.emf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.dom4j.DocumentException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.emfstore.fuzzy.FuzzyDataProvider;
import org.eclipse.emf.emfstore.fuzzy.Test;
import org.eclipse.emf.emfstore.fuzzy.Util;
import org.eclipse.emf.emfstore.fuzzy.emf.EMFRunListener;
import org.eclipse.emf.emfstore.fuzzy.emf.FuzzyUtil;
import org.eclipse.emf.emfstore.fuzzy.emf.MutateUtil;
import org.eclipse.emf.emfstore.fuzzy.emf.config.ConfigFactory;
import org.eclipse.emf.emfstore.fuzzy.emf.config.ConfigPackage;
import org.eclipse.emf.emfstore.fuzzy.emf.config.DiffReport;
import org.eclipse.emf.emfstore.fuzzy.emf.config.MutatorConfig;
import org.eclipse.emf.emfstore.fuzzy.emf.config.TestConfig;
import org.eclipse.emf.emfstore.fuzzy.emf.config.TestDiff;
import org.eclipse.emf.emfstore.fuzzy.emf.config.TestResult;
import org.eclipse.emf.emfstore.fuzzy.emf.config.TestRun;
import org.eclipse.emf.emfstore.fuzzy.emf.diff.HudsonTestRunProvider;
import org.eclipse.emf.emfstore.internal.modelmutator.api.ModelMutator;
import org.eclipse.emf.emfstore.internal.modelmutator.api.ModelMutatorConfiguration;
import org.junit.runner.notification.RunListener;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMFDataProvider
implements FuzzyDataProvider<EObject> {
    private Random random;
    private int count;
    private int seedCount;
    private TestClass testClass;
    private TestRun testRun;
    private TestConfig config;
    private boolean filterTests;
    private String configFile;
    private long nextSeed;
    private EClass rootEClass;
    private ModelMutatorConfiguration modelMutatorConfig;
    private Resource diffResource;
    public static final String PROP_EMFDATAPROVIDER = ".emfdataprovider";
    public static final String PROP_CONFIGS_FILE = ".configsFile";
    public static final String MUTATOR_EXC_LOG = "mutatorExcLog";
    public static final String MUTATOR_EDITINGDOMAIN = "mutatorEditingDomain";

    public void init() {
        this.fillProperties();
        Resource loadResource = FuzzyUtil.createResource(this.configFile);
        try {
            loadResource.load(null);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load " + this.configFile, e);
        }
        this.config = FuzzyUtil.getTestConfig(loadResource, this.testClass);
        this.addToConfigFile();
        this.random = new Random(this.config.getSeed());
        this.count = this.config.getCount();
        this.seedCount = 0;
        MutatorConfig mutatorConfig = this.config.getMutatorConfig();
        this.rootEClass = mutatorConfig.getRootEClass();
        if (this.rootEClass == null) {
            this.rootEClass = ConfigPackage.Literals.ROOT;
        }
        this.modelMutatorConfig = new ModelMutatorConfiguration();
        this.modelMutatorConfig.setMinObjectsCount(mutatorConfig.getMinObjectsCount());
        this.modelMutatorConfig.setDoNotGenerateRoot(mutatorConfig.isDoNotGenerateRoot());
        this.modelMutatorConfig.seteClassesToIgnore(mutatorConfig.getEClassesToIgnore());
        this.modelMutatorConfig.seteStructuralFeaturesToIgnore(mutatorConfig.getEStructuralFeaturesToIgnore());
        this.modelMutatorConfig.setIgnoreAndLog(mutatorConfig.isIgnoreAndLog());
        this.modelMutatorConfig.setUseEcoreUtilDelete(mutatorConfig.isUseEcoreUtilDelete());
        this.modelMutatorConfig.setMaxDeleteCount(mutatorConfig.getMaxDeleteCount());
        this.modelMutatorConfig.setModelPackages(mutatorConfig.getEPackages());
        this.testRun = ConfigFactory.eINSTANCE.createTestRun();
        this.testRun.setConfig(this.config);
        this.testRun.setTime(new Date());
    }

    private void addToConfigFile() {
        Resource resource = FuzzyUtil.createResource("../fuzzy/fuzzyConfig.fuzzy");
        try {
            if (FuzzyUtil.resourceExists(resource)) {
                resource.load(null);
            }
            if (!FuzzyUtil.containsConfig(resource, this.config)) {
                resource.getContents().add((Object)this.config);
                resource.save(null);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save config!", e);
        }
    }

    public EObject get(int count) {
        ++this.seedCount;
        this.fitSeed(count);
        this.nextSeed = this.random.nextLong();
        EObject root = EcoreUtil.create((EClass)this.rootEClass);
        this.modelMutatorConfig.reset();
        this.modelMutatorConfig.setRootEObject(root);
        this.modelMutatorConfig.setSeed(Long.valueOf(this.nextSeed));
        ModelMutator.generateModel((ModelMutatorConfiguration)this.modelMutatorConfig);
        return root;
    }

    private void fitSeed(int count) {
        if (count == this.seedCount) {
            return;
        }
        if (count < this.seedCount) {
            this.random = new Random(this.config.getSeed());
            this.seedCount = 0;
        }
        while (this.seedCount < count) {
            this.random.nextLong();
            ++this.seedCount;
        }
    }

    public void finish() {
        Resource runResource = FuzzyUtil.createResource("../fuzzy/testruns/" + this.config.getId() + ".xml");
        runResource.getContents().add((Object)this.testRun);
        try {
            runResource.save(null);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save the run result after running!", e);
        }
    }

    public int size() {
        return this.count;
    }

    public void setTestClass(TestClass testClass) {
        this.testClass = testClass;
    }

    public List<RunListener> getListener() {
        return Arrays.asList(new RunListener[]{new EMFRunListener(this, this.testRun)});
    }

    public List<Test> getTestsToRun() {
        if (!this.filterTests) {
            return null;
        }
        if (this.diffResource == null) {
            try {
                this.diffResource = HudsonTestRunProvider.getDiffResource();
                this.diffResource.load(null);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load diff file!", e);
            }
            catch (DocumentException e) {
                throw new RuntimeException("Could not load diff file!", e);
            }
        }
        EList contents = this.diffResource.getContents();
        ArrayList<Test> tests = new ArrayList<Test>();
        for (EObject obj : contents) {
            if (!(obj instanceof DiffReport)) continue;
            for (TestDiff diff : ((DiffReport)obj).getDiffs()) {
                if (!diff.getConfig().getId().equals(this.config.getId())) continue;
                TestResult result = FuzzyUtil.getValidTestResult(diff);
                tests.add(new Test(result.getTestName(), result.getSeedCount()));
            }
        }
        return tests;
    }

    public int getCurrentSeedCount() {
        return this.seedCount;
    }

    public long getSeed() {
        return this.nextSeed;
    }

    public Collection<EPackage> getEPackages() {
        return this.modelMutatorConfig.getModelPackages();
    }

    private void fillProperties() {
        String filterTests = System.getProperty("filterTests");
        this.filterTests = filterTests == null ? false : Boolean.parseBoolean(filterTests);
        this.configFile = FuzzyUtil.getProperty(".emfdataprovider.configsFile", "fuzzy/fuzzyConfig.fuzzy");
    }

    public Util getUtil() {
        return new MutateUtil(this);
    }

    public TestConfig getConfig() {
        return this.config;
    }

    public void setOptions(Map<String, Object> options) {
        Object o = options.get(MUTATOR_EXC_LOG);
        if (o != null && o instanceof Set) {
            this.modelMutatorConfig.setExceptionLog((Set)o);
        }
        if ((o = options.get(MUTATOR_EDITINGDOMAIN)) != null && o instanceof EditingDomain) {
            this.modelMutatorConfig.setEditingDomain((EditingDomain)o);
        }
    }

    public ModelMutatorConfiguration getModelMutatorConfiguration() {
        return this.modelMutatorConfig;
    }
}

