/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge.ui.widgets;

import diff.match.patch.diff_match_patch;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.ConflictOption;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.VisualConflict;
import org.eclipse.emf.emfstore.internal.client.model.changeTracking.merging.conflict.options.MergeTextOption;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge.ui.DecisionBox;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge.ui.components.DetailsComponent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class MergeTextWidget
implements Observer {
    private final DecisionBox decisionBox;
    private ArrayList<ConflictOption> options;
    private TabFolder tabFolder;
    private final DetailsComponent detailsComponent;

    public MergeTextWidget(DecisionBox decisionBox, DetailsComponent detailsComponent) {
        this.decisionBox = decisionBox;
        this.detailsComponent = detailsComponent;
        this.options = new ArrayList();
        decisionBox.getConflict().addObserver((Observer)this);
    }

    public void addOption(ConflictOption option) {
        this.options.add(option);
    }

    public void createContent(Composite parent) {
        this.tabFolder = new TabFolder(parent, 0);
        this.tabFolder.setBackground(parent.getBackground());
        this.tabFolder.setLayout((Layout)new TableWrapLayout());
        for (ConflictOption option : this.options) {
            this.createTab(this.tabFolder, option);
        }
    }

    private void createTab(TabFolder tabFolder, ConflictOption option) {
        TabItem tab = new TabItem(tabFolder, 0);
        tab.setText(this.getTitle(option));
        StyledText text = new StyledText((Composite)tabFolder, 66);
        this.setText(option, text);
        text.setBackground(tabFolder.getBackground());
        text.setEditable(this.isEditable(option));
        text.setWordWrap(true);
        tab.setControl((Control)text);
    }

    private void setText(ConflictOption option, StyledText styledText) {
        if (option instanceof MergeTextOption) {
            this.handleMergeTextOption(option, styledText);
        } else {
            styledText.setText(option.getFullOptionLabel());
        }
    }

    private void handleMergeTextOption(ConflictOption option, final StyledText styledText) {
        final MergeTextOption mergeOption = (MergeTextOption)option;
        diff_match_patch dmp = new diff_match_patch();
        dmp.Diff_EditCost = (short)10;
        LinkedList diffMain = dmp.diff_main(mergeOption.getMyText(), mergeOption.getTheirString());
        dmp.diff_cleanupEfficiency(diffMain);
        String description = "";
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        for (diff_match_patch.Diff diff : diffMain) {
            String text = diff.text;
            if (!diff.operation.equals((Object)diff_match_patch.Operation.EQUAL)) {
                StyleRange styleRange = new StyleRange();
                styleRange.start = description.length();
                styleRange.length = text.length();
                if (diff.operation.equals((Object)diff_match_patch.Operation.DELETE)) {
                    styleRange.foreground = Display.getDefault().getSystemColor(3);
                } else if (diff.operation.equals((Object)diff_match_patch.Operation.INSERT)) {
                    styleRange.foreground = Display.getDefault().getSystemColor(6);
                }
                styleRanges.add(styleRange);
            }
            description = String.valueOf(description) + text;
        }
        styledText.setText(description);
        styledText.setStyleRanges(styleRanges.toArray(new StyleRange[styleRanges.size()]));
        styledText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newText = styledText.getText();
                String oldText = mergeOption.getMergedText();
                if (newText != null && !newText.equals(oldText)) {
                    mergeOption.setMergedText(newText);
                    MergeTextWidget.this.decisionBox.setSolution((ConflictOption)mergeOption);
                }
            }
        });
    }

    private boolean isEditable(ConflictOption option) {
        return option instanceof MergeTextOption;
    }

    private String getTitle(ConflictOption option) {
        switch (option.getType()) {
            case MyOperation: {
                return "My Version";
            }
            case TheirOperation: {
                return "Version from Repository";
            }
            case MergeText: 
            case Custom: {
                return option.getOptionLabel();
            }
        }
        return "";
    }

    public void update(Observable o, Object arg) {
        ConflictOption solution;
        VisualConflict conflict = this.decisionBox.getConflict();
        if (conflict != null && conflict == o && (solution = conflict.getSolution()) instanceof MergeTextOption) {
            int i = 0;
            while (i < this.options.size()) {
                if (this.options.get(i) == solution) {
                    this.detailsComponent.setExpanded(true);
                    this.tabFolder.setSelection(i);
                }
                ++i;
            }
        }
    }
}

