/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.common.model.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.emfstore.internal.common.model.util.Messages;

public final class FileUtil {
    private FileUtil() {
    }

    public static void copyFile(File source, File destination) throws IOException {
        FileUtil.copyFile(new FileInputStream(source), destination);
    }

    public static void copyFile(InputStream source, File destination) throws IOException {
        FileOutputStream outputStream = null;
        try {
            int read;
            if (source == null || destination == null) {
                throw new IOException(Messages.FileUtil_SourceOrDestinationIsNull);
            }
            if (destination.getParentFile() != null) {
                destination.getParentFile().mkdirs();
            }
            outputStream = new FileOutputStream(destination);
            byte[] buffer = new byte[4096];
            while ((read = source.read(buffer)) != -1) {
                outputStream.write(buffer, 0, read);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)source);
            IOUtils.closeQuietly(outputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)source);
        IOUtils.closeQuietly((OutputStream)outputStream);
    }

    public static void copyDirectory(File source, File destination) throws IOException {
        destination.mkdirs();
        if (!source.exists()) {
            return;
        }
        File[] fileArray = source.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                FileUtil.copyDirectory(file, new File(String.valueOf(destination.getAbsolutePath()) + File.separatorChar + file.getName()));
            } else {
                FileUtil.copyFile(file, new File(String.valueOf(destination.getAbsolutePath()) + File.separatorChar + file.getName()));
            }
            ++n2;
        }
    }

    public static void zipFolder(File source, File destination) throws IOException {
        if (!source.isDirectory()) {
            throw new IOException(Messages.FileUtil_SourceMustBeFolder);
        }
        if (destination.exists()) {
            throw new IOException(Messages.FileUtil_DestinationExists);
        }
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destination)));
        String path = source.getPath();
        path = String.valueOf(path) + (path.endsWith(File.separator) ? "" : Character.valueOf(File.separatorChar));
        FileUtil.zip(source, path, zipOutputStream, new byte[8192]);
        zipOutputStream.close();
    }

    private static void zip(File current, String rootPath, ZipOutputStream zipStream, byte[] buffer) throws IOException {
        if (current.isDirectory()) {
            File[] fileArray = current.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (!".".equals(file.getName()) && !"..".equals(file.getName())) {
                    FileUtil.zip(file, rootPath, zipStream, buffer);
                }
                ++n2;
            }
        } else if (current.isFile()) {
            int read;
            zipStream.putNextEntry(new ZipEntry(current.getPath().replace(rootPath, "")));
            FileInputStream file = new FileInputStream(current);
            while ((read = file.read(buffer)) != -1) {
                zipStream.write(buffer, 0, read);
            }
            zipStream.closeEntry();
            file.close();
        } else {
            throw new IllegalStateException();
        }
    }

    public static boolean areEqual(File file1, File file2) {
        return FileUtil.areEqual(file1, file2, (IProgressMonitor)new NullProgressMonitor());
    }

    /*
     * Loose catch block
     */
    public static boolean areEqual(File file1, File file2, IProgressMonitor monitor) {
        BufferedInputStream stream1 = null;
        BufferedInputStream stream2 = null;
        stream1 = new BufferedInputStream(new FileInputStream(file1));
        stream2 = new BufferedInputStream(new FileInputStream(file2));
        monitor.beginTask(Messages.FileUtil_Comparing, file1.length() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)file1.length());
        boolean equals = FileUtil.areEqual(stream1, stream2, monitor);
        monitor.done();
        boolean bl = equals;
        try {
            if (stream1 != null) {
                stream1.close();
            }
            if (stream2 != null) {
                stream2.close();
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return bl;
        catch (IOException iOException) {
            try {}
            catch (Throwable throwable) {
                try {
                    if (stream1 != null) {
                        stream1.close();
                    }
                    if (stream2 != null) {
                        stream2.close();
                    }
                }
                catch (IOException iOException2) {
                    return false;
                }
                throw throwable;
            }
            try {
                if (stream1 != null) {
                    stream1.close();
                }
                if (stream2 != null) {
                    stream2.close();
                }
            }
            catch (IOException iOException3) {
                return false;
            }
            return false;
        }
    }

    private static boolean areEqual(InputStream inputStream1, InputStream input2, IProgressMonitor monitor) throws IOException {
        int char1 = inputStream1.read();
        while (char1 != -1) {
            int char2 = input2.read();
            if (char1 != char2) {
                return false;
            }
            char1 = inputStream1.read();
        }
        return input2.read() == -1;
    }

    public static void deleteDirectory(File file, boolean force) throws IOException {
        int maxRetry = 3;
        if (!force) {
            maxRetry = 1;
        }
        int i = 0;
        while (i <= maxRetry) {
            try {
                FileUtils.deleteDirectory((File)file);
                return;
            }
            catch (IOException exception) {
                if (i >= maxRetry) {
                    throw exception;
                }
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {
                    throw exception;
                }
                ++i;
            }
        }
    }

    public static String getExtension(File file) {
        int lastIndexOf = file.getName().lastIndexOf(".");
        if (lastIndexOf == -1) {
            return "";
        }
        return StringUtils.substring((String)file.getName(), (int)lastIndexOf);
    }
}

