/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.model.versioning.operations.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.FeatureOperation;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.OperationsPackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.UnkownFeatureException;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.UnsetType;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.impl.AbstractOperationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FeatureOperationImpl
extends AbstractOperationImpl
implements FeatureOperation {
    protected static final String FEATURE_NAME_EDEFAULT = "";
    protected String featureName = "";
    protected static final UnsetType UNSET_EDEFAULT = UnsetType.NONE;
    protected UnsetType unset = UNSET_EDEFAULT;

    @Override
    protected void reverse(AbstractOperation abstractOperation) {
        super.reverse(abstractOperation);
        if (!(abstractOperation instanceof FeatureOperation)) {
            throw new IllegalArgumentException("Given operation is not a feature operation.");
        }
        FeatureOperation featureOperation = (FeatureOperation)abstractOperation;
        featureOperation.setFeatureName(this.getFeatureName());
    }

    protected FeatureOperationImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return OperationsPackage.Literals.FEATURE_OPERATION;
    }

    @Override
    public String getFeatureName() {
        return this.featureName;
    }

    @Override
    public void setFeatureName(String newFeatureName) {
        String oldFeatureName = this.featureName;
        this.featureName = newFeatureName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldFeatureName, (Object)this.featureName));
        }
    }

    @Override
    public UnsetType getUnset() {
        return this.unset;
    }

    @Override
    public void setUnset(UnsetType newUnset) {
        UnsetType oldUnset = this.unset;
        UnsetType unsetType = this.unset = newUnset == null ? UNSET_EDEFAULT : newUnset;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldUnset, (Object)this.unset));
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 4: {
                return this.getFeatureName();
            }
            case 5: {
                return this.getUnset();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 4: {
                this.setFeatureName((String)newValue);
                return;
            }
            case 5: {
                this.setUnset((UnsetType)((Object)newValue));
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 4: {
                this.setFeatureName(FEATURE_NAME_EDEFAULT);
                return;
            }
            case 5: {
                this.setUnset(UNSET_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 4: {
                return FEATURE_NAME_EDEFAULT == null ? this.featureName != null : !FEATURE_NAME_EDEFAULT.equals(this.featureName);
            }
            case 5: {
                return this.unset != UNSET_EDEFAULT;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (featureName: ");
        result.append(this.featureName);
        result.append(", unset: ");
        result.append((Object)this.unset);
        result.append(')');
        return result.toString();
    }

    @Override
    public EStructuralFeature getFeature(Project project) throws UnkownFeatureException {
        EObject modelElement = project.getModelElement(this.getModelElementId());
        if (modelElement == null) {
            throw new IllegalArgumentException("Model Element is not in the given project");
        }
        return this.getFeature(modelElement);
    }

    @Override
    public AbstractOperation reverse() {
        return null;
    }

    @Override
    public List<AbstractOperation> getLeafOperations() {
        ArrayList<AbstractOperation> result = new ArrayList<AbstractOperation>();
        result.add(this);
        return result;
    }

    @Override
    public EStructuralFeature getFeature(EObject modelElement) throws UnkownFeatureException {
        EList features = modelElement.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature feature : features) {
            if (!feature.getName().equals(this.getFeatureName())) continue;
            return feature;
        }
        throw new UnkownFeatureException(modelElement.eClass(), this.getFeatureName());
    }

    protected void setUnsetForReverseOperation(FeatureOperation operation) {
        switch (this.getUnset().getValue()) {
            case 1: {
                operation.setUnset(UnsetType.WAS_UNSET);
                break;
            }
            case 0: {
                operation.setUnset(UnsetType.NONE);
                break;
            }
            case 2: {
                operation.setUnset(UnsetType.IS_UNSET);
            }
        }
    }
}

