/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.ecore.delegates.setting;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.BasicSettingDelegate;
import org.eclipse.epsilon.ecore.delegates.EolOperationDelegateContext;
import org.eclipse.epsilon.ecore.delegates.execution.EolOperation;
import org.eclipse.epsilon.ecore.delegates.setting.EpsilonSettingDelegate;
import org.eclipse.epsilon.ecore.delegates.setting.SettingUri;
import org.eclipse.epsilon.emc.emf.InMemoryEmfModel;
import org.eclipse.epsilon.eol.models.IModel;

public class EolDerivedSettingDelegate
extends BasicSettingDelegate.Stateless
implements EpsilonSettingDelegate {
    private final Map<Resource, InMemoryEmfModel> models = new HashMap<Resource, InMemoryEmfModel>();
    private final Set<InternalEObject> errors = new HashSet<InternalEObject>();
    private final EolOperationDelegateContext delegateContext;
    private EolOperation program;
    private final SettingUri uri;

    public EolDerivedSettingDelegate(EStructuralFeature eStructuralFeature, EolOperationDelegateContext delegateContext, SettingUri uri) {
        super(eStructuralFeature);
        this.delegateContext = delegateContext;
        this.uri = uri;
    }

    protected Object get(InternalEObject owner, boolean resolve, boolean coreType) {
        if (this.errors.contains(owner)) {
            return false;
        }
        if (this.program == null) {
            this.program = (EolOperation)this.delegateContext.parse(this.toEolOperation(this.expression()));
        }
        try {
            return this.program.execute((EObject)owner, (IModel)this.models.computeIfAbsent(this.eStructuralFeature.eResource(), r -> new InMemoryEmfModel(r)));
        }
        catch (Throwable e) {
            this.errors.add(owner);
            throw new IllegalArgumentException("Error evaluating derived feature " + this.eStructuralFeature.getName() + " on " + owner, e);
        }
    }

    protected boolean isSet(InternalEObject owner) {
        return false;
    }

    @Override
    public void reset() {
        this.program = null;
        this.errors.clear();
        this.models.clear();
    }

    private String toEolOperation(String body) {
        StringBuilder result = new StringBuilder();
        result.append("operation ");
        result.append(this.eStructuralFeature.getName());
        result.append("(");
        result.append(")");
        result.append("{");
        result.append(body);
        result.append("}");
        return result.toString();
    }

    private String expression() {
        return this.uri.getEannotionValue((EModelElement)this.eStructuralFeature, "derivation");
    }
}

