/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.rdf.emf;

import java.util.List;
import org.apache.jena.rdf.model.Resource;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epsilon.rdf.emf.IDisableable;
import org.eclipse.epsilon.rdf.emf.RDFGraphResourceImpl;

public class RDFGraphResourceNotificationAdapterTrace
extends EContentAdapter
implements IDisableable {
    private StringBuilder processTrace;
    private boolean isDisabled = false;
    private final RDFGraphResourceImpl initialRDFGraphResource;

    public RDFGraphResourceNotificationAdapterTrace(RDFGraphResourceImpl rdfGraphResource) {
        this.initialRDFGraphResource = rdfGraphResource;
    }

    @Override
    public boolean isDisabled() {
        return this.isDisabled;
    }

    @Override
    public void setDisabled(boolean isDisabled) {
        this.isDisabled = isDisabled;
    }

    public void notifyChanged(Notification notification) {
        if (this.isDisabled) {
            super.notifyChanged(notification);
            return;
        }
        this.processTrace = new StringBuilder();
        this.processTrace.append(String.format("\n[ Notification ]", new Object[0]));
        Object feature = notification.getFeature();
        if (feature != null) {
            this.featureNotification(feature, notification);
        } else {
            this.processTrace.append(String.format("\n - Not a Feature notification \n - %s ", notification));
            this.processTrace.append(String.format("Event: %s", this.eventTypeToString(notification.getEventType())));
            if (notification.getNewValue() != null) {
                this.processTrace.append(String.format("NewValue: %s", notification.getNewValue()));
                if (notification.getNewValue() instanceof EObject && notification.getEventType() == 3) {
                    this.processTrace.append("\nEObject ADDED to Model");
                    this.processTrace.append(String.format("EObject: %s#%s", ((EObject)notification.getNewValue()).eClass().getName(), ((EObject)notification.getNewValue()).hashCode()));
                }
                if (notification.getNewValue() instanceof List && notification.getEventType() == 5) {
                    this.processTrace.append("\nEObjects ADDED to Model:");
                    for (Object o : (List)notification.getNewValue()) {
                        this.processTrace.append(String.format("\n - EObject: %s#%s", ((EObject)o).eClass().getName(), ((EObject)o).hashCode()));
                    }
                }
            }
            if (notification.getOldValue() != null) {
                this.processTrace.append(String.format("OldValue: %s", notification.getOldValue()));
                if (notification.getOldValue() instanceof EObject && notification.getEventType() == 4) {
                    this.processTrace.append(String.format("\nEObject REMOVED from Model ", new Object[0]));
                    this.processTrace.append(String.format("EObject: %s#%s", ((EObject)notification.getOldValue()).eClass().getName(), ((EObject)notification.getOldValue()).hashCode()));
                }
                if (notification.getNewValue() instanceof List && notification.getEventType() == 6) {
                    this.processTrace.append("\nEObjects REMOVED from Model:");
                    for (Object o : (List)notification.getNewValue()) {
                        this.processTrace.append(String.format("\n - EObject: %s#%s", ((EObject)o).eClass().getName(), ((EObject)o).hashCode()));
                    }
                }
            }
        }
        System.out.println(String.valueOf(this.processTrace) + "\n\n");
        super.notifyChanged(notification);
    }

    private void featureNotification(Object feature, Notification notification) {
        Class<?> featureClass = feature.getClass();
        if (feature instanceof EAttribute) {
            this.eStructuralFeatureNotification((EStructuralFeature)((EAttribute)feature), notification);
            return;
        }
        if (feature instanceof EReference) {
            this.eStructuralFeatureNotification((EStructuralFeature)((EReference)feature), notification);
            return;
        }
        if (feature instanceof EObject) {
            return;
        }
        this.processTrace.append(String.format(" [!] - Feature class not handled:\n%s", featureClass.getName()));
    }

    private void eStructuralFeatureNotification(EStructuralFeature eStructuralFeature, Notification notification) {
        EObject onEObject = (EObject)notification.getNotifier();
        EStructuralFeature changedFeature = eStructuralFeature;
        Object oldValue = notification.getOldValue();
        Object newValue = notification.getNewValue();
        RDFGraphResourceImpl graphResource = (RDFGraphResourceImpl)onEObject.eResource();
        if (graphResource == null) {
            this.processTrace.append("  Adapter firing for EObject with no Graph Resource, using initial Graph Resource");
            graphResource = this.initialRDFGraphResource;
        }
        if (changedFeature instanceof EAttribute) {
            this.processTrace.append(String.format("\n EAttribute ", new Object[0]));
        } else if (changedFeature instanceof EReference) {
            this.processTrace.append(String.format("\n EReference ", new Object[0]));
        } else {
            this.processTrace.append(String.format("\n This is new?! -- %s ", changedFeature.getClass()));
        }
        boolean isOrdered = changedFeature.isOrdered();
        boolean isUnique = changedFeature.isUnique();
        boolean isMany = changedFeature.isMany();
        this.processTrace.append(String.format("(ordered is %s, unique is %s, many is %s) - ", isOrdered, isUnique, isMany));
        switch (notification.getEventType()) {
            case 3: {
                this.processTrace.append("ADD");
                this.reportEObjectIdentity(onEObject);
                this.reportEStructuralFeatureChange(changedFeature, oldValue, newValue);
                break;
            }
            case 5: {
                this.processTrace.append("ADD_MANY");
                if (!isMany || onEObject == null) break;
                this.reportEObjectIdentity(onEObject);
                this.reportEStructuralFeatureChange(changedFeature, oldValue, newValue);
                break;
            }
            case 1: {
                this.processTrace.append("SET");
                this.reportEObjectIdentity(onEObject);
                this.reportEStructuralFeatureChange(changedFeature, oldValue, newValue);
                if (oldValue == null) {
                    if (newValue == null) {
                        this.processTrace.append(String.format("\n ** Create new statement set to null", new Object[0]));
                        break;
                    }
                    this.processTrace.append(String.format("\n ** Create new statement set to value %s", newValue));
                    break;
                }
                if (newValue == null) {
                    this.processTrace.append(String.format("\n ** Update statement set to null", new Object[0]));
                    break;
                }
                this.processTrace.append(String.format("\n ** Update statement set to value %s", newValue));
                break;
            }
            case 4: {
                this.processTrace.append("REMOVE");
                this.reportEObjectIdentity(onEObject);
                this.reportEStructuralFeatureChange(changedFeature, oldValue, newValue);
                break;
            }
            case 6: {
                this.processTrace.append("REMOVE_MANY");
                this.reportEObjectIdentity(onEObject);
                this.reportEStructuralFeatureChange(changedFeature, oldValue, newValue);
                break;
            }
            case 2: {
                this.processTrace.append("UNSET");
                if (isMany) {
                    this.processTrace.append(" isMany() true");
                } else {
                    this.processTrace.append(" is Many false");
                }
                if (isOrdered) {
                    this.notImplmentedWarning(notification, isOrdered);
                }
                this.reportEObjectIdentity(onEObject);
                this.reportEStructuralFeatureChange(changedFeature, oldValue, newValue);
                break;
            }
        }
    }

    private void notImplmentedWarning(Notification notification, boolean isOrdered) {
        String feature = notification.getFeature().getClass().getSimpleName();
        String operation = this.eventTypeToString(notification.getEventType());
        String order = "";
        order = isOrdered ? "ordered" : "unordered";
        this.processTrace.append(String.format("\n [!] %s %s (%s) not implmented", feature, operation, order));
    }

    private Resource identifyEObjectsRDFnode(EObject eObject) {
        if (eObject instanceof RDFGraphResourceImpl) {
            RDFGraphResourceImpl rdfGraphResource = (RDFGraphResourceImpl)eObject.eResource();
            Resource rdfNode = rdfGraphResource.getRDFResource(eObject);
            this.processTrace.append(this.reportNamedModelsContaining(eObject));
            return rdfNode;
        }
        this.processTrace.append(String.format(" ! No RDFGraphResourceImpl for : %s ", eObject));
        return null;
    }

    private String eventTypeToString(int eventType) {
        switch (eventType) {
            case 3: {
                return "ADD";
            }
            case 5: {
                return "ADD_MANY";
            }
            case 1: {
                return "SET";
            }
            case 4: {
                return "REMOVE";
            }
            case 6: {
                return "REMOVE_MANY";
            }
            case 2: {
                return "UNSET";
            }
        }
        return "N/A";
    }

    private void reportEStructuralFeatureChange(EStructuralFeature eStructuralFeature, Object oldValue, Object newValue) {
        String multi = "";
        multi = eStructuralFeature.isMany() ? "many" : "not many";
        String order = "";
        order = eStructuralFeature.isOrdered() ? "ordered" : "not ordered";
        String unique = "";
        unique = eStructuralFeature.isUnique() ? "unique" : "not unique";
        String referenceContainment = "N/A";
        if (eStructuralFeature instanceof EReference) {
            EReference reference = (EReference)eStructuralFeature;
            referenceContainment = reference.isContainment() ? "containment" : "not containment";
        }
        if (eStructuralFeature instanceof EAttribute) {
            EAttribute eAttributeChanged = (EAttribute)eStructuralFeature;
            this.processTrace.append(String.format("\n - EAttribute changed: (%s, %s, %s)\n\t%s - %s : %s -> %s", order, unique, multi, eAttributeChanged.getEAttributeType().getName(), eAttributeChanged.getName(), oldValue, newValue));
            return;
        }
        if (eStructuralFeature instanceof EReference) {
            EReference eReferenceChanged = (EReference)eStructuralFeature;
            EObject oldValueEob = (EObject)oldValue;
            int oldValueHash = 0;
            if (oldValueEob != null) {
                oldValueHash = oldValueEob.hashCode();
            }
            EObject newValueEob = (EObject)newValue;
            int newValueHash = 0;
            if (newValueEob != null) {
                newValueHash = newValueEob.hashCode();
            }
            this.processTrace.append(String.format("\n - EReference changed: (%s, %s, %s, %s)\n\t%s - %s \n\twas: (#%s) %s\n\tnow: (#%s) %s", order, unique, multi, referenceContainment, eReferenceChanged.getEReferenceType().getName(), eReferenceChanged.getName(), oldValueHash, this.getEObjectLocation(oldValueEob), newValueHash, this.getEObjectLocation(newValueEob)));
            if (oldValue instanceof List) {
                System.out.println("old value is a list here...");
            }
            return;
        }
    }

    private String getEObjectLocation(EObject eobject) {
        if (eobject != null) {
            String frag = EcoreUtil.getURI((EObject)eobject).fragment();
            if (frag.equals("")) {
                frag = "'blank'";
            }
            return String.format("%s", frag);
        }
        return "null";
    }

    private void reportReferences(EObject eObject, EReference reference, int pad) {
        Object p = "\n";
        int i = 0;
        while (i < pad) {
            p = (String)p + "\t";
            ++i;
        }
        String prefix = p;
        List listOfreferences = (List)eObject.eGet((EStructuralFeature)reference);
        if (!listOfreferences.isEmpty()) {
            listOfreferences.forEach(r -> {
                this.processTrace.append(String.format("%s-> {", prefix));
                this.reportEObject((EObject)r, false, pad);
                this.processTrace.append(String.format("%s   }", prefix));
            });
        } else {
            this.processTrace.append(String.format("\n * Empty *", new Object[0]));
        }
    }

    private void reportEObjectIdentity(EObject eObject) {
        this.processTrace.append(String.format("\n - EObject : (#%s) %s - %s ", eObject.hashCode(), eObject.eClass().getName(), EcoreUtil.getIdentification((EObject)eObject)));
    }

    private void reportEObject(EObject eObject, boolean followReference, int pad) {
        Object p = "\n";
        int i = 0;
        while (i < pad) {
            p = (String)p + "\t";
            ++i;
        }
        String prefix = p;
        this.reportEObjectRDFnode(eObject, pad);
        this.processTrace.append(String.format("%s - EObject : %s  %s ", prefix, eObject.eClass().getName(), EcoreUtil.getIdentification((EObject)eObject)));
        this.processTrace.append(String.format("%s   * All EAttributes: ", prefix));
        eObject.eClass().getEAllAttributes().forEach(e -> this.processTrace.append(String.format("%s\t%s  %s  %s", prefix, e.getEAttributeType().getName(), e.getName(), eObject.eGet((EStructuralFeature)e))));
        this.processTrace.append(String.format("%s   * All EReferences: ", prefix));
        eObject.eClass().getEAllReferences().forEach(e -> {
            this.processTrace.append(String.format("%s\t%s  %s:", prefix, e.getEReferenceType().getName(), e.getName()));
            try {
                List listOfreferences = (List)eObject.eGet((EStructuralFeature)e);
                if (!listOfreferences.isEmpty()) {
                    if (followReference) {
                        this.reportReferences(eObject, (EReference)e, pad + 1);
                    } else {
                        listOfreferences.forEach(r -> {
                            this.processTrace.append(String.format("%s\t-> {", prefix));
                            this.processTrace.append(String.format("%s\t - %s ", prefix, EcoreUtil.getIdentification((EObject)r)));
                            this.reportEObjectRDFnode((EObject)r, pad + 1);
                            this.processTrace.append(String.format("%s\t   }", prefix));
                        });
                    }
                } else {
                    this.processTrace.append(String.format("%s\t-> * Empty *", prefix));
                }
            }
            catch (Exception e2) {
                this.processTrace.append(String.format("%s\t Error with EReference (probably not an instance yet) : %s ", prefix, eObject.eGet((EStructuralFeature)e)));
            }
        });
    }

    private void reportEObjectRDFnode(EObject eObject, int pad) {
        Object p = "\n";
        int i = 0;
        while (i < pad) {
            p = (String)p + "\t";
            ++i;
        }
        String prefix = p;
        if (eObject instanceof RDFGraphResourceImpl) {
            Resource rdfNode = this.identifyEObjectsRDFnode(eObject);
            this.processTrace.append(String.format("%s + RDF Node : %s ", prefix, rdfNode));
            this.processTrace.append(String.format("%s %s ", prefix, this.reportNamedModelsContaining(eObject)));
        } else {
            this.processTrace.append(String.format("%s + No RDFGraphResourceImpl for : %s ", prefix, eObject));
        }
    }

    private String reportNamedModelsContaining(EObject eObject) {
        StringBuilder namedModels = new StringBuilder();
        if (eObject instanceof RDFGraphResourceImpl) {
            RDFGraphResourceImpl rdfGraphResource = (RDFGraphResourceImpl)eObject.eResource();
            List<Resource> list = rdfGraphResource.getResourcesForNamedModelsContaining(eObject);
            namedModels.append(String.format(" + On Named Model(s) : ", new Object[0]));
            list.forEach(m -> {
                StringBuilder stringBuilder2 = namedModels.append(String.format(" [ %s ] ", m.getLocalName()));
            });
            return namedModels.toString();
        }
        return "";
    }
}

