/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.rdf.validation;

import java.util.Iterator;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.reasoner.ValidityReport;

public class RDFValidation {

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum ValidationMode {
        NONE("none"){

            @Override
            public RDFModelValidationReport validate(OntModel modelToValidate) {
                return new RDFModelValidationReport(true, "Validation set to NONE.");
            }
        }
        ,
        JENA_VALID("jena-valid"){

            @Override
            public RDFModelValidationReport validate(OntModel modelToValidate) {
                ValidityReport jenaValidationReport = modelToValidate.validate();
                String reportText = this.getJenaValidityModelString(jenaValidationReport);
                if (jenaValidationReport.isValid() && jenaValidationReport.getReports().hasNext()) {
                    System.err.println(reportText);
                }
                return new RDFModelValidationReport(jenaValidationReport.isValid(), reportText);
            }
        }
        ,
        JENA_CLEAN("jena-clean"){

            @Override
            public RDFModelValidationReport validate(OntModel modelToValidate) {
                ValidityReport jenaValidationReport = modelToValidate.validate();
                return new RDFModelValidationReport(jenaValidationReport.isClean(), this.getJenaValidityModelString(jenaValidationReport));
            }
        };

        private final String id;

        public abstract RDFModelValidationReport validate(OntModel var1);

        private ValidationMode(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static final ValidationMode fromString(String newId) {
            ValidationMode[] validationModeArray = ValidationMode.values();
            int n = validationModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ValidationMode mode = validationModeArray[n2];
                if (mode.id.equalsIgnoreCase(newId)) {
                    return mode;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Validation mode not found: " + newId);
        }

        protected String getJenaValidityModelString(ValidityReport modelValidityReport) {
            StringBuilder sb = new StringBuilder("The loaded model is ");
            if (!modelValidityReport.isValid()) {
                sb.append("not ");
            }
            sb.append("valid");
            if (this.equals((Object)JENA_CLEAN)) {
                sb.append(" and ");
                if (!modelValidityReport.isClean()) {
                    sb.append("not ");
                }
                sb.append("clean");
            }
            sb.append("\n");
            int i = 1;
            Iterator o = modelValidityReport.getReports();
            while (o.hasNext()) {
                ValidityReport.Report report = (ValidityReport.Report)o.next();
                sb.append(String.format("%d. %s", i, report.toString()));
                ++i;
            }
            return sb.toString();
        }

        public class RDFModelValidationReport {
            private final String text;
            private final boolean isValid;

            public RDFModelValidationReport(boolean isValid, String text) {
                this.text = text;
                this.isValid = isValid;
            }

            public boolean isValid() {
                return this.isValid;
            }

            public String getText() {
                return this.text;
            }
        }
    }
}

