/*******************************************************************************
 * Copyright (c) 2008 The University of York.
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *     Dimitrios Kolovos - initial API and implementation
 ******************************************************************************/
package org.eclipse.epsilon.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;

public class StringProperties extends Properties {
	
	/**
	 * Generated by Eclipse
	 */
	private static final long serialVersionUID = 693863217283819570L;

	/**
	 * Convenience class for chaining {@link StringProperties#put(Object, Object)} invocations.
	 * 
	 * @author Sina Madani
	 * @since 2.1
	 */
	public static final class Builder {
		Builder() {
			// Only invokable from the outer class
		}
		
		final StringProperties props = new StringProperties();
		
		public Builder withProperty(String propertyName, Object propertyValue) {
			props.put(propertyName, propertyValue);
			return this;
		}
		
		public Builder withProperties(java.util.Map<?, ?> other) {
			props.putAll(other);
			return this;
		}
		
		public StringProperties build() {
			return props;
		}
	}
	
	/**
	 * 
	 * @return
	 * @since 2.1
	 */
	public static Builder Builder() {
		return new Builder();
	}
	
	public StringProperties() {
	}
	
	public StringProperties(String properties) {
		load(properties);
	}
	
	public void load(String properties) {
		try {
			super.load(new ByteArrayInputStream(properties.getBytes()));
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}
	
	@Override
	public String toString() {
		ByteArrayOutputStream os = new ByteArrayOutputStream();
		try {
			super.store(os,"");
			os.flush();
			os.close();
		} catch (IOException e) {
			e.printStackTrace();
		}

		// Get rid of the first two lines (comment + date)
		String str = os.toString();
		try {
			return str.replaceAll("^#.*(\n|\r)", "").replaceAll("^#.*(\n|\r)", "").trim();
		}
		catch (Exception ex) {
			return str;
		}
	}
	
	public boolean hasProperty(String key) {
		String property = getProperty(key);
		return property != null && !property.isEmpty();
	}
	
	@Override
	public String getProperty(String key) {
		String value = super.getProperty(key);
		return value == null ? "" : value;
	}
	
	
	@Override
	public String getProperty(String key, String defaultValue) {
		String value = getProperty(key);
		return value.isEmpty() ? defaultValue : value;
	}

	public int getIntegerProperty(String key, int default_) {
		if (containsKey(key)) {
			return Integer.parseInt(getProperty(key));
		}
		else {
			return default_;
		}
	}
	
	@Override
	public Object put(Object key, Object value) {
		return super.put(key, StringUtil.toString(value));
	}
	
	@Override
	public void putAll(Map<?, ?> map) {
		if (map instanceof Properties) {
			super.putAll(map);
		}
		else if (map != null) {
			for (Map.Entry<?, ?> entry : map.entrySet()) {
				put(entry.getKey(), entry.getValue());
			}
		}
	}
	
	public boolean getBooleanProperty(String key, boolean def) {
		String property = getProperty(key);
		if ("true".equalsIgnoreCase(property)) return true;
		else if ("false".equalsIgnoreCase(property)) return false;
		else return def;
	}
	
	@Override
	public StringProperties clone() {
		StringProperties clone = new StringProperties();
		clone.load(this.toString());
		return clone;
	}
}
