/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.model.element;

import java.util.Collection;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.model.IGenericSimulinkModel;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.types.HandleObject;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;

public class MatlabHandleElement
extends SimulinkModelElement {
    HandleObject handle;

    public MatlabHandleElement(IGenericSimulinkModel model, MatlabEngine engine, HandleObject handle) {
        super(model, engine);
        this.handle = handle;
    }

    @Override
    public boolean deleteElementInModel() throws EolRuntimeException {
        return false;
    }

    @Override
    public Object getProperty(String property) throws EolRuntimeException {
        try {
            this.setHandleInMatlabWorkspace();
            return this.engine.evalWithResult("handle." + property + ";");
        }
        catch (MatlabException e) {
            throw e.toEolRuntimeException();
        }
    }

    @Override
    public void setProperty(String property, Object value) throws EolRuntimeException {
        try {
            this.setHandleInMatlabWorkspace();
            String escaped = "?";
            if (value instanceof ISimulinkModelElement) {
                ISimulinkModelElement element = (ISimulinkModelElement)value;
                value = element.getHandle();
            } else {
                escaped = "'" + escaped + "'";
            }
            String cmd = "handle." + property + "=" + escaped + ";";
            this.engine.eval(cmd, value);
        }
        catch (MatlabException e) {
            throw e.toEolRuntimeException();
        }
    }

    @Override
    public Object getHandle() {
        return this.handle.getHandleObject();
    }

    public void setHandleInMatlabWorkspace() throws MatlabException {
        this.engine.feval(0, "assignin", "base", "handle", this.getHandle());
    }

    public String toString() {
        return this.handle.getHandleObject().getClass().toString();
    }

    @Override
    public Collection<String> getAllTypeNamesOf() {
        return null;
    }
}

