/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.validate;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class EDataTypeConversion {
    private final Class<?>[][] integralsToFloatsArray = new Class[][]{{Byte.class, Float.class}, {Short.class, Float.class}, {Integer.class, Float.class}, {Long.class, Double.class}, {BigInteger.class, BigDecimal.class}};
    private final List<Class<?>> integrals = new ArrayList();
    private final List<Class<?>> floats = Arrays.asList(Float.class, Double.class, BigDecimal.class);

    public EDataTypeConversion() {
        int i = 0;
        while (i < this.integralsToFloatsArray.length) {
            this.integrals.add(this.integralsToFloatsArray[i][0]);
            ++i;
        }
    }

    public boolean isConvertable(EDataType leftDataType, EDataType rightDataType) {
        if (leftDataType == null || rightDataType == null) {
            throw new IllegalArgumentException("null data type");
        }
        if (leftDataType.getInstanceClass() == null || rightDataType.getInstanceClass() == null) {
            return false;
        }
        Class leftClass = EcoreUtil.wrapperClassFor((Class)leftDataType.getInstanceClass());
        Class rightClass = EcoreUtil.wrapperClassFor((Class)rightDataType.getInstanceClass());
        if (Number.class.isAssignableFrom(leftClass) && Number.class.isAssignableFrom(leftClass)) {
            return this.isConvertable(leftClass, rightClass);
        }
        return leftClass.equals(rightClass);
    }

    private boolean isConvertable(Class<?> left, Class<?> right) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("null Class argument");
        }
        int leftPos = this.integrals.indexOf(left);
        int rightPos = this.integrals.indexOf(right);
        if (leftPos >= 0) {
            if (rightPos < 0) {
                return false;
            }
        } else {
            leftPos = this.floats.indexOf(left);
            if (leftPos >= 0) {
                if (rightPos >= 0) {
                    rightPos = this.floats.indexOf(this.integralsToFloatsArray[rightPos][1]);
                } else {
                    rightPos = this.floats.indexOf(right);
                    if (rightPos < 0) {
                        return false;
                    }
                }
                return leftPos >= rightPos;
            }
        }
        return left.isAssignableFrom(right);
    }
}

