/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.cm;

import org.eclipse.equinox.internal.cm.ConfigurationAdminFactory;
import org.eclipse.equinox.internal.cm.ConfigurationEventAdapter;
import org.eclipse.equinox.internal.cm.LogTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationAdmin;

public class Activator
implements BundleActivator {
    private static final String EVENT_ADMIN_CLASS = "org.osgi.service.event.EventAdmin";
    private LogTracker logTracker;
    private ServiceRegistration<?> registration;
    private ConfigurationAdminFactory factory;
    private ConfigurationEventAdapter eventAdapter;
    private static BundleContext bundleContext;

    private static synchronized void setBundleContext(BundleContext context) {
        bundleContext = context;
    }

    public static synchronized String getProperty(String key) {
        if (bundleContext != null) {
            return bundleContext.getProperty(key);
        }
        return null;
    }

    public void start(BundleContext context) throws Exception {
        Activator.setBundleContext(context);
        this.logTracker = new LogTracker(context, System.err);
        this.logTracker.open();
        if (Activator.checkEventAdmin()) {
            this.eventAdapter = new ConfigurationEventAdapter(context);
            this.eventAdapter.start();
        }
        this.factory = new ConfigurationAdminFactory(context, this.logTracker);
        this.factory.start();
        context.addBundleListener((BundleListener)this.factory);
        this.registration = context.registerService(ConfigurationAdmin.class.getName(), (Object)this.factory, null);
    }

    public void stop(BundleContext context) throws Exception {
        this.registration.unregister();
        this.registration = null;
        context.removeBundleListener((BundleListener)this.factory);
        this.factory.stop();
        this.factory = null;
        if (this.eventAdapter != null) {
            this.eventAdapter.stop();
            this.eventAdapter = null;
        }
        this.logTracker.close();
        this.logTracker = null;
        Activator.setBundleContext(null);
    }

    private static boolean checkEventAdmin() {
        try {
            Class.forName(EVENT_ADMIN_CLASS);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

