/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import java.util.BitSet;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.escet.cif.checkers.CifCheckNoCompDefInst;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifTypeUtils;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.cif.types.DictType;
import org.eclipse.escet.cif.metamodel.cif.types.Field;
import org.eclipse.escet.cif.metamodel.cif.types.ListType;
import org.eclipse.escet.cif.metamodel.cif.types.SetType;
import org.eclipse.escet.cif.metamodel.cif.types.TupleType;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class TypeNoSpecificNestedTypesCheck
extends CifCheckNoCompDefInst {
    private static final int NUM_CONTAINER_TYPES = ContainerType.values().length;
    public static final boolean ALLOW_ALL = true;
    public static final boolean FORBID_ALL = false;
    public static final Set<ContainerType> ALL_LISTS = EnumSet.of(ContainerType.ARRAY, ContainerType.NON_ARRAY_LIST);
    public static final Set<ContainerType> ALL_CONTAINERS = EnumSet.allOf(ContainerType.class);
    private final BitSet allowed = new BitSet(NUM_CONTAINER_TYPES * NUM_CONTAINER_TYPES);

    public TypeNoSpecificNestedTypesCheck(boolean allowAll) {
        if (allowAll) {
            this.allowed.set(0, NUM_CONTAINER_TYPES * NUM_CONTAINER_TYPES);
        } else {
            this.allowed.clear();
        }
    }

    public TypeNoSpecificNestedTypesCheck allow(ContainerType outerType, ContainerType innerType) {
        this.allowed.set(this.computeIndex(outerType, innerType));
        return this;
    }

    public TypeNoSpecificNestedTypesCheck allow(Set<ContainerType> outerTypes, ContainerType innerType) {
        return this.allow(outerTypes, EnumSet.of(innerType));
    }

    public TypeNoSpecificNestedTypesCheck allow(ContainerType outerType, Set<ContainerType> innerTypes) {
        return this.allow(EnumSet.of(outerType), innerTypes);
    }

    public TypeNoSpecificNestedTypesCheck allow(Set<ContainerType> outerTypes, Set<ContainerType> innerTypes) {
        for (ContainerType outerType : outerTypes) {
            for (ContainerType innerType : innerTypes) {
                this.allow(outerType, innerType);
            }
        }
        return this;
    }

    public TypeNoSpecificNestedTypesCheck forbid(ContainerType outerType, ContainerType innerType) {
        this.allowed.clear(this.computeIndex(outerType, innerType));
        return this;
    }

    public TypeNoSpecificNestedTypesCheck forbid(Set<ContainerType> outerTypes, ContainerType innerType) {
        return this.forbid(outerTypes, EnumSet.of(innerType));
    }

    public TypeNoSpecificNestedTypesCheck forbid(ContainerType outerType, Set<ContainerType> innerTypes) {
        return this.forbid(EnumSet.of(outerType), innerTypes);
    }

    public TypeNoSpecificNestedTypesCheck forbid(Set<ContainerType> outerTypes, Set<ContainerType> innerTypes) {
        for (ContainerType outerType : outerTypes) {
            for (ContainerType innerType : innerTypes) {
                this.forbid(outerType, innerType);
            }
        }
        return this;
    }

    private boolean isSameInnerListAllowance(ContainerType outerType) {
        int innerArrayNestingIndex = this.computeIndex(outerType, ContainerType.ARRAY);
        int innerNonArrayNestingIndex = this.computeIndex(outerType, ContainerType.NON_ARRAY_LIST);
        return this.allowed.get(innerArrayNestingIndex) == this.allowed.get(innerNonArrayNestingIndex);
    }

    private boolean isSameOuterListAllowance(ContainerType innerType) {
        int outerArrayNestingIndex = this.computeIndex(ContainerType.ARRAY, innerType);
        int outerNonArrayNestingIndex = this.computeIndex(ContainerType.NON_ARRAY_LIST, innerType);
        return this.allowed.get(outerArrayNestingIndex) == this.allowed.get(outerNonArrayNestingIndex);
    }

    private int computeIndex(ContainerType outerType, ContainerType innerType) {
        return innerType.ordinal() + NUM_CONTAINER_TYPES * outerType.ordinal();
    }

    protected void preprocessListType(ListType listType, CifCheckViolations violations) {
        this.checkCombination(TypeNoSpecificNestedTypesCheck.getContainerType((CifType)listType), listType.getElementType(), violations);
    }

    protected void preprocessDictType(DictType dictType, CifCheckViolations violations) {
        this.checkCombination(ContainerType.DICTIONARY, dictType.getKeyType(), violations);
        this.checkCombination(ContainerType.DICTIONARY, dictType.getValueType(), violations);
    }

    protected void preprocessSetType(SetType setType, CifCheckViolations violations) {
        this.checkCombination(ContainerType.SET, setType.getElementType(), violations);
    }

    protected void preprocessTupleType(TupleType tupleType, CifCheckViolations violations) {
        for (Field fld : tupleType.getFields()) {
            this.checkCombination(ContainerType.TUPLE, fld.getType(), violations);
        }
    }

    private static ContainerType getContainerType(CifType type) {
        if ((type = CifTypeUtils.normalizeType((CifType)type)) instanceof ListType) {
            ListType lt = (ListType)type;
            return CifTypeUtils.isArrayType((ListType)lt) ? ContainerType.ARRAY : ContainerType.NON_ARRAY_LIST;
        }
        if (type instanceof DictType) {
            return ContainerType.DICTIONARY;
        }
        if (type instanceof SetType) {
            return ContainerType.SET;
        }
        if (type instanceof TupleType) {
            return ContainerType.TUPLE;
        }
        return null;
    }

    private void checkCombination(ContainerType outerType, CifType innerCifType, CifCheckViolations violations) {
        boolean sameAllowance;
        boolean sameAllowance2;
        ContainerType innerType = TypeNoSpecificNestedTypesCheck.getContainerType(innerCifType);
        if (outerType == null || innerType == null) {
            return;
        }
        if (this.allowed.get(this.computeIndex(outerType, innerType))) {
            return;
        }
        String innerPhrase = ALL_LISTS.contains((Object)innerType) ? ((sameAllowance2 = this.isSameInnerListAllowance(outerType)) ? ContainerType.genericListContainerPhrase : innerType.phrase) : innerType.phrase;
        String outerPhrase = ALL_LISTS.contains((Object)outerType) ? ((sameAllowance = this.isSameOuterListAllowance(innerType)) ? ContainerType.genericListContainerPhrase : outerType.phrase) : outerType.phrase;
        violations.add((PositionObject)innerCifType, "A%s type is nested inside a%s type", innerPhrase, outerPhrase);
    }

    public static enum ContainerType {
        ARRAY("n array"),
        DICTIONARY(" dictionary"),
        NON_ARRAY_LIST(" non-array list"),
        SET(" set"),
        TUPLE(" tuple");

        public static String genericListContainerPhrase;
        public final String phrase;

        static {
            genericListContainerPhrase = " list";
        }

        private ContainerType(String phrase) {
            this.phrase = phrase;
        }
    }
}

