/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.varorder.hyperedges;

import java.util.Set;
import org.eclipse.escet.cif.common.CifEquationUtils;
import org.eclipse.escet.cif.common.CifLocationUtils;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.AlgVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.AlgVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.DiscVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.InputVariableExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.LocationExpression;
import org.eclipse.escet.cif.metamodel.java.CifWithArgWalker;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

class VariableCollector
extends CifWithArgWalker<Set<PositionObject>> {
    private final Set<AlgVariable> alreadyConsidered = Sets.set();

    VariableCollector() {
    }

    Set<PositionObject> collectCifVarObjs(Update update, Set<PositionObject> cifVarObjs) {
        this.walkUpdate(update, cifVarObjs);
        return cifVarObjs;
    }

    Set<PositionObject> collectCifVarObjs(Expression expr, Set<PositionObject> cifVarObjs) {
        this.walkExpression(expr, cifVarObjs);
        return cifVarObjs;
    }

    protected void preprocessDiscVariableExpression(DiscVariableExpression expr, Set<PositionObject> cifVarObjs) {
        cifVarObjs.add((PositionObject)expr.getVariable());
    }

    protected void preprocessInputVariableExpression(InputVariableExpression expr, Set<PositionObject> cifVarObjs) {
        cifVarObjs.add((PositionObject)expr.getVariable());
    }

    protected void preprocessLocationExpression(LocationExpression expr, Set<PositionObject> cifVarObjs) {
        Location loc = expr.getLocation();
        Automaton aut = CifLocationUtils.getAutomaton((Location)loc);
        if (aut.getLocations().size() > 1) {
            cifVarObjs.add((PositionObject)aut);
        }
    }

    protected void preprocessAlgVariableExpression(AlgVariableExpression expr, Set<PositionObject> cifVarObjs) {
        AlgVariable algVar = expr.getVariable();
        if (this.alreadyConsidered.contains(algVar)) {
            return;
        }
        this.alreadyConsidered.add(algVar);
        Expression value = CifEquationUtils.getSingleValueForAlgVar((AlgVariable)algVar);
        this.walkExpression(value, cifVarObjs);
    }
}

