/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.transitions;

import org.eclipse.escet.cif.simulator.input.ChosenTargetTime;
import org.eclipse.escet.common.java.Assert;

public class ActualTargetTime {
    public final double sourceTime;
    public final double targetTime;
    public final boolean interrupted;

    public ActualTargetTime(ChosenTargetTime chosenTargetTime) {
        this(chosenTargetTime.sourceTime, chosenTargetTime.targetTime, false);
    }

    public ActualTargetTime(ChosenTargetTime chosenTargetTime, double actualTargetTime) {
        this(chosenTargetTime.sourceTime, actualTargetTime, true);
        Assert.check((actualTargetTime < chosenTargetTime.targetTime ? 1 : 0) != 0);
    }

    private ActualTargetTime(double sourceTime, double targetTime, boolean interrupted) {
        this.sourceTime = sourceTime;
        this.targetTime = targetTime;
        this.interrupted = interrupted;
        Assert.check((sourceTime < targetTime ? 1 : 0) != 0);
    }

    public double getDelay() {
        return this.targetTime - this.sourceTime;
    }
}

