/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.eclipse.ui;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.console.Console;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.DateTimeUtils;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.part.FileEditorInput;

public abstract class BaseFileCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        final List<IFile> files = this.getFiles(event);
        boolean saveSuccess = PlatformUI.getWorkbench().saveAllEditors(true);
        if (!saveSuccess) {
            return null;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                BaseFileCommandHandler.this.run(files);
            }
        };
        Thread t = new Thread(runnable, ((Object)((Object)this)).getClass().getName());
        t.start();
        return null;
    }

    private final List<IFile> getFiles(ExecutionEvent event) {
        String ipathParam;
        boolean debug = false;
        if (debug) {
            Object[][] infos;
            Object[][] objectArrayArray = infos = new Object[][]{{"Trigger:                  ", event.getTrigger()}, {"Current selection:        ", HandlerUtil.getCurrentSelection((ExecutionEvent)event)}, {"Active menu selection:    ", HandlerUtil.getActiveMenuSelection((ExecutionEvent)event)}, {"Active menu editor input: ", HandlerUtil.getActiveMenuEditorInput((ExecutionEvent)event)}, {"Active part:              ", HandlerUtil.getActivePart((ExecutionEvent)event)}, {"Active editor:            ", HandlerUtil.getActiveEditor((ExecutionEvent)event)}, {"Active editor input:      ", HandlerUtil.getActiveEditorInput((ExecutionEvent)event)}, {"Parameters:               ", event.getParameters().size()}};
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] info = objectArrayArray[n2];
                System.out.format("%s%s\n", info[0], info[1]);
                ++n2;
            }
            Iterator iterator = event.getParameters().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry param;
                Map.Entry entry = param = iterator.next();
                System.out.format(" - %s: %s\n", entry.getKey(), entry.getValue());
            }
            System.out.println();
        }
        if ((ipathParam = event.getParameter(IPath.class.getName())) != null) {
            Path path = new Path(ipathParam);
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = root.getFileForLocation((IPath)path);
            if (file == null) {
                throw new RuntimeException("No file found for path: " + String.valueOf(path));
            }
            return Lists.list((Object)file);
        }
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        if (selection == null) {
            selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        }
        if (selection instanceof ITextSelection) {
            IEditorPart editorPart;
            IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
            Assert.check((activePart == (editorPart = HandlerUtil.getActiveEditor((ExecutionEvent)event)) ? 1 : 0) != 0);
            Assert.notNull((Object)editorPart);
            IEditorInput editorInput = editorPart.getEditorInput();
            Assert.check((boolean)(editorInput instanceof FileEditorInput));
            FileEditorInput fileInput = (FileEditorInput)editorInput;
            List files = Lists.list((Object)fileInput.getFile());
            return files;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            List files = structuredSelection.toList();
            return files;
        }
        throw new RuntimeException("Unexpected selection: " + String.valueOf(selection));
    }

    public void run(List<IFile> files) {
        Application<?> app;
        Constructor<Application<?>> constructor;
        Assert.check((!files.isEmpty() ? 1 : 0) != 0);
        this.checkFileCount(files);
        Console console = new Console("Initializing...");
        Class<Application<?>> appClass = this.getApplicationClass();
        try {
            constructor = appClass.getConstructor(AppStreams.class);
        }
        catch (NoSuchMethodException e) {
            String msg = "No constructor with AppStreams argument found for class: " + String.valueOf(appClass);
            throw new RuntimeException(msg, e);
        }
        try {
            app = constructor.newInstance(console.getStreams());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Failed to create app: " + String.valueOf(appClass), e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Failed to create app: " + String.valueOf(appClass), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to create app: " + String.valueOf(appClass), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Failed to create app: " + String.valueOf(appClass), e);
        }
        long startNano = System.nanoTime();
        Date startDate = new Date();
        String startDateText = DateTimeUtils.formatDateTime((Date)startDate, (boolean)false);
        String filesTitleText = files.size() == 1 ? BaseFileCommandHandler.getWorkspacePath((IFile)Lists.first(files)) : Strings.fmt((String)"%d files", (Object[])new Object[]{files.size()});
        String title = Strings.fmt((String)"%s [running] %s (started at %s)", (Object[])new Object[]{app.getAppName(), filesTitleText, startDateText});
        console.setNameSync(title);
        console.setApplication(app);
        String parentDir = BaseFileCommandHandler.getParentLocal((IFile)Lists.first(files));
        Paths.setCurWorkingDir((String)parentDir);
        String[] args = this.getCommandLineArgs(files, parentDir);
        int exitCode = app.run(args, false);
        Thread refreshThread = new Thread(() -> {
            List<CoreException> list2 = BaseFileCommandHandler.refreshFileProjects(files);
        });
        refreshThread.setName(((Object)((Object)this)).getClass().getName() + ": refreshFileProjects");
        refreshThread.start();
        console.cleanup();
        String exitTxt = exitCode != 0 ? "FAILED after" : (app.isTerminationRequested() ? "TERMINATED after" : "FINISHED in");
        long runningNano = System.nanoTime() - startNano;
        title = Strings.fmt((String)"%s [%s %s] %s (started at %s)", (Object[])new Object[]{app.getAppName(), exitTxt, DateTimeUtils.durationToString((long)DateTimeUtils.nanoTimeToMillis((long)runningNano), (boolean)true), filesTitleText, startDateText});
        console.setNameSync(title);
    }

    protected abstract void checkFileCount(List<IFile> var1);

    protected abstract Class<? extends Application<?>> getApplicationClass();

    protected abstract String[] getCommandLineArgs(List<IFile> var1, String var2);

    protected static String getLocalFilePath(IFile file) {
        return file.getLocation().toOSString();
    }

    protected static String getWorkspacePath(IFile file) {
        return file.getFullPath().toString();
    }

    protected static String getFileName(IFile file) {
        return file.getName();
    }

    protected static String getParentLocal(IFile file) {
        return file.getLocation().removeLastSegments(1).toOSString();
    }

    protected static String getParentWorkspace(IFile file) {
        return file.getParent().toString();
    }

    protected static CoreException refreshFileProject(IFile file) {
        try {
            file.getProject().refreshLocal(2, null);
            return null;
        }
        catch (CoreException e) {
            return e;
        }
    }

    protected static List<CoreException> refreshFileProjects(List<IFile> files) {
        Set projs = Sets.set();
        for (IFile file : files) {
            projs.add(file.getProject());
        }
        List failures = Lists.list();
        for (IProject proj : projs) {
            try {
                proj.refreshLocal(2, null);
            }
            catch (CoreException e) {
                failures.add(e);
            }
        }
        return failures;
    }
}

