/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks.invcheck;

import java.util.EnumSet;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoKindInterface;
import org.eclipse.escet.cif.checkers.checks.invcheck.SubSetRelation;
import org.eclipse.escet.cif.metamodel.cif.InvKind;

public enum NoInvariantKind implements NoKindInterface<InvKind>
{
    ALL_KINDS(EnumSet.allOf(InvKind.class), null),
    STATE(EnumSet.of(InvKind.STATE), "state"),
    STATE_EVENT(EnumSet.of(InvKind.EVENT_DISABLES, InvKind.EVENT_NEEDS), "state/event exclusion"),
    STATE_EVENT_DISABLES(EnumSet.of(InvKind.EVENT_DISABLES), "'disables' state/event exclusion"),
    STATE_EVENT_NEEDS(EnumSet.of(InvKind.EVENT_NEEDS), "'needs' state/event exclusion");

    public static final int NUMBER_OF_VALUES;
    private final EnumSet<InvKind> disallowedValues;
    private final String reportText;

    static {
        NUMBER_OF_VALUES = InvKind.values().length;
    }

    private NoInvariantKind(EnumSet<InvKind> disallowedValues, String reportText) {
        this.disallowedValues = disallowedValues;
        this.reportText = reportText;
    }

    @Override
    public boolean isDisallowed(InvKind value) {
        return this.disallowedValues.contains(value);
    }

    public SubSetRelation compareSubset(NoInvariantKind right) {
        return SubSetRelation.compare(this.disallowedValues, right.disallowedValues);
    }

    @Override
    public String getReportText() {
        return this.reportText;
    }
}

