/******************************************************************************
 * Copyright (c) 2024, 2026 Contributors to the Eclipse Foundation
 *
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This program and the accompanying materials are made available under the terms
 * of the MIT License which is available at https://opensource.org/licenses/MIT
 *
 *  SPDX-License-Identifier: MIT
 *****************************************************************************/

/* mCRL2 language for highlight.js 11.9.0. */
/* Based on mCRL2 version 202307.1.3444b53c48. */
(() => {
    var e = (() => {
        "use strict";
        return e => {
            return {
                name: "mCRL2",
                keywords: {
                    keyword: [
                        // Reserved words: language keywords, predefined operators and types, and predefined constants.
                        "act", "allow", "block", "comm", "cons", "delay", "div", "end", "eqn", "exists",
                        "forall", "glob", "hide", "if", "in", "init", "lambda", "map", "mod", "mu", "nu", "pbes",
                        "proc", "rename", "sort", "struct", "sum", "val", "var", "whr", "yaled",
                        "Bag", "Bool", "Int", "List", "Nat", "Pos", "Real", "Set",
                        "delta", "false", "nil", "tau", "true",

                        // Constructed sorts.
                        "FSet", "FBag",

                        // Predefined operations on numeric sorts.
                        "min", "max", "succ", "pred", "exp", "abs", "floor", "ceil", "round", "Pos2Nat", "Nat2Pos",

                        // Predefined operations on lists.
                        "head", "tail", "rhead", "rtail",

                        // Predefined operations on sets.
                        "count",
                        "Set2Bag", "Bag2Set",

                        // Process syntax.
                        "dist",
                    ],
                },
                contains: [
                    // Numbers.
                    {
                        scope: "number",
                        match: /(?<![A-Za-z_0-9'])(0|[1-9][0-9]*)(?![A-Za-z_0-9'])/,
                    },

                    // Comments.
                    {
                        scope: "comment",
                        begin: '%',
                        end: '$',
                    },
                ]
            }
        }
    })();
    hljs.registerLanguage("mcrl2", e)
})();
