/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.plcgen.generators;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.checkers.CifCheck;
import org.eclipse.escet.cif.checkers.CifPreconditionChecker;
import org.eclipse.escet.cif.checkers.checks.AutOnlyWithCertainNumberOfInitLocsCheck;
import org.eclipse.escet.cif.checkers.checks.CompNoInitPredsCheck;
import org.eclipse.escet.cif.checkers.checks.EdgeNoUrgentCheck;
import org.eclipse.escet.cif.checkers.checks.EqnNotAllowedCheck;
import org.eclipse.escet.cif.checkers.checks.EventNoPureMonitorsCheck;
import org.eclipse.escet.cif.checkers.checks.EventOnlyWithControllabilityCheck;
import org.eclipse.escet.cif.checkers.checks.ExprNoSpecificBinaryExprsCheck;
import org.eclipse.escet.cif.checkers.checks.ExprNoSpecificExprsCheck;
import org.eclipse.escet.cif.checkers.checks.ExprNoSpecificUnaryExprsCheck;
import org.eclipse.escet.cif.checkers.checks.FuncNoSpecificIntUserDefFuncStatsCheck;
import org.eclipse.escet.cif.checkers.checks.FuncNoSpecificStdLibCheck;
import org.eclipse.escet.cif.checkers.checks.FuncNoSpecificUserDefCheck;
import org.eclipse.escet.cif.checkers.checks.InvNoSpecificInvsCheck;
import org.eclipse.escet.cif.checkers.checks.LocNoUrgentCheck;
import org.eclipse.escet.cif.checkers.checks.SpecAutomataCountsCheck;
import org.eclipse.escet.cif.checkers.checks.TypeListSizeLimitsCheck;
import org.eclipse.escet.cif.checkers.checks.TypeNoSpecificNestedTypesCheck;
import org.eclipse.escet.cif.checkers.checks.TypeNoSpecificTypesCheck;
import org.eclipse.escet.cif.checkers.checks.VarNoDiscWithMultiInitValuesCheck;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantKind;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantPlaceKind;
import org.eclipse.escet.cif.checkers.checks.invcheck.NoInvariantSupKind;
import org.eclipse.escet.cif.cif2cif.AddDefaultInitialValues;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.cif2cif.ElimConsts;
import org.eclipse.escet.cif.cif2cif.ElimLocRefExprs;
import org.eclipse.escet.cif.cif2cif.ElimStateEvtExclInvs;
import org.eclipse.escet.cif.cif2cif.RemoveAnnotations;
import org.eclipse.escet.cif.cif2cif.RemoveIoDecls;
import org.eclipse.escet.cif.cif2cif.SimplifyOthers;
import org.eclipse.escet.cif.cif2cif.SimplifyValues;
import org.eclipse.escet.cif.cif2cif.SwitchesToIfs;
import org.eclipse.escet.cif.common.CifCollectUtils;
import org.eclipse.escet.cif.common.CifEdgeUtils;
import org.eclipse.escet.cif.common.CifExecSchemeUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeReceive;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeSend;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.automata.Monitors;
import org.eclipse.escet.cif.metamodel.cif.automata.Update;
import org.eclipse.escet.cif.metamodel.cif.declarations.Constant;
import org.eclipse.escet.cif.metamodel.cif.declarations.ContVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.Declaration;
import org.eclipse.escet.cif.metamodel.cif.declarations.DiscVariable;
import org.eclipse.escet.cif.metamodel.cif.declarations.EnumDecl;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.declarations.InputVariable;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.TauExpression;
import org.eclipse.escet.cif.plcgen.PlcGenSettings;
import org.eclipse.escet.cif.plcgen.generators.CifEventTransition;
import org.eclipse.escet.cif.plcgen.generators.ComponentDocData;
import org.eclipse.escet.cif.plcgen.generators.prechecks.VarContOnlyTimers;
import org.eclipse.escet.cif.plcgen.targets.PlcTarget;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.PathPair;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.java.output.WarnOutput;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifProcessor {
    private final PlcTarget target;
    private final Specification inputSpec;
    private final PathPair inputPaths;
    private final boolean simplifyValues;
    private final WarnOutput warnOutput;
    private final Termination termination;

    public CifProcessor(PlcTarget target, Specification inputSpec, PlcGenSettings settings) {
        this.target = target;
        this.inputSpec = inputSpec;
        this.inputPaths = settings.inputPaths;
        this.simplifyValues = settings.simplifyValues;
        this.warnOutput = settings.warnOutput;
        this.termination = settings.termination;
    }

    public CifProcessorResults process() {
        this.widenSpec(this.inputSpec);
        this.preCheckSpec(this.inputSpec, this.inputPaths.systemPath, this.termination);
        this.normalizeSpec(this.inputSpec);
        Map componentDatas = Maps.map();
        List discVariables = Lists.list();
        List inputVariables = Lists.list();
        List enumDecls = Lists.list();
        List contVariables = Lists.list();
        List constants = Lists.list();
        for (Declaration decl : (List)CifCollectUtils.collectDeclarations((ComplexComponent)this.inputSpec, (Collection)Lists.list())) {
            Constant constant;
            ComponentDocData compData = componentDatas.computeIfAbsent((ComplexComponent)decl.eContainer(), comp -> new ComponentDocData((ComplexComponent)comp));
            if (decl instanceof DiscVariable) {
                DiscVariable discVar = (DiscVariable)decl;
                compData.variables.add(decl);
                discVariables.add(discVar);
                continue;
            }
            if (decl instanceof InputVariable) {
                InputVariable inpVar = (InputVariable)decl;
                compData.variables.add(decl);
                inputVariables.add(inpVar);
                continue;
            }
            if (decl instanceof EnumDecl) {
                EnumDecl enumDecl = (EnumDecl)decl;
                enumDecls.add(enumDecl);
                continue;
            }
            if (decl instanceof ContVariable) {
                ContVariable contVar = (ContVariable)decl;
                compData.variables.add(decl);
                contVariables.add(contVar);
                continue;
            }
            if (!(decl instanceof Constant) || !this.target.supportsConstant(constant = (Constant)decl)) continue;
            constants.add(constant);
        }
        List automata = (List)CifCollectUtils.collectAutomata((ComplexComponent)this.inputSpec, (Collection)Lists.list());
        CifExecSchemeUtils.orderAutomata((List)automata);
        Map eventTransitions = Maps.map();
        for (Automaton aut : automata) {
            Map<Event, AutomatonRoleInfo> autRoleInfoPerEvent = this.classifyAutomatonRole(aut);
            ComponentDocData compData = componentDatas.computeIfAbsent(aut, comp -> new ComponentDocData((ComplexComponent)comp));
            compData.addEvents(autRoleInfoPerEvent.keySet());
            for (AutomatonRoleInfo autRoleInfo : autRoleInfoPerEvent.values()) {
                CifEventTransition eventTrans = eventTransitions.computeIfAbsent(autRoleInfo.event, evt -> new CifEventTransition((Event)evt));
                if (autRoleInfo.isSenderAutomaton()) {
                    eventTrans.senders.add(new CifEventTransition.TransitionAutomaton(aut, CifEventTransition.TransAutPurpose.SENDER, autRoleInfo.getSenderEdges()));
                    continue;
                }
                if (autRoleInfo.isReceiverAutomaton()) {
                    eventTrans.receivers.add(new CifEventTransition.TransitionAutomaton(aut, CifEventTransition.TransAutPurpose.RECEIVER, autRoleInfo.getReceiverEdges()));
                    continue;
                }
                if (autRoleInfo.isSyncerAutomaton()) {
                    eventTrans.syncers.add(new CifEventTransition.TransitionAutomaton(aut, CifEventTransition.TransAutPurpose.SYNCER, autRoleInfo.getSyncerEdges()));
                    continue;
                }
                if (autRoleInfo.isMonitorAutomaton()) {
                    eventTrans.monitors.add(new CifEventTransition.TransitionAutomaton(aut, CifEventTransition.TransAutPurpose.MONITOR, autRoleInfo.getMonitorEdges()));
                    continue;
                }
                throw new AssertionError((Object)"Undecided automaton role.");
            }
        }
        List events = (List)eventTransitions.keySet().stream().collect(Lists.toList());
        CifExecSchemeUtils.orderEvents((List)events);
        List<CifEventTransition> cifEventTransitions = events.stream().map(evt -> (CifEventTransition)eventTransitions.get(evt)).toList();
        return new CifProcessorResults(componentDatas, discVariables, inputVariables, enumDecls, contVariables, constants, cifEventTransitions, new CifObjectFinder(this.inputSpec));
    }

    private static AutomatonRoleInfo getAutRoleInfo(Map<Event, AutomatonRoleInfo> autRoleInfoPerEvent, Event event) {
        return autRoleInfoPerEvent.computeIfAbsent(event, evt -> new AutomatonRoleInfo((Event)evt));
    }

    private Map<Event, AutomatonRoleInfo> classifyAutomatonRole(Automaton aut) {
        Map autRoleInfoPerEvent = Maps.map();
        if (aut.getAlphabet() != null) {
            for (Expression expr2 : aut.getAlphabet().getEvents()) {
                EventExpression eve = (EventExpression)expr2;
                CifProcessor.getAutRoleInfo(autRoleInfoPerEvent, eve.getEvent());
            }
        }
        for (Location loc : aut.getLocations()) {
            int edgeNum = 1;
            for (Edge edge : loc.getEdges()) {
                Location destLoc = CifEdgeUtils.getTarget((Edge)edge);
                Assert.check((!edge.getEvents().isEmpty() ? 1 : 0) != 0);
                for (EdgeEvent ee : edge.getEvents()) {
                    CifEventTransition.TransitionEdge te;
                    Expression eventRef = ee.getEvent();
                    Assert.check((!(eventRef instanceof TauExpression) ? 1 : 0) != 0);
                    EventExpression eve = (EventExpression)eventRef;
                    AutomatonRoleInfo autRoleInfo = CifProcessor.getAutRoleInfo(autRoleInfoPerEvent, eve.getEvent());
                    if (ee instanceof EdgeSend) {
                        EdgeSend es = (EdgeSend)ee;
                        te = new CifEventTransition.TransitionEdge(edge, edgeNum, loc, destLoc, es.getValue(), (List<Expression>)edge.getGuards(), (List<Update>)edge.getUpdates());
                        autRoleInfo.addEdge(te, AutomatonRole.SENDER);
                        continue;
                    }
                    if (ee instanceof EdgeReceive) {
                        te = new CifEventTransition.TransitionEdge(edge, edgeNum, loc, destLoc, null, (List<Expression>)edge.getGuards(), (List<Update>)edge.getUpdates());
                        autRoleInfo.addEdge(te, AutomatonRole.RECEIVER);
                        continue;
                    }
                    te = new CifEventTransition.TransitionEdge(edge, edgeNum, loc, destLoc, null, (List<Expression>)edge.getGuards(), (List<Update>)edge.getUpdates());
                    autRoleInfo.addEdge(te, AutomatonRole.SYNCER_OR_MONITOR);
                }
                ++edgeNum;
            }
        }
        if (aut.getMonitors() != null) {
            Monitors mons = aut.getMonitors();
            if (mons.getEvents().isEmpty()) {
                for (AutomatonRoleInfo autRoleInfo : autRoleInfoPerEvent.values()) {
                    autRoleInfo.setIsMonitor(true);
                }
            } else {
                Set monitorEvents = (Set)mons.getEvents().stream().map(expr -> ((EventExpression)expr).getEvent()).collect(Sets.toSet());
                for (AutomatonRoleInfo autRoleInfo : autRoleInfoPerEvent.values()) {
                    autRoleInfo.setIsMonitor(monitorEvents.contains(autRoleInfo.event));
                }
            }
        }
        for (AutomatonRoleInfo autRoleInfo : autRoleInfoPerEvent.values()) {
            if (!EnumSet.of(AutomatonRole.UNKNOWN, AutomatonRole.SYNCER_OR_MONITOR).contains((Object)autRoleInfo.autRole)) continue;
            autRoleInfo.setIsSyncer();
        }
        for (AutomatonRoleInfo autRoleInfo : autRoleInfoPerEvent.values()) {
            autRoleInfo.checkAutRoleIsDecided();
        }
        return autRoleInfoPerEvent;
    }

    private void widenSpec(Specification spec) {
        new RemoveAnnotations().except(new String[]{"doc"}).transform(spec);
        new ElimComponentDefInst().transform(spec);
        new ElimStateEvtExclInvs(this.warnOutput).transform(spec);
        if (this.simplifyValues) {
            new SimplifyValues().transform(spec);
            new ElimConsts().transform(spec);
        }
        new SimplifyOthers().transform(spec);
        RemoveIoDecls removeIoDecls = new RemoveIoDecls();
        removeIoDecls.transform(spec);
        removeIoDecls.warnAboutIgnoredSvgInputDecsIfRemoved(this.warnOutput);
    }

    private void preCheckSpec(Specification spec, String absSpecPath, Termination termination) {
        PlcGenPreChecker checker = new PlcGenPreChecker(this.target.supportsArrays(), termination);
        checker.reportPreconditionViolations(spec, absSpecPath, "CIF PLC code generator");
    }

    private void normalizeSpec(Specification spec) {
        new AddDefaultInitialValues(this.warnOutput).transform(spec);
        new SwitchesToIfs().transform(spec);
        new ElimLocRefExprs(a -> "", a -> "location", loc -> loc.getName(), false, true, false, null, true, true, true, true, this.warnOutput).transform(spec);
        if (this.simplifyValues) {
            new SimplifyValues().transform(spec);
            new ElimConsts().transform(spec);
        }
    }

    public static enum AutomatonRole {
        UNKNOWN,
        SENDER,
        RECEIVER,
        SYNCER,
        MONITOR,
        SYNCER_OR_MONITOR;

    }

    private static class AutomatonRoleInfo {
        public final Event event;
        private AutomatonRole autRole;
        private final List<CifEventTransition.TransitionEdge> edges = Lists.list();

        public AutomatonRoleInfo(Event event) {
            this.event = event;
            this.autRole = event.getType() == null ? AutomatonRole.SYNCER_OR_MONITOR : AutomatonRole.UNKNOWN;
        }

        public void addEdge(CifEventTransition.TransitionEdge transEdge, AutomatonRole edgeAutRole) {
            Assert.check((boolean)EnumSet.of(AutomatonRole.SENDER, AutomatonRole.RECEIVER, AutomatonRole.SYNCER_OR_MONITOR).contains((Object)edgeAutRole));
            this.edges.add(transEdge);
            switch (this.autRole) {
                case UNKNOWN: {
                    this.autRole = edgeAutRole;
                    break;
                }
                case SYNCER: 
                case MONITOR: 
                case SYNCER_OR_MONITOR: {
                    Assert.areEqual((Object)((Object)edgeAutRole), (Object)((Object)AutomatonRole.SYNCER_OR_MONITOR));
                    break;
                }
                case SENDER: 
                case RECEIVER: {
                    Assert.check((boolean)edgeAutRole.equals((Object)this.autRole));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected automaton role \"" + String.valueOf((Object)this.autRole) + "\"."));
                }
            }
        }

        public void setIsMonitor(boolean isMonitor) {
            AutomatonRole resultRole;
            if (EnumSet.of(AutomatonRole.SENDER, AutomatonRole.RECEIVER).contains((Object)this.autRole)) {
                Assert.check((!isMonitor ? 1 : 0) != 0);
                return;
            }
            AutomatonRole automatonRole = resultRole = isMonitor ? AutomatonRole.MONITOR : AutomatonRole.SYNCER;
            if (this.autRole == resultRole) {
                return;
            }
            if (EnumSet.of(AutomatonRole.SYNCER_OR_MONITOR, AutomatonRole.UNKNOWN).contains((Object)this.autRole)) {
                this.autRole = resultRole;
                return;
            }
            throw new AssertionError((Object)("Encountered unexpected automaton role \"" + String.valueOf((Object)this.autRole) + "\"."));
        }

        public void setIsSyncer() {
            Assert.check((boolean)EnumSet.of(AutomatonRole.UNKNOWN, AutomatonRole.SYNCER_OR_MONITOR).contains((Object)this.autRole));
            this.autRole = AutomatonRole.SYNCER;
        }

        private void checkAutRoleIsDecided() {
            Assert.check((boolean)EnumSet.of(AutomatonRole.SENDER, AutomatonRole.RECEIVER, AutomatonRole.SYNCER, AutomatonRole.MONITOR).contains((Object)this.autRole));
        }

        public boolean isSenderAutomaton() {
            this.checkAutRoleIsDecided();
            return this.autRole == AutomatonRole.SENDER;
        }

        public boolean isReceiverAutomaton() {
            this.checkAutRoleIsDecided();
            return this.autRole == AutomatonRole.RECEIVER;
        }

        public boolean isSyncerAutomaton() {
            this.checkAutRoleIsDecided();
            return this.autRole == AutomatonRole.SYNCER;
        }

        public boolean isMonitorAutomaton() {
            this.checkAutRoleIsDecided();
            return this.autRole == AutomatonRole.MONITOR;
        }

        public List<CifEventTransition.TransitionEdge> getSenderEdges() {
            Assert.check((boolean)this.isSenderAutomaton());
            return this.edges;
        }

        public List<CifEventTransition.TransitionEdge> getReceiverEdges() {
            Assert.check((boolean)this.isReceiverAutomaton());
            return this.edges;
        }

        public List<CifEventTransition.TransitionEdge> getSyncerEdges() {
            Assert.check((boolean)this.isSyncerAutomaton());
            return this.edges;
        }

        public List<CifEventTransition.TransitionEdge> getMonitorEdges() {
            Assert.check((boolean)this.isMonitorAutomaton());
            return this.edges;
        }
    }

    public static class CifObjectFinder {
        private final Specification spec;

        public CifObjectFinder(Specification spec) {
            Assert.notNull((Object)spec);
            this.spec = spec;
        }

        public PositionObject findCifObjectByAbsName(String absName) {
            Specification obj = this.spec;
            String[] stringArray = absName.split("\\.");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String namePart = stringArray[n2];
                obj = CifScopeUtils.getObject((PositionObject)obj, (String)namePart);
                ++n2;
            }
            return obj;
        }
    }

    public record CifProcessorResults(Map<ComplexComponent, ComponentDocData> componentDatas, List<DiscVariable> discVariables, List<InputVariable> inputVariables, List<EnumDecl> enumDecls, List<ContVariable> contVariables, List<Constant> constants, List<CifEventTransition> cifEventTransitions, CifObjectFinder cifObjectFinder) {
    }

    private static class PlcGenPreChecker
    extends CifPreconditionChecker {
        public PlcGenPreChecker(boolean supportArrays, Termination termination) {
            super(termination, new CifCheck[]{new SpecAutomataCountsCheck().setMinMaxAuts(1, -1), new CompNoInitPredsCheck(true), new VarNoDiscWithMultiInitValuesCheck(), new AutOnlyWithCertainNumberOfInitLocsCheck(AutOnlyWithCertainNumberOfInitLocsCheck.AllowedNumberOfInitLocs.EXACTLY_ONE), new InvNoSpecificInvsCheck().ignoreNeverBlockingInvariants().disallow(NoInvariantSupKind.ALL_KINDS, NoInvariantKind.STATE, NoInvariantPlaceKind.ALL_PLACES), new EventOnlyWithControllabilityCheck(), new EventNoPureMonitorsCheck(), new EqnNotAllowedCheck(), new LocNoUrgentCheck(), new EdgeNoUrgentCheck(), new FuncNoSpecificUserDefCheck(new FuncNoSpecificUserDefCheck.NoSpecificUserDefFunc[]{FuncNoSpecificUserDefCheck.NoSpecificUserDefFunc.EXTERNAL, FuncNoSpecificUserDefCheck.NoSpecificUserDefFunc.INTERNAL, FuncNoSpecificUserDefCheck.NoSpecificUserDefFunc.NO_PARAMETER}), new FuncNoSpecificIntUserDefFuncStatsCheck(new FuncNoSpecificIntUserDefFuncStatsCheck.NoSpecificStatement[]{FuncNoSpecificIntUserDefFuncStatsCheck.NoSpecificStatement.CONTINUE}), new TypeNoSpecificTypesCheck(new TypeNoSpecificTypesCheck.NoSpecificType[]{TypeNoSpecificTypesCheck.NoSpecificType.DICT_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.DIST_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.FUNC_TYPES_AS_DATA, TypeNoSpecificTypesCheck.NoSpecificType.SET_TYPES, TypeNoSpecificTypesCheck.NoSpecificType.STRING_TYPES, supportArrays ? TypeNoSpecificTypesCheck.NoSpecificType.LIST_TYPES_NON_ARRAY : TypeNoSpecificTypesCheck.NoSpecificType.LIST_TYPES}).ignoreAnnotations(), new TypeNoSpecificNestedTypesCheck(true).forbid(TypeNoSpecificNestedTypesCheck.ContainerType.ARRAY, TypeNoSpecificNestedTypesCheck.ContainerType.ARRAY), new TypeListSizeLimitsCheck(1, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE), new ExprNoSpecificExprsCheck(new ExprNoSpecificExprsCheck.NoSpecificExpr[]{ExprNoSpecificExprsCheck.NoSpecificExpr.CAST_EXPRS_FROM_STRING, ExprNoSpecificExprsCheck.NoSpecificExpr.CAST_EXPRS_TO_STRING, ExprNoSpecificExprsCheck.NoSpecificExpr.DICT_LITS, ExprNoSpecificExprsCheck.NoSpecificExpr.FUNC_REFS_USER_DEF_AS_DATA, ExprNoSpecificExprsCheck.NoSpecificExpr.PROJECTION_EXPRS_DICTS, ExprNoSpecificExprsCheck.NoSpecificExpr.PROJECTION_EXPRS_LISTS_NON_ARRAY, ExprNoSpecificExprsCheck.NoSpecificExpr.PROJECTION_EXPRS_STRINGS, ExprNoSpecificExprsCheck.NoSpecificExpr.SET_LITS, ExprNoSpecificExprsCheck.NoSpecificExpr.STRING_LITS, ExprNoSpecificExprsCheck.NoSpecificExpr.SLICE_EXPRS, ExprNoSpecificExprsCheck.NoSpecificExpr.SWITCH_EXPRS_LIST_ARRAY, ExprNoSpecificExprsCheck.NoSpecificExpr.SWITCH_EXPRS_TUPLE, ExprNoSpecificExprsCheck.NoSpecificExpr.TIME_VAR_REFS}).ignoreAnnotations(), new ExprNoSpecificUnaryExprsCheck(new ExprNoSpecificUnaryExprsCheck.NoSpecificUnaryOp[]{ExprNoSpecificUnaryExprsCheck.NoSpecificUnaryOp.SAMPLE}).ignoreAnnotations(), new ExprNoSpecificBinaryExprsCheck(new ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp[]{ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ADDITION_LISTS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ADDITION_STRINGS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ADDITION_DICTS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.ELEMENT_OF, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_DICT, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_LIST, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_SET, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_STRING, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.EQUAL_TUPLE, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBSET, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBTRACTION_DICTS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBTRACTION_LISTS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.SUBTRACTION_SETS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.CONJUNCTION_SETS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.DISJUNCTION_SETS, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_DICT, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_LIST, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_SET, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_STRING, ExprNoSpecificBinaryExprsCheck.NoSpecificBinaryOp.UNEQUAL_TUPLE}).ignoreAnnotations(), new FuncNoSpecificStdLibCheck(new FuncNoSpecificStdLibCheck.NoSpecificStdLib[]{FuncNoSpecificStdLibCheck.NoSpecificStdLib.ALL_STOCHASTIC, FuncNoSpecificStdLibCheck.NoSpecificStdLib.ACOSH, FuncNoSpecificStdLibCheck.NoSpecificStdLib.ASINH, FuncNoSpecificStdLibCheck.NoSpecificStdLib.ATANH, FuncNoSpecificStdLibCheck.NoSpecificStdLib.COSH, FuncNoSpecificStdLibCheck.NoSpecificStdLib.SINH, FuncNoSpecificStdLibCheck.NoSpecificStdLib.TANH, FuncNoSpecificStdLibCheck.NoSpecificStdLib.CBRT, FuncNoSpecificStdLibCheck.NoSpecificStdLib.DELETE, FuncNoSpecificStdLibCheck.NoSpecificStdLib.EMPTY, FuncNoSpecificStdLibCheck.NoSpecificStdLib.FORMAT, FuncNoSpecificStdLibCheck.NoSpecificStdLib.POP, FuncNoSpecificStdLibCheck.NoSpecificStdLib.POWER, FuncNoSpecificStdLibCheck.NoSpecificStdLib.SIZE}).ignoreAnnotations(), new VarContOnlyTimers()});
        }
    }
}

