//////////////////////////////////////////////////////////////////////////////
// Copyright (c) 2024, 2026 Contributors to the Eclipse Foundation
//
// See the NOTICE file(s) distributed with this work for additional
// information regarding copyright ownership.
//
// This program and the accompanying materials are made available
// under the terms of the MIT License which is available at
// https://opensource.org/licenses/MIT
//
// SPDX-License-Identifier: MIT
//////////////////////////////////////////////////////////////////////////////

package org.eclipse.escet.cif.simulator.input.trace;

import org.eclipse.escet.cif.simulator.runtime.model.RuntimeEnvironmentEvent;
import org.eclipse.escet.cif.simulator.runtime.model.RuntimeState;

/**
 * Trace input component 'update input variable command' environment event.
 *
 * @param <S> The type of state objects to use.
 */
public abstract class TraceInputRuntimeEnvironmentEvent<S extends RuntimeState> extends RuntimeEnvironmentEvent<S> {
    /** The absolute non-escaped name of the input variable. */
    public final String inputVarAbsName;

    /**
     * Constructor for the {@link TraceInputRuntimeEnvironmentEvent} class.
     *
     * @param name The name of the environment event. To avoid confusion it must not overlap with the syntax for
     *     possibly-escaped absolute CIF names.
     * @param idx The unique 0-based index of the event.
     * @param inputVarAbsName The absolute non-escaped name of the input variable.
     */
    public TraceInputRuntimeEnvironmentEvent(String name, int idx, String inputVarAbsName) {
        super(name, idx);
        this.inputVarAbsName = inputVarAbsName;
    }

    /**
     * Applies the updates of the trace input command to the target location.
     *
     * <p>
     * The provided {@code target} state is a shallow copy of the {@code source} state. Implementations of this method
     * should copy the input variables sub-state and modify it.
     * </p>
     *
     * @param source The source state to use for evaluations.
     * @param target The target state to update.
     * @param command The command to apply.
     */
    public abstract void update(S source, S target, InputVarUpdateTraceCommand command);
}
