/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ui.editor.folding;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.common.base.Import;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.ui.editor.folding.DefaultFoldingRegionProvider;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegionAcceptor;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegionAcceptorExtension;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.util.ITextRegion;

public class FoldingRegionProvider
extends DefaultFoldingRegionProvider {
    @Inject
    private ILocationInFileProvider locationInFileProvider;

    protected void computeCommentFolding(IXtextDocument xtextDocument, IFoldingRegionAcceptor<ITextRegion> foldingRegionAcceptor, ITypedRegion typedRegion, boolean initiallyFolded) throws BadLocationException {
        boolean isFolded = initiallyFolded;
        int offset = typedRegion.getOffset();
        int length = typedRegion.getLength();
        if (offset == 0) {
            String text = xtextDocument.get(offset, length);
            isFolded |= text.trim().toLowerCase().contains("copyright");
        }
        super.computeCommentFolding(xtextDocument, foldingRegionAcceptor, typedRegion, isFolded);
    }

    protected void computeObjectFolding(EObject eObject, IFoldingRegionAcceptor<ITextRegion> foldingRegionAcceptor, boolean initiallyFolded) {
        List imports;
        EReference importsFeature;
        boolean autoFoldPref = Platform.getPreferencesService().getBoolean("org.eclipse.etrice.ui.common.base", "AUTO_FOLD_IMPORTS", false, null);
        if (autoFoldPref && eObject instanceof Import && (importsFeature = eObject.eContainmentFeature()).isMany() && (imports = (List)eObject.eContainer().eGet((EStructuralFeature)importsFeature)).size() >= 2 && imports.get(0) == eObject) {
            ITextRegion region = imports.stream().map(imp -> this.locationInFileProvider.getFullTextRegion((EObject)imp)).reduce((first, second) -> first.merge(second)).get();
            ITextRegion significant = this.locationInFileProvider.getSignificantTextRegion(eObject);
            ((IFoldingRegionAcceptorExtension)foldingRegionAcceptor).accept(region.getOffset(), region.getLength(), true, (Object)significant);
        }
        super.computeObjectFolding(eObject, foldingRegionAcceptor, initiallyFolded);
    }
}

