/*
 * Copyright (c) 1997, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package ee.jakarta.tck.faces.test.servlet30.ajax;

import java.io.Serializable;

import jakarta.enterprise.context.SessionScoped;
import jakarta.inject.Named;

@Named
@SessionScoped
public class AjaxTable implements Serializable {

    private static final long serialVersionUID = 1L;

    private Info[] list = new Info[]{
            new Info(101, "Bob", ""),
            new Info(102, "Joe", ""),
            new Info(103, "Ron", ""),
    };

    private String selectedCity = "alpha";

    public Info[] getList() {
        return list;
    }

    public class Info {
        int id;
        String name;
        String city;

        public Info(int id, String name, String city) {
            this.id = id;
            this.name = name;
            this.city = city;
        }

        public int getId() {
            return id;
        }

        public String getName() {
            return name;
        }


        public String getCity() {
            return selectedCity;
        }

        public void setCity(String city) {
            this.city = city;
        }

    }

    public void setSelectedCity(String selectedCity) {
        this.selectedCity = selectedCity;
    }
    public String getSelectedCity() {
        return selectedCity;
    }
}
