package fr.inria.diverse.melange.utils;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import fr.inria.diverse.melange.metamodel.melange.ImportDsl;
import fr.inria.diverse.melange.metamodel.melange.Language;
import fr.inria.diverse.melange.metamodel.melange.ModelType;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.scoping.XbaseQualifiedNameProvider;

@SuppressWarnings("all")
public class MelangeQualifiedNameProvider extends XbaseQualifiedNameProvider {
  @Inject
  @Extension
  private IQualifiedNameConverter _iQualifiedNameConverter;
  
  @Override
  public QualifiedName getFullyQualifiedName(final EObject obj) {
    QualifiedName _xblockexpression = null;
    {
      if ((obj instanceof ImportDsl)) {
        return this.getFullyQualifiedName(((ImportDsl)obj));
      } else {
        if ((obj instanceof ModelType)) {
          Language _extracted = ((ModelType)obj).getExtracted();
          if ((_extracted instanceof ImportDsl)) {
            Language _extracted_1 = ((ModelType)obj).getExtracted();
            final QualifiedName importName = this.getFullyQualifiedName(((ImportDsl) _extracted_1));
            String _lastSegment = importName.getLastSegment();
            final String simpleName = (_lastSegment + "MT");
            return importName.skipLast(1).append(simpleName);
          }
        }
      }
      _xblockexpression = super.getFullyQualifiedName(obj);
    }
    return _xblockexpression;
  }
  
  public QualifiedName getFullyQualifiedName(final ImportDsl lang) {
    String _name = lang.getName();
    boolean _tripleNotEquals = (_name != null);
    if (_tripleNotEquals) {
      return this._iQualifiedNameConverter.toQualifiedName(lang.getName());
    }
    final Function1<EReference, Boolean> _function = new Function1<EReference, Boolean>() {
      @Override
      public Boolean apply(final EReference it) {
        String _name = it.getName();
        return Boolean.valueOf(Objects.equal(_name, "dsl"));
      }
    };
    final EReference dslRef = IterableExtensions.<EReference>findFirst(lang.eClass().getEReferences(), _function);
    final List<INode> node = NodeModelUtils.findNodesForFeature(lang, dslRef);
    return this._iQualifiedNameConverter.toQualifiedName(IterableExtensions.<INode>head(node).getText());
  }
}
