/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd;

import org.aspectj.org.eclipse.jdt.internal.core.nd.AbstractTypeFactory;
import org.aspectj.org.eclipse.jdt.internal.core.nd.ITypeFactory;
import org.aspectj.org.eclipse.jdt.internal.core.nd.Nd;
import org.aspectj.org.eclipse.jdt.internal.core.nd.NdNode;

public class Pointer<T> {
    private final Nd nd;
    private final long address;
    private ITypeFactory<T> targetFactory;

    public Pointer(Nd nd, long address, ITypeFactory<T> targetFactory) {
        this.nd = nd;
        this.address = address;
        this.targetFactory = targetFactory;
    }

    public T get() {
        long ptr = this.nd.getDB().getRecPtr(this.address);
        if (ptr == 0L) {
            return null;
        }
        return this.targetFactory.create(this.nd, ptr);
    }

    public static <T> ITypeFactory<Pointer<T>> getFactory(final ITypeFactory<T> targetFactory) {
        if (NdNode.class.isAssignableFrom(targetFactory.getElementClass())) {
            throw new IllegalArgumentException("Don't use Pointer<T> for references to NdNode");
        }
        return new AbstractTypeFactory<Pointer<T>>(){

            @Override
            public Pointer<T> create(Nd dom, long address) {
                return new Pointer(dom, address, targetFactory);
            }

            @Override
            public int getRecordSize() {
                return 4;
            }

            @Override
            public Class<?> getElementClass() {
                return Pointer.class;
            }
        };
    }
}

