/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order.counting;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.properties.InternalProperties;
import org.eclipse.elk.alg.layered.properties.LayeredOptions;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.Pair;

public abstract class AbstractCrossingsCounter {
    private final int[] inLayerEdgeCount;
    private final boolean[] hasNorthSouthPorts;

    public AbstractCrossingsCounter(int[] inLayerEdgeCount, boolean[] hasNorthSouthPorts) {
        this.inLayerEdgeCount = inLayerEdgeCount;
        this.hasNorthSouthPorts = hasNorthSouthPorts;
    }

    public abstract int countCrossings(LNode[] var1, LNode[] var2);

    public final int countCrossings(LNode[] layer, int index) {
        int c = 0;
        if (this.inLayerEdgeCount[index] > 0) {
            c += this.countInLayerEdgeCrossings(layer);
        }
        if (this.hasNorthSouthPorts[index]) {
            c += this.countNorthSouthPortCrossings(layer);
        }
        return c;
    }

    private int countInLayerEdgeCrossings(LNode[] layer) {
        int eastWestCrossings = 0;
        int northSouthCrossings = 0;
        HashMap northSouthCrossingHints = Maps.newHashMap();
        HashMap dummyIndices = Maps.newHashMap();
        HashMap easternPortNumbers = Maps.newHashMap();
        HashMap westernPortNumbers = Maps.newHashMap();
        this.numberEastWestPorts(layer, easternPortNumbers, westernPortNumbers);
        LNode currentNormalNode = null;
        int northMaxCrossingHint = 0;
        int southMaxCrossingHint = 0;
        boolean northernSide = true;
        boolean layerLayoutUnitsSet = true;
        LNode[] lNodeArray = layer;
        int n = layer.length;
        int n2 = 0;
        while (n2 < n) {
            LNode node = lNodeArray[n2];
            for (LPort port : node.getPorts()) {
                switch (port.getSide()) {
                    case EAST: {
                        eastWestCrossings += this.countInLayerCrossings(port, easternPortNumbers);
                        break;
                    }
                    case WEST: {
                        eastWestCrossings += this.countInLayerCrossings(port, westernPortNumbers);
                    }
                }
            }
            LNode.NodeType nodeType = node.getType();
            if (layerLayoutUnitsSet && (nodeType == LNode.NodeType.NORMAL || nodeType == LNode.NodeType.NORTH_SOUTH_PORT)) {
                LNode newNormalNode = (LNode)((Object)node.getProperty(InternalProperties.IN_LAYER_LAYOUT_UNIT));
                if (newNormalNode == null) {
                    layerLayoutUnitsSet = false;
                } else {
                    if (currentNormalNode != newNormalNode) {
                        if (currentNormalNode != null) {
                            northSouthCrossingHints.put(currentNormalNode, new Pair((Object)northMaxCrossingHint, (Object)southMaxCrossingHint));
                        }
                        currentNormalNode = newNormalNode;
                        northMaxCrossingHint = 0;
                        southMaxCrossingHint = 0;
                        northernSide = true;
                    }
                    if (node == currentNormalNode) {
                        northernSide = false;
                    }
                    if (northernSide) {
                        dummyIndices.put(node, northMaxCrossingHint += ((Integer)node.getProperty(InternalProperties.CROSSING_HINT)).intValue());
                    } else {
                        dummyIndices.put(node, southMaxCrossingHint += ((Integer)node.getProperty(InternalProperties.CROSSING_HINT)).intValue());
                    }
                }
            }
            ++n2;
        }
        if (currentNormalNode != null) {
            northSouthCrossingHints.put(currentNormalNode, new Pair((Object)northMaxCrossingHint, (Object)southMaxCrossingHint));
        }
        if (layerLayoutUnitsSet) {
            LNode lastDummyNormalNode = null;
            int lastDummyIndex = 0;
            int dummyCount = 0;
            northernSide = true;
            LNode[] lNodeArray2 = layer;
            int n3 = layer.length;
            int n4 = 0;
            while (n4 < n3) {
                LNode node = lNodeArray2[n4];
                LNode.NodeType nodeType = node.getType();
                switch (nodeType) {
                    case NORMAL: {
                        lastDummyIndex = (Integer)dummyIndices.get((Object)node);
                        dummyCount = (Integer)((Pair)northSouthCrossingHints.get((Object)node)).getSecond();
                        lastDummyNormalNode = node;
                        northernSide = false;
                        break;
                    }
                    case NORTH_SOUTH_PORT: {
                        lastDummyIndex = (Integer)dummyIndices.get((Object)node);
                        LNode newNormalNode = (LNode)((Object)node.getProperty(InternalProperties.IN_LAYER_LAYOUT_UNIT));
                        if (newNormalNode == lastDummyNormalNode) break;
                        dummyCount = (Integer)((Pair)northSouthCrossingHints.get((Object)newNormalNode)).getFirst();
                        lastDummyNormalNode = newNormalNode;
                        northernSide = true;
                        break;
                    }
                    default: {
                        northSouthCrossings += northernSide ? lastDummyIndex : dummyCount - lastDummyIndex;
                    }
                }
                ++n4;
            }
        }
        return eastWestCrossings + northSouthCrossings;
    }

    private void numberEastWestPorts(LNode[] layer, Map<LPort, Integer> easternMap, Map<LPort, Integer> westernMap) {
        LNode node;
        int currentEasternNumber = 0;
        int currentWesternNumber = 0;
        int nodeIndex = 0;
        while (nodeIndex < layer.length) {
            node = layer[nodeIndex];
            if (((PortConstraints)node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
                for (LPort easternPort : node.getPorts(PortSide.EAST)) {
                    if (easternPort.getDegree() <= 0) continue;
                    easternMap.put(easternPort, currentEasternNumber += easternPort.getDegree());
                }
            } else {
                for (LPort easternPort : node.getPorts(PortSide.EAST)) {
                    currentEasternNumber += easternPort.getDegree();
                }
                for (LPort easternPort : node.getPorts(PortSide.EAST)) {
                    if (easternPort.getDegree() <= 0) continue;
                    easternMap.put(easternPort, currentEasternNumber);
                }
            }
            ++nodeIndex;
        }
        nodeIndex = layer.length - 1;
        while (nodeIndex >= 0) {
            node = layer[nodeIndex];
            if (((PortConstraints)node.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
                for (LPort westernPort : node.getPorts(PortSide.WEST)) {
                    if (westernPort.getDegree() <= 0) continue;
                    westernMap.put(westernPort, currentWesternNumber += westernPort.getDegree());
                }
            } else {
                for (LPort westernPort : node.getPorts(PortSide.WEST)) {
                    currentWesternNumber += westernPort.getDegree();
                }
                for (LPort westernPort : node.getPorts(PortSide.WEST)) {
                    if (westernPort.getDegree() <= 0) continue;
                    westernMap.put(westernPort, currentWesternNumber);
                }
            }
            --nodeIndex;
        }
    }

    private int countInLayerCrossings(LPort port, Map<LPort, Integer> portIndices) {
        int maxCrossings = 0;
        Integer portIndex = portIndices.get((Object)port);
        if (portIndex == null) {
            return 0;
        }
        Integer connectedPortIndex = null;
        for (LEdge edge : port.getConnectedEdges()) {
            connectedPortIndex = edge.getSource() == port ? portIndices.get((Object)edge.getTarget()) : portIndices.get((Object)edge.getSource());
            if (connectedPortIndex == null || portIndex <= connectedPortIndex) continue;
            maxCrossings = Math.max(maxCrossings, portIndex - connectedPortIndex - 1);
        }
        return maxCrossings;
    }

    private int countNorthSouthPortCrossings(LNode[] layer) {
        int crossings = 0;
        boolean northernSide = true;
        LNode recentNormalNode = null;
        int i = 0;
        while (i < layer.length) {
            LNode node = layer[i];
            LNode.NodeType nodeType = node.getType();
            if (nodeType == LNode.NodeType.NORMAL) {
                recentNormalNode = node;
                northernSide = false;
            } else if (nodeType == LNode.NodeType.NORTH_SOUTH_PORT && !(node.getProperty(InternalProperties.ORIGIN) instanceof LEdge)) {
                LNode currentNormalNode = (LNode)((Object)node.getProperty(InternalProperties.ORIGIN));
                if (recentNormalNode != currentNormalNode) {
                    recentNormalNode = currentNormalNode;
                    northernSide = true;
                }
                if (((PortConstraints)currentNormalNode.getProperty(LayeredOptions.PORT_CONSTRAINTS)).isOrderFixed()) {
                    LPort nodeInputPort = null;
                    LPort nodeOutputPort = null;
                    for (LPort port : node.getPorts()) {
                        assert (port.getIncomingEdges().isEmpty() ^ port.getOutgoingEdges().isEmpty()) : String.valueOf(port.getIncomingEdges().size()) + " incoming edges, " + port.getOutgoingEdges().size() + " outgoing edges";
                        if (!port.getIncomingEdges().isEmpty()) {
                            nodeInputPort = (LPort)((Object)port.getProperty(InternalProperties.ORIGIN));
                            continue;
                        }
                        if (port.getOutgoingEdges().isEmpty()) continue;
                        nodeOutputPort = (LPort)((Object)port.getProperty(InternalProperties.ORIGIN));
                    }
                    int j = i + 1;
                    while (j < layer.length) {
                        LNode node2 = layer[j];
                        LNode.NodeType node2Type = node2.getType();
                        if (node2Type == LNode.NodeType.NORMAL) break;
                        if (node2Type == LNode.NodeType.NORTH_SOUTH_PORT) {
                            if (node2.getProperty(InternalProperties.ORIGIN) != currentNormalNode) break;
                            LPort node2InputPort = null;
                            LPort node2OutputPort = null;
                            for (LPort port2 : node2.getPorts()) {
                                if (!port2.getIncomingEdges().isEmpty()) {
                                    node2InputPort = (LPort)((Object)port2.getProperty(InternalProperties.ORIGIN));
                                    continue;
                                }
                                if (port2.getOutgoingEdges().isEmpty()) continue;
                                node2OutputPort = (LPort)((Object)port2.getProperty(InternalProperties.ORIGIN));
                            }
                            if (northernSide) {
                                boolean nodeInputPortCollision = false;
                                boolean nodeOutputPortCollision = false;
                                if (nodeOutputPort != null && node2InputPort != null && nodeOutputPort.id < node2InputPort.id) {
                                    ++crossings;
                                    nodeOutputPortCollision = true;
                                }
                                if (nodeInputPort != null && node2OutputPort != null && nodeInputPort.id > node2OutputPort.id) {
                                    ++crossings;
                                    nodeInputPortCollision = true;
                                }
                                if (nodeOutputPort != null && node2OutputPort != null && nodeOutputPort.id > node2OutputPort.id) {
                                    ++crossings;
                                    nodeOutputPortCollision = true;
                                }
                                if (nodeInputPort != null && node2InputPort != null && nodeInputPort.id < node2InputPort.id) {
                                    ++crossings;
                                    nodeInputPortCollision = true;
                                }
                                if (nodeInputPortCollision && nodeOutputPortCollision && nodeInputPort == nodeOutputPort) {
                                    --crossings;
                                }
                            } else {
                                boolean node2InputPortCollision = false;
                                boolean node2OutputPortCollision = false;
                                if (nodeInputPort != null && node2OutputPort != null && nodeInputPort.id < node2OutputPort.id) {
                                    ++crossings;
                                    node2OutputPortCollision = true;
                                }
                                if (nodeOutputPort != null && node2InputPort != null && nodeOutputPort.id > node2InputPort.id) {
                                    ++crossings;
                                    node2InputPortCollision = true;
                                }
                                if (nodeInputPort != null && node2InputPort != null && nodeInputPort.id < node2InputPort.id) {
                                    ++crossings;
                                    node2InputPortCollision = true;
                                }
                                if (nodeOutputPort != null && node2OutputPort != null && nodeOutputPort.id > node2OutputPort.id) {
                                    ++crossings;
                                    node2OutputPortCollision = true;
                                }
                                if (node2InputPortCollision && node2OutputPortCollision && node2InputPort == node2OutputPort) {
                                    --crossings;
                                }
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return crossings;
    }
}

