/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.impl.policies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.diffmerge.EMFDiffMergePlugin;
import org.eclipse.emf.diffmerge.Messages;
import org.eclipse.emf.diffmerge.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.api.config.IConfigurablePolicy;
import org.eclipse.emf.diffmerge.api.scopes.IFeaturedModelScope;
import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.diffmerge.impl.policies.AbstractConfigurationElement;
import org.eclipse.emf.diffmerge.impl.policies.CachingMatchPolicy;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.IItemLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableMatchPolicy
extends CachingMatchPolicy
implements IConfigurablePolicy {
    public static final FineGrainedMatchCriterion CRITERION_QNAMES_LABELS = new FineGrainedMatchCriterion(MatchCriterionKind.NAME, Messages.ConfigurableMatchPolicy_Criterion_QNames_Labels, Messages.ConfigurableMatchPolicy_Criterion_QNames_Labels_Tooltip);
    public static final FineGrainedMatchCriterion CRITERION_STRUCTURE_ROOTS = new FineGrainedMatchCriterion(MatchCriterionKind.STRUCTURE, Messages.ConfigurableMatchPolicy_Criterion_Structure_Roots, Messages.ConfigurableMatchPolicy_Criterion_Structure_Roots_Tooltip);
    public static final FineGrainedMatchCriterion CRITERION_STRUCTURE_UNIQUECHILDREN = new FineGrainedMatchCriterion(MatchCriterionKind.STRUCTURE, Messages.ConfigurableMatchPolicy_Criterion_Structure_UniqueChildren, Messages.ConfigurableMatchPolicy_Criterion_Structure_UniqueChildren_Tooltip);
    public static final FineGrainedMatchCriterion CRITERION_STRUCTURE_CONTAINMENTS = new FineGrainedMatchCriterion(MatchCriterionKind.STRUCTURE, Messages.ConfigurableMatchPolicy_Criterion_Structure_UnambiguousChildren, Messages.ConfigurableMatchPolicy_Criterion_Structure_UnambiguousChildren_Tooltip);
    public static final FineGrainedMatchCriterion CRITERION_SEMANTICS_DEFAULTCONTENTS = new FineGrainedMatchCriterion(MatchCriterionKind.SEMANTICS, Messages.ConfigurableMatchPolicy_Criterion_Semantics_DefaultContents, Messages.ConfigurableMatchPolicy_Criterion_Semantics_DefaultContents_Tooltip);
    public static final Object PROPERTY_MATCH_CRITERIA = new Object();
    public static final Object PROPERTY_FINE_GRAINED_MATCH_CRITERIA = new Object();
    private boolean _useCache = false;
    private final Set<MatchCriterionKind> _selectedCriteria = new HashSet<MatchCriterionKind>(MatchCriterionKind.values().length);
    private final Set<FineGrainedMatchCriterion> _selectedFineGrainedCriteria;
    protected final Set<IConfigurablePolicy.IConfigurationChangedListener> _listeners;

    public ConfigurableMatchPolicy() {
        this._selectedCriteria.addAll(this.getDefaultCriteria());
        this._selectedFineGrainedCriteria = new HashSet<FineGrainedMatchCriterion>();
        this._listeners = new LinkedHashSet<IConfigurablePolicy.IConfigurationChangedListener>();
    }

    public ConfigurableMatchPolicy(ConfigurableMatchPolicy policy_p) {
        this();
        this.update(policy_p);
    }

    @Override
    public void addConfigurationChangedListener(IConfigurablePolicy.IConfigurationChangedListener listener_p) {
        this._listeners.add(listener_p);
    }

    public ConfigurableMatchPolicy clone() throws CloneNotSupportedException {
        return new ConfigurableMatchPolicy(this);
    }

    protected void fireConfigurationChanged(Object property_p) {
        for (IConfigurablePolicy.IConfigurationChangedListener listener : this._listeners) {
            listener.configurationChanged(this, property_p);
        }
    }

    public Collection<FineGrainedMatchCriterion> getAllUsedFineGrainedCriteria() {
        return Collections.unmodifiableCollection(this._selectedFineGrainedCriteria);
    }

    public Collection<MatchCriterionKind> getAllUsedCriteria() {
        return Collections.unmodifiableCollection(this._selectedCriteria);
    }

    public List<FineGrainedMatchCriterion> getAvailableFineGrainedCriteria() {
        ArrayList<FineGrainedMatchCriterion> result = new ArrayList<FineGrainedMatchCriterion>();
        result.add(CRITERION_QNAMES_LABELS);
        result.add(CRITERION_STRUCTURE_ROOTS);
        result.add(CRITERION_STRUCTURE_UNIQUECHILDREN);
        result.add(CRITERION_STRUCTURE_CONTAINMENTS);
        return result;
    }

    protected EObject getContainer(EObject element_p, IModelScope scope_p) {
        Object result = this.isScopeOnly() ? (scope_p instanceof IFeaturedModelScope ? ((IFeaturedModelScope)scope_p).getContainer(element_p) : null) : element_p.eContainer();
        return result;
    }

    protected String getContainerRelativeID(EObject element_p, IModelScope scope_p, String qualifier_p, String separator_p) {
        String result = null;
        EObject container = this.getContainer(element_p, scope_p);
        if (container != null) {
            String containerID = this.getMatchID(container, scope_p);
            if (containerID != null) {
                String separator = separator_p == null ? this.getQualificationSeparatorDefault() : separator_p;
                result = String.valueOf(containerID) + separator + qualifier_p;
            }
        } else {
            result = qualifier_p;
        }
        return result;
    }

    protected EReference getContainment(EObject element_p, IModelScope scope_p) {
        Object result = this.isScopeOnly() ? (scope_p instanceof IFeaturedModelScope ? ((IFeaturedModelScope)scope_p).getContainment(element_p) : null) : element_p.eContainmentFeature();
        return result;
    }

    public Collection<MatchCriterionKind> getDefaultCriteria() {
        return Arrays.asList(MatchCriterionKind.INTRINSIC_ID, MatchCriterionKind.EXTRINSIC_ID);
    }

    protected String getExtrinsicID(EObject element_p, IModelScope scope_p) {
        String result = null;
        Comparable<?> superID = super.getExtrinsicID(element_p, scope_p);
        if (superID instanceof String) {
            result = (String)((Object)superID);
        }
        return result;
    }

    protected String getLabel(EObject element_p, IModelScope scope_p) {
        String result = null;
        AdapterFactory adapterFactory = EMFDiffMergePlugin.getDefault().getAdapterFactory();
        Adapter adapter = adapterFactory.adapt((Notifier)element_p, IItemLabelProvider.class);
        if (adapter instanceof IItemLabelProvider) {
            result = ((IItemLabelProvider)adapter).getText((Object)element_p);
        }
        return result;
    }

    @Override
    public String getMatchID(EObject element_p, IModelScope scope_p) {
        return (String)super.getMatchID(element_p, scope_p);
    }

    protected String getMatchID(EObject element_p, IModelScope scope_p, MatchCriterionKind criterion_p) {
        String result;
        switch (criterion_p) {
            case EXTRINSIC_ID: {
                result = this.getExtrinsicID(element_p, scope_p);
                break;
            }
            case INTRINSIC_ID: {
                result = this.getIntrinsicID(element_p);
                break;
            }
            case NAME: {
                result = this.getQualifiedName(element_p, scope_p);
                break;
            }
            case STRUCTURE: {
                result = this.getStructureBasedID(element_p, scope_p);
                break;
            }
            default: {
                result = this.getSemanticID(element_p, scope_p);
            }
        }
        return result;
    }

    protected String getName(EObject element_p, IModelScope scope_p) {
        String result = null;
        if (element_p instanceof ENamedElement) {
            result = ((ENamedElement)element_p).getName();
        }
        return result;
    }

    protected String getQualificationSeparatorDefault() {
        return this.getQualificationSeparatorSemantics();
    }

    protected String getQualificationSeparatorNames() {
        return "::";
    }

    protected String getQualificationSeparatorSemantics() {
        return "~";
    }

    protected String getQualificationSeparatorStructure() {
        return "@";
    }

    protected String getQualifiedName(EObject element_p, IModelScope scope_p) {
        String result = null;
        String name = this.getUnqualifiedName(element_p, scope_p);
        if (this.isSignificant(name)) {
            result = this.getContainerRelativeID(element_p, scope_p, name, this.getQualificationSeparatorNames());
        }
        return result;
    }

    protected String getSemanticID(EObject element_p, IModelScope scope_p) {
        return null;
    }

    protected List<EObject> getSiblings(EObject element_p, IModelScope scope_p) {
        Object result;
        EReference containment = this.getContainment(element_p, scope_p);
        if (containment == null) {
            Resource resource = element_p.eResource();
            result = this.isScopeOnly() || resource == null ? scope_p.getContents() : resource.getContents();
        } else if (scope_p instanceof IFeaturedModelScope) {
            EObject container = this.getContainer(element_p, scope_p);
            result = ((IFeaturedModelScope)scope_p).get(container, containment);
        } else {
            result = Collections.emptyList();
        }
        return Collections.unmodifiableList(result);
    }

    protected Object getStructuralType(EObject element_p, IModelScope scope_p) {
        return element_p.eClass();
    }

    protected String getStructuralTypeQualifier(EObject element_p, IModelScope scope_p) {
        Object type = this.getStructuralType(element_p, scope_p);
        String result = type instanceof EClass ? ((EClass)type).getName() : type.toString();
        return result;
    }

    protected String getStructureBasedContainmentID(EObject element_p, IModelScope scope_p, boolean checkContainment_p) {
        String result = null;
        String lastIDPart = this.getStructureBasedContainmentQualifier(element_p, scope_p, checkContainment_p);
        if (this.isSignificant(lastIDPart)) {
            result = this.getContainerRelativeID(element_p, scope_p, lastIDPart, this.getQualificationSeparatorStructure());
        }
        return result;
    }

    protected String getStructureBasedContainmentQualifier(EObject element_p, IModelScope scope_p, boolean checkContainment_p) {
        String result = null;
        EReference containment = this.getContainment(element_p, scope_p);
        if (containment != null && (!checkContainment_p || this.isDiscriminatingContainment(element_p, containment)) && this.isUniqueSiblingOfItsType(element_p, scope_p)) {
            result = String.valueOf(containment.getName()) + '[' + this.getStructuralTypeQualifier(element_p, scope_p) + ']';
        }
        return result;
    }

    protected String getStructureBasedID(EObject element_p, IModelScope scope_p) {
        String result = null;
        EReference containment = this.getContainment(element_p, scope_p);
        if (containment == null && this.useFineGrainedCriterion(CRITERION_STRUCTURE_ROOTS)) {
            result = this.getStructureBasedRootQualifier(element_p, scope_p);
        } else if (containment != null && (this.useFineGrainedCriterion(CRITERION_STRUCTURE_CONTAINMENTS) || this.useFineGrainedCriterion(CRITERION_STRUCTURE_UNIQUECHILDREN))) {
            result = this.getStructureBasedContainmentID(element_p, scope_p, !this.useFineGrainedCriterion(CRITERION_STRUCTURE_CONTAINMENTS));
        }
        return result;
    }

    protected String getStructureBasedRootQualifier(EObject element_p, IModelScope scope_p) {
        String result = null;
        if (this.isUniqueSiblingOfItsType(element_p, scope_p)) {
            result = String.valueOf(this.getQualificationSeparatorStructure()) + this.getStructuralTypeQualifier(element_p, scope_p);
        }
        return result;
    }

    @Override
    protected String getUncachedMatchID(EObject element_p, IModelScope scope_p) {
        String result = null;
        MatchCriterionKind[] matchCriterionKindArray = MatchCriterionKind.values();
        int n = matchCriterionKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            MatchCriterionKind criterion = matchCriterionKindArray[n2];
            if (this.useCriterion(criterion) && (result = this.getMatchID(element_p, scope_p, criterion)) != null) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    protected String getUnqualifiedName(EObject element_p, IModelScope scope_p) {
        String result = this.useFineGrainedCriterion(CRITERION_QNAMES_LABELS) ? this.getLabel(element_p, scope_p) : this.getName(element_p, scope_p);
        return result;
    }

    public Collection<MatchCriterionKind> getVisibleCriteria() {
        return Arrays.asList(MatchCriterionKind.values());
    }

    protected boolean isDiscriminatingContainment(EObject element_p, EReference containment_p) {
        return !containment_p.isMany();
    }

    protected boolean isInDiscriminatingContainment(EObject element_p, IModelScope scope_p) {
        EReference containment = this.getContainment(element_p, scope_p);
        return containment != null && this.isDiscriminatingContainment(element_p, containment);
    }

    protected boolean isInstanceOf(EObject element_p, Collection<? extends EClass> types_p) {
        for (EClass eClass : types_p) {
            if (!eClass.isInstance((Object)element_p)) continue;
            return true;
        }
        return false;
    }

    protected boolean isScopeOnly() {
        return true;
    }

    protected boolean isSignificant(String string_p) {
        return string_p != null && string_p.length() > 0;
    }

    protected boolean isUniqueOfItsTypeAmong(EObject element_p, Collection<? extends EObject> collection_p, IModelScope scope_p) {
        Iterator<? extends EObject> it = collection_p.iterator();
        boolean result = false;
        Object type = this.getStructuralType(element_p, scope_p);
        if (type != null) {
            boolean isPresent = false;
            boolean sameType = false;
            while (it.hasNext() && !sameType) {
                EObject root = it.next();
                if (root == element_p) {
                    isPresent = true;
                    continue;
                }
                if (!type.equals(this.getStructuralType(root, scope_p))) continue;
                sameType = true;
            }
            result = isPresent && !sameType;
        }
        return result;
    }

    protected boolean isUniqueSiblingOfItsType(EObject element_p, IModelScope scope_p) {
        List<EObject> siblings = this.getSiblings(element_p, scope_p);
        return this.isUniqueOfItsTypeAmong(element_p, siblings, scope_p);
    }

    @Override
    public void removeConfigurationChangedListener(IConfigurablePolicy.IConfigurationChangedListener listener_p) {
        this._listeners.remove(listener_p);
    }

    public void setAllUsedFineGrainedCriteria(Collection<FineGrainedMatchCriterion> criteria_p) {
        this._selectedFineGrainedCriteria.clear();
        this._selectedFineGrainedCriteria.addAll(criteria_p);
        this.fireConfigurationChanged(PROPERTY_FINE_GRAINED_MATCH_CRITERIA);
    }

    public void setAllUsedCriteria(Collection<MatchCriterionKind> criteria_p) {
        this._selectedCriteria.clear();
        this._selectedCriteria.addAll(criteria_p);
        this.fireConfigurationChanged(PROPERTY_MATCH_CRITERIA);
    }

    @Override
    public void setKeepMatchIDs(boolean keep_p) {
        super.setKeepMatchIDs(keep_p);
        this.fireConfigurationChanged(null);
    }

    public void setUseCache(boolean useCache_p) {
        this._useCache = useCache_p;
        this.fireConfigurationChanged(null);
    }

    public void setUseFineGrainedCriterion(FineGrainedMatchCriterion criterion_p, boolean use_p) {
        if (use_p) {
            this._selectedFineGrainedCriteria.add(criterion_p);
        } else {
            this._selectedFineGrainedCriteria.remove(criterion_p);
        }
        this.fireConfigurationChanged(criterion_p);
    }

    public void setUseCriterion(MatchCriterionKind criterion_p, boolean use_p) {
        if (use_p) {
            this._selectedCriteria.add(criterion_p);
        } else {
            this._selectedCriteria.remove((Object)criterion_p);
        }
        this.fireConfigurationChanged((Object)criterion_p);
    }

    @Override
    public boolean update(IConfigurablePolicy policy_p) {
        boolean result = false;
        if (policy_p instanceof IMatchPolicy) {
            this.setKeepMatchIDs(((IMatchPolicy)((Object)policy_p)).keepMatchIDs());
            if (policy_p instanceof ConfigurableMatchPolicy) {
                ConfigurableMatchPolicy policy = (ConfigurableMatchPolicy)policy_p;
                this.setUseCache(policy.useCache());
                this.setAllUsedCriteria(policy.getAllUsedCriteria());
                this.setAllUsedFineGrainedCriteria(policy.getAllUsedFineGrainedCriteria());
                result = true;
            }
        }
        return result;
    }

    @Override
    public boolean useCache() {
        return this._useCache;
    }

    public boolean useFineGrainedCriterion(FineGrainedMatchCriterion criterion_p) {
        return this._selectedFineGrainedCriteria.contains(criterion_p);
    }

    public boolean useCriterion(MatchCriterionKind criterion_p) {
        return this._selectedCriteria.contains((Object)criterion_p);
    }

    public static class FineGrainedMatchCriterion
    extends AbstractConfigurationElement {
        private final MatchCriterionKind _category;

        public FineGrainedMatchCriterion(MatchCriterionKind category_p, String label_p, String description_p) {
            super(label_p, description_p);
            this._category = category_p;
        }

        public MatchCriterionKind getParentCriterion() {
            return this._category;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MatchCriterionKind {
        SEMANTICS,
        STRUCTURE,
        NAME,
        INTRINSIC_ID,
        EXTRINSIC_ID;

    }
}

