/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.commons.eclipse.logging.backends;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gemoc.commons.eclipse.logging.ILoggingBackend;
import org.eclipse.gemoc.commons.eclipse.logging.ILoggingEntity;
import org.eclipse.gemoc.commons.eclipse.messagingsystem.api.MessagingSystem;
import org.eclipse.gemoc.commons.messagingsystem.api.impl.StdioSimpleMessagingSystem;

public class DefaultLoggingBackend
implements ILoggingBackend {
    private ILoggingEntity _loggingEntity;
    private MessagingSystem _messagingSystem;

    public DefaultLoggingBackend(ILoggingEntity plugin) {
        this._loggingEntity = plugin;
    }

    private MessagingSystem getMessagingSystem() {
        if (this._messagingSystem == null) {
            this._messagingSystem = new StdioSimpleMessagingSystem();
        }
        return this._messagingSystem;
    }

    public void setMessagingSystem(MessagingSystem messagingSystem) {
        this._messagingSystem = messagingSystem;
    }

    @Override
    public void info(String message) {
        this.getMessagingSystem().info(message, this._loggingEntity.getId());
    }

    @Override
    public void debug(String message) {
        this.getMessagingSystem().debug(message, this._loggingEntity.getId());
    }

    @Override
    public void warn(String message) {
        this.getMessagingSystem().warn(message, this._loggingEntity.getId());
    }

    @Override
    public void error(String message) {
        this.getMessagingSystem().error(message, this._loggingEntity.getId());
    }

    @Override
    public void warn(String message, Throwable e) {
        this.warn(message);
        this._loggingEntity.getLog().log((IStatus)new Status(2, this._loggingEntity.getId(), 0, message, e));
    }

    @Override
    public void error(String message, Throwable e) {
        this.error(message);
        this._loggingEntity.getLog().log((IStatus)new Status(4, this._loggingEntity.getId(), 0, message, e));
    }

    @Override
    public void info(String message, Throwable e) {
        this.info(message);
        this._loggingEntity.getLog().log((IStatus)new Status(1, this._loggingEntity.getId(), 0, message, e));
    }
}

