/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.api.figure;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;

public class PolygoneAndPolylineDecoraction
extends PolygonDecoration {
    public static final PointList TRIANGLE_TIP = new PointList();
    PolylineDecoration polylineDecoration = new PolylineDecoration();

    static {
        TRIANGLE_TIP.addPoint(-3, 1);
        TRIANGLE_TIP.addPoint(-2, 0);
        TRIANGLE_TIP.addPoint(-3, -1);
    }

    public PolygoneAndPolylineDecoraction() {
        this.polylineDecoration.setTemplate(TRIANGLE_TIP);
    }

    public void setPolylineTemplate(PointList pl) {
        this.polylineDecoration.setTemplate(pl);
    }

    protected void outlineShape(Graphics g) {
        super.outlineShape(g);
        g.drawPolyline(this.polylineDecoration.getPoints());
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            this.bounds = this.polylineDecoration != null ? this.getPoints().getBounds().getUnion(this.polylineDecoration.getPoints().getBounds()).getExpanded(this.getLineWidth() / 2, this.getLineWidth() / 2) : super.getBounds();
        }
        return this.bounds;
    }

    public void setRotation(double angle) {
        super.setRotation(angle);
        this.polylineDecoration.setRotation(angle);
    }

    public void setScale(double x, double y) {
        super.setScale(x, y);
        if (this.polylineDecoration != null) {
            this.polylineDecoration.setScale(x, y);
        }
    }

    public void setBackgroundColor(Color bg) {
        super.setBackgroundColor(bg);
        this.polylineDecoration.setBackgroundColor(bg);
    }

    public void setForegroundColor(Color fg) {
        super.setForegroundColor(fg);
        this.polylineDecoration.setForegroundColor(fg);
    }

    public void setLineWidth(int w) {
        super.setLineWidth(w);
        this.polylineDecoration.setLineWidth(w);
    }

    public void setLocation(Point p) {
        super.setLocation(p);
        this.polylineDecoration.setLocation(p);
    }
}

