/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.description.tool.spec;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.Messages;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.LayerHelper;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.DragAndDropTargetDescription;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.tool.impl.ContainerDropDescriptionImpl;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class ContainerDropDescriptionSpec
extends ContainerDropDescriptionImpl {
    @Override
    public DiagramElementMapping getBestMapping(DragAndDropTarget targetContainer, EObject droppedElement) {
        DDiagram diagram;
        LinkedList<ContainerMapping> allMappings;
        DiagramElementMapping bestMapping = null;
        Iterator iterCandidates = null;
        if (targetContainer instanceof DDiagram) {
            Session session;
            DDiagram diagram2 = (DDiagram)targetContainer;
            DiagramDescription desc = diagram2.getDescription();
            Collection<Object> selectedViewpoints = Collections.emptyList();
            if (diagram2 instanceof DSemanticDiagram && (session = SessionManager.INSTANCE.getSession(((DSemanticDiagram)diagram2).getTarget())) != null) {
                selectedViewpoints = session.getSelectedViewpoints(false);
            }
            allMappings = new LinkedList<ContainerMapping>((Collection<ContainerMapping>)new DiagramComponentizationManager().getAllContainerMappings(selectedViewpoints, desc));
            allMappings.addAll(this.getAllMappingsWithSuperMappings(selectedViewpoints, desc));
            allMappings.addAll((Collection<ContainerMapping>)new DiagramComponentizationManager().getAllEdgeMappings(selectedViewpoints, desc));
            iterCandidates = allMappings.iterator();
        } else if (targetContainer instanceof DDiagramElementContainer) {
            DDiagramElementContainer elementContainer = (DDiagramElementContainer)targetContainer;
            RepresentationElementMapping mapping = elementContainer.getMapping();
            if (mapping instanceof ContainerMapping) {
                ContainerMapping containerMapping = (ContainerMapping)mapping;
                allMappings = new LinkedList<ContainerMapping>((Collection<ContainerMapping>)containerMapping.getAllContainerMappings());
                allMappings.addAll(this.getAllMappingsWithSuperMappings(containerMapping));
                allMappings.addAll((Collection<ContainerMapping>)containerMapping.getAllBorderedNodeMappings());
                diagram = elementContainer.getParentDiagram();
                DiagramDescription desc = diagram.getDescription();
                allMappings.addAll((Collection<ContainerMapping>)desc.getAllEdgeMappings());
                iterCandidates = allMappings.iterator();
            }
        } else if (targetContainer instanceof DNode) {
            DNode viewNode = (DNode)targetContainer;
            NodeMapping nodeMapping = viewNode.getActualMapping();
            LinkedList<NodeMapping> allMappings2 = new LinkedList<NodeMapping>((Collection<NodeMapping>)nodeMapping.getAllBorderedNodeMappings());
            iterCandidates = allMappings2.iterator();
        }
        if (iterCandidates == null) {
            SiriusPlugin.getDefault().error(MessageFormat.format(Messages.ContainerDropDescriptionSpec_unknownTgtMsg, targetContainer), (Throwable)new RuntimeException());
            return null;
        }
        Session session = SessionManager.INSTANCE.getSession(droppedElement);
        ModelAccessor extendedPackage = session.getModelAccessor();
        while (iterCandidates.hasNext()) {
            DiagramMappingsManager mappingManager;
            DiagramElementMapping currentMapping = (DiagramElementMapping)iterCandidates.next();
            String domainClass = ContainerDropDescriptionSpec.getDomainClass(currentMapping);
            if (!this.getMappings().contains((Object)currentMapping) || domainClass == null || StringUtil.isEmpty((String)domainClass.trim()) || !extendedPackage.eInstanceOf(droppedElement, domainClass) || (diagram = ContainerDropDescriptionSpec.getDiagram(targetContainer)) == null || !LayerHelper.isInActivatedLayer(mappingManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(session, diagram), diagram, currentMapping)) continue;
            bestMapping = currentMapping;
            break;
        }
        return bestMapping;
    }

    @Override
    public EList<DragAndDropTargetDescription> getContainers() {
        Resource r = this.eResource();
        if (r == null) {
            throw new UnsupportedOperationException();
        }
        ECrossReferenceAdapter crossReferencer = ECrossReferenceAdapter.getCrossReferenceAdapter((Notifier)r);
        if (crossReferencer == null) {
            throw new UnsupportedOperationException();
        }
        LinkedList<DragAndDropTargetDescription> dndTargetDescriptions = new LinkedList<DragAndDropTargetDescription>();
        Collection settings = crossReferencer.getInverseReferences((EObject)this, true);
        for (EStructuralFeature.Setting setting : settings) {
            EObject eReferencer = setting.getEObject();
            EStructuralFeature eFeature = setting.getEStructuralFeature();
            if (!(eReferencer instanceof DragAndDropTargetDescription) || !eFeature.equals(DescriptionPackage.eINSTANCE.getDragAndDropTargetDescription_DropDescriptions())) continue;
            dndTargetDescriptions.add((DragAndDropTargetDescription)eReferencer);
        }
        return new BasicEList(dndTargetDescriptions);
    }

    private static DDiagram getDiagram(DragAndDropTarget target) {
        DDiagram diagram = null;
        if (target instanceof DDiagramElement) {
            diagram = ((DDiagramElement)((Object)target)).getParentDiagram();
        } else if (target instanceof DDiagram) {
            diagram = (DDiagram)target;
        }
        return diagram;
    }

    private Collection<DiagramElementMapping> getAllMappingsWithSuperMappings(ContainerMapping containerMapping) {
        ArrayList<DiagramElementMapping> result = new ArrayList<DiagramElementMapping>();
        for (NodeMapping nM : containerMapping.getAllNodeMappings()) {
            result.add(nM);
        }
        return result;
    }

    private Collection<DiagramElementMapping> getAllMappingsWithSuperMappings(Collection<Viewpoint> selectedViewpoints, DiagramDescription desc) {
        ArrayList<DiagramElementMapping> result = new ArrayList<DiagramElementMapping>();
        for (NodeMapping nM : new DiagramComponentizationManager().getAllNodeMappings(selectedViewpoints, desc)) {
            result.add(nM);
        }
        return result;
    }

    private static String getDomainClass(DiagramElementMapping mapping) {
        String domainClass = null;
        if (mapping instanceof EdgeMapping) {
            EdgeMapping edgeMapping = (EdgeMapping)mapping;
            if (edgeMapping.isUseDomainElement()) {
                domainClass = edgeMapping.getDomainClass();
            }
        } else if (mapping instanceof AbstractNodeMapping) {
            domainClass = ((AbstractNodeMapping)mapping).getDomainClass();
        }
        return domainClass;
    }
}

