/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.parsers.impl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.exception.IncompleteTagException;
import org.eclipse.gendoc.tags.ITag;
import org.eclipse.gendoc.tags.parsers.ITagParserService;
import org.eclipse.gendoc.tags.parsers.impl.AbstractTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuredTag
extends AbstractTag {
    private Map<String, String> attributes;
    private String name;
    private String value;

    public StructuredTag(ITag parent, String text) throws IncompleteTagException {
        super(parent, text);
        this.initFields();
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public boolean isComplete() {
        return true;
    }

    public boolean isStructured() {
        return true;
    }

    @Override
    public void setValue(String newValue) {
        this.value = newValue;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("StructuredTag\n");
        buffer.append("{\n");
        buffer.append("\tname: " + this.name + "\n");
        buffer.append("\tattributes: \n");
        buffer.append("\t{\n");
        for (String k : this.getAttributes().keySet()) {
            buffer.append("\t\t" + k + ": " + this.getAttributes().get(k) + "\n");
        }
        buffer.append("\t}\n");
        buffer.append("\ttext: " + this.getRawText() + "\n");
        buffer.append("\tvalue: " + this.getValue() + "\n");
        buffer.append("}");
        return buffer.toString();
    }

    private int getWordEnd(int fromIndex, String text, String str) {
        int nextSpace = text.indexOf(32, fromIndex);
        int nextEqual = text.indexOf(str, fromIndex);
        int next = nextSpace != -1 && nextSpace < nextEqual ? nextSpace : nextEqual;
        return next;
    }

    private void initFields() throws IncompleteTagException {
        int iCloseTagStart;
        ITagParserService tagParserService = (ITagParserService)GendocServices.getDefault().getService(ITagParserService.class);
        int iCurrent = 0;
        this.attributes = new HashMap<String, String>();
        String text = this.getRawText();
        iCurrent = text.indexOf("&lt;", iCurrent);
        int iNameStart = iCurrent + "&lt;".length();
        int iNameEnd = this.getWordEnd(iNameStart, text, "&gt;");
        this.name = text.substring(iNameStart, iNameEnd);
        iCurrent = iNameEnd;
        tagParserService.increaseTagIndex(this.name);
        int iTagEnd = text.indexOf("&gt;", iNameEnd);
        boolean isSingleTag = text.startsWith("/", iTagEnd - "/".length());
        if (isSingleTag) {
            iTagEnd -= "/".length();
        }
        while (' ' == text.charAt(iCurrent)) {
            ++iCurrent;
        }
        while (iCurrent < iTagEnd && iCurrent < text.length()) {
            iNameEnd = this.getWordEnd(iCurrent + 1, text, "=");
            if (iNameEnd < 0) break;
            String attributeName = text.substring(iCurrent, iNameEnd);
            iCurrent = iNameEnd + 1;
            while (iCurrent < text.length() && "'".charAt(0) != text.charAt(iCurrent)) {
                ++iCurrent;
            }
            iNameEnd = text.indexOf("'".charAt(0), ++iCurrent + 1);
            if (iNameEnd == -1) {
                if (this.attributes.get("id") != null) {
                    throw new IncompleteTagException(this.name, this.attributes.get("id"), "attribute '" + attributeName + "' is not correctly filled.");
                }
                throw new IncompleteTagException(this.name, tagParserService.getTagIndex(this.name), "attribute '" + attributeName + "' is not correctly filled.");
            }
            String attributeValue = text.substring(iCurrent, iNameEnd);
            this.attributes.put(attributeName, attributeValue);
            iCurrent = iNameEnd + 1;
            while (' ' == text.charAt(iCurrent)) {
                ++iCurrent;
            }
        }
        this.value = isSingleTag ? "" : ((iCloseTagStart = text.lastIndexOf("&lt;/" + this.name + "&gt;", text.length())) > iCurrent ? text.substring(iCurrent += "&gt;".length(), iCloseTagStart) : "");
    }
}

