/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.documents.helper;

import org.w3c.dom.Node;

public final class XMLHelper {
    private XMLHelper() {
    }

    public static String getTagValueWithoutNamespace(Node n) {
        if (n != null) {
            String tag = n.getNodeName();
            return tag.substring(tag.indexOf(":") + 1, tag.length());
        }
        return null;
    }

    public static Node next(Node n) {
        if (n == null) {
            return null;
        }
        Node currentNode = n;
        if (currentNode.getChildNodes().getLength() > 0) {
            currentNode = currentNode.getFirstChild();
        } else if (currentNode.getNextSibling() != null) {
            currentNode = currentNode.getNextSibling();
        } else {
            Node oldCurrentNode = currentNode;
            currentNode = currentNode.getParentNode().getNextSibling();
            while (oldCurrentNode != null && currentNode == null) {
                if ((oldCurrentNode = oldCurrentNode.getParentNode()) == null) continue;
                currentNode = oldCurrentNode.getNextSibling();
            }
        }
        return currentNode;
    }

    public static Node getSibling(Node current) {
        Node sibling = current.getNextSibling();
        Node tmpParent = current;
        while (tmpParent != null && sibling == null) {
            if ((tmpParent = tmpParent.getParentNode()) == null) continue;
            sibling = tmpParent.getNextSibling();
        }
        return sibling;
    }

    public static boolean containsInHierarchy(Node node, String string) {
        Node parent = node;
        if (node != null) {
            while ((parent = parent.getParentNode()) != null && !parent.getNodeName().equals(string)) {
            }
        }
        return parent != null;
    }
}

