/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.services.docx;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.document.parser.documents.docx.DocxDocument;
import org.eclipse.gendoc.document.parser.documents.docx.DocxNamespaceContext;
import org.eclipse.gendoc.documents.IAdditionalResourceService;
import org.eclipse.gendoc.documents.IMimeHtmlService;
import org.eclipse.gendoc.documents.XMLDocumentService;
import org.eclipse.gendoc.services.docx.DOCXAdditionalResourceService;
import org.eclipse.gendoc.services.docx.DOCXMimeHtmlService;
import org.eclipse.gendoc.services.exception.DocumentServiceException;
import org.eclipse.gendoc.services.exception.InvalidContentException;
import org.eclipse.gendoc.tags.handlers.impl.RegisteredTags;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOCXDocumentService
extends XMLDocumentService {
    IAdditionalResourceService additionalResourceService = new DOCXAdditionalResourceService();
    IMimeHtmlService mimehtmlservice = new DOCXMimeHtmlService();
    private final String TAG_TABLE = "w:tbl";
    private String serviceId;
    protected static Pattern NOBR_REPLACE_PATTERN = Pattern.compile("(?:&lt;\\s*" + RegisteredTags.NOBR + "\\s*/\\s*&gt;)(?:.*?)(?:</w:t>)(?:.*?)(?:<w:t[^>]*>)", 40);

    public DOCXDocumentService() {
    }

    public DOCXDocumentService(Document document) {
        super(document);
    }

    public String getListLabel() {
        return null;
    }

    public boolean isList(String label) {
        return false;
    }

    public boolean isListItem(String label) {
        return false;
    }

    public boolean isPara(String label) {
        return "w:p".equals(label) || "w:bookmarkEnd".equals(label);
    }

    public boolean isTable(String label) {
        return "w:tbl".equals(label);
    }

    public boolean isRow(String label) {
        return "w:tr".equals(label);
    }

    public String getTextStyle() {
        return "w:t";
    }

    public String[] getTextTagLabels() {
        return new String[]{"w:p", "w:tbl"};
    }

    public String getNamingSpaceURL() {
        return "xmlns:w=\"http://schemas.openxmlformats.org/wordprocessingml/2006/main\" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\"";
    }

    public NamespaceContext getNameSpaceContext() {
        return new DocxNamespaceContext();
    }

    public void saveDocument(Document document, String path) throws DocumentServiceException {
        if (!(document instanceof DocxDocument)) {
            throw new DocumentServiceException("Document is not a valid DOCX document.");
        }
        this.insertDocumentInFile((DocxDocument)document);
        ((DocxDocument)document).zipToLocation(path);
    }

    public IAdditionalResourceService getAdditionalResourceService() {
        return this.additionalResourceService;
    }

    public IMimeHtmlService getMimeHtmlService() {
        return this.mimehtmlservice;
    }

    private void insertDocumentInFile(DocxDocument document) {
        try {
            document.jumpToStart();
            do {
                DOMSource domSource = new DOMSource(document.getXMLParser().getDocument());
                StreamResult fluxDestination = new StreamResult(new File(String.valueOf(document.getUnzipLocationDocumentFile().getAbsolutePath()) + "/word/" + document.getXMLParser().getXmlFile().getName()));
                TransformerFactory fabrique = TransformerFactory.newInstance();
                Transformer transformationIdentite = fabrique.newTransformer();
                transformationIdentite.setOutputProperty("encoding", "UTF-8");
                transformationIdentite.transform(domSource, fluxDestination);
            } while (document.jumpToNextFile());
        }
        catch (TransformerConfigurationException e1) {
            e1.printStackTrace();
        }
        catch (TransformerException e2) {
            e2.printStackTrace();
        }
    }

    protected Node cleanTags(Node currentNode, List<String> tagLabels, Node baseNode) throws InvalidContentException {
        String[] separated;
        if (baseNode == null) {
            return null;
        }
        StringBuffer newNodeContent = new StringBuffer(this.extractNodeTextValue(baseNode));
        while (baseNode != null && !this.containsOneOf(tagLabels, newNodeContent.toString())) {
            if ((baseNode = this.findNodeWithStartTag(baseNode, currentNode)) == null) continue;
            newNodeContent = new StringBuffer(this.extractNodeTextValue(baseNode));
        }
        if (baseNode == null) {
            return null;
        }
        boolean isCompleteTag = this.containsFullTags(newNodeContent.toString(), tagLabels);
        if (!isCompleteTag) {
            NodeList followingNodes = this.getNextNodes(baseNode, baseNode.getNodeName());
            ArrayList<Node> nodesToRemove = new ArrayList<Node>();
            if (followingNodes != null) {
                int i = 0;
                while (i < followingNodes.getLength()) {
                    String textValue = this.extractNodeTextValue(followingNodes.item(i));
                    newNodeContent.append(textValue);
                    Node nodeToRemove = this.getBestAscendantUntil(currentNode, followingNodes.item(i));
                    if (!nodesToRemove.contains(nodeToRemove)) {
                        nodesToRemove.add(nodeToRemove);
                    }
                    if (this.containsFullTags(newNodeContent.toString(), tagLabels)) {
                        isCompleteTag = true;
                        break;
                    }
                    ++i;
                }
                for (Node nodeToRemove : nodesToRemove) {
                    if (nodeToRemove == null || !currentNode.equals(nodeToRemove.getParentNode())) continue;
                    currentNode.removeChild(nodeToRemove);
                }
            }
        }
        if ((separated = this.asText(baseNode).split(String.valueOf(XML_TAG_START) + "|" + XML_TAG_END)) != null && separated.length > 1) {
            newNodeContent.insert(0, String.valueOf(XML_TAG_START) + separated[1] + XML_TAG_END);
            newNodeContent.append(String.valueOf(XML_TAG_START) + separated[separated.length - 1] + XML_TAG_END);
        } else {
            newNodeContent.append(this.asText(baseNode));
        }
        String nodeContent = this.cleanXMLContent(newNodeContent.toString());
        Node result = this.injectNode(baseNode, nodeContent);
        baseNode.getParentNode().removeChild(baseNode);
        return result;
    }

    protected boolean areSimilarTags(String tagName1, String tagName2) {
        return false;
    }

    protected String containsSimilarTag(Stack<String> tagStack, String tagName) {
        return null;
    }

    public String getTableLabel() {
        return "w:tbl";
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public Pattern getNobrReplacePattern() {
        return NOBR_REPLACE_PATTERN;
    }

    public String getListId(Node n) {
        return null;
    }

    public String getContinueList(Node currentNode, String idList) throws InvalidContentException {
        return null;
    }

    public String format(String input) {
        String LINE_BREAK = "</w:t><w:br/><w:t>";
        String TAB = "</w:t><w:tab/><w:t>";
        String formatted = input.replace("&#xD;\n", LINE_BREAK).replace("\r\n", LINE_BREAK).replace("&#xD;", LINE_BREAK).replace("\r", LINE_BREAK).replace("&#xA;", LINE_BREAK).replace("\n", LINE_BREAK).replace("&#x9;", TAB).replace("\t", TAB);
        return formatted;
    }
}

