/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.tags.handlers.process;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.process.AbstractProcess;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.tags.handlers.IConfigurationService;

public class RegisterVariableProcess
extends AbstractProcess {
    protected void doRun() throws GenDocException {
        IDocumentService docService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
        if (docService != null) {
            try {
                URI documentURI = docService.getDocument().getDocumentURL().toURI();
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                URI workspaceURI = root.getLocationURI();
                URI relative = workspaceURI.relativize(documentURI);
                IFile file = root.getFile((IPath)new Path(relative.toString()));
                IConfigurationService configService = (IConfigurationService)GendocServices.getDefault().getService(IConfigurationService.class);
                IPathVariableManager manager = file.getPathVariableManager();
                String[] keys = manager.getPathVariableNames();
                if (keys != null) {
                    String[] stringArray = keys;
                    int n = keys.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        URI resolveURI = manager.resolveURI(manager.getURIValue(s));
                        configService.addParameter(s, resolveURI.getPath());
                        ++n2;
                    }
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    protected int getTotalWork() {
        return 1;
    }
}

