/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.services.odt;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.document.parser.documents.odt.ODTDocument;
import org.eclipse.gendoc.document.parser.documents.odt.ODTNamespaceContext;
import org.eclipse.gendoc.documents.IAdditionalResourceService;
import org.eclipse.gendoc.documents.XMLDocumentService;
import org.eclipse.gendoc.services.exception.DocumentServiceException;
import org.eclipse.gendoc.services.exception.InvalidContentException;
import org.eclipse.gendoc.services.odt.ODTAdditionalResourceService;
import org.eclipse.gendoc.tags.handlers.impl.RegisteredTags;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODTDocumentService
extends XMLDocumentService
implements IExecutableExtension {
    private static final String XMLNS_OFFICE = "xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\"";
    private static final String XMLNS_TABLE = "xmlns:table=\"urn:oasis:names:tc:opendocument:xmlns:table:1.0\"";
    private static final String XMLNS_TEXT = "xmlns:text=\"urn:oasis:names:tc:opendocument:xmlns:text:1.0\"";
    private static final String XMLNS_FO = "xmlns:fo=\"urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0\"";
    private static final String XMLNS_STYLE = "xmlns:style=\"urn:oasis:names:tc:opendocument:xmlns:style:1.0\"";
    IAdditionalResourceService additionalResourceService = new ODTAdditionalResourceService();
    private final String TAG_TABLE = "table:table";
    private String serviceId;
    protected static Pattern NOBR_REPLACE_PATTERN = Pattern.compile("(?:&lt;\\s*" + RegisteredTags.NOBR + "\\s*/\\s*&gt;)(?:.*?)(?:</text:[p|h][^>]*>)(?:.*?)(?:<text:[p|h][^>]*>)", 40);

    public ODTDocumentService() {
    }

    public ODTDocumentService(Document document) {
        super(document);
    }

    public boolean isList(String label) {
        return "text:list".equals(label);
    }

    public boolean isListItem(String label) {
        return "text:list-item".equals(label);
    }

    public boolean isPara(String label) {
        return "text:p".equals(label) || "text:h".equals(label);
    }

    public boolean isTable(String label) {
        return "table:table".equals(label);
    }

    public boolean isRow(String label) {
        return "table:table-row".equals(label);
    }

    public String getTextStyle() {
        return "(text:p|text:h|text:span)";
    }

    public String[] getTextTagLabels() {
        return new String[]{"text:p", "text:h", "text:span", "table:table"};
    }

    public String getNamingSpaceURL() {
        return "xmlns:text=\"urn:oasis:names:tc:opendocument:xmlns:text:1.0\" xmlns:table=\"urn:oasis:names:tc:opendocument:xmlns:table:1.0\" xmlns:office=\"urn:oasis:names:tc:opendocument:xmlns:office:1.0\" xmlns:fo=\"urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0\" xmlns:style=\"urn:oasis:names:tc:opendocument:xmlns:style:1.0\"";
    }

    public NamespaceContext getNameSpaceContext() {
        return new ODTNamespaceContext();
    }

    public void saveDocument(Document document, String path) throws DocumentServiceException {
        if (!(document instanceof ODTDocument)) {
            throw new DocumentServiceException("Document is not a valid ODT document.");
        }
        this.insertDocumentInFile((ODTDocument)document);
        ((ODTDocument)document).zipToLocation(path);
    }

    private void insertDocumentInFile(ODTDocument document) {
        try {
            document.jumpToStart();
            do {
                DOMSource domSource = new DOMSource(document.getXMLParser().getDocument());
                StreamResult fluxDestination = new StreamResult(new File(String.valueOf(document.getUnzipLocationDocumentFile().getAbsolutePath()) + "/" + document.getXMLParser().getXmlFile().getName()));
                TransformerFactory fabrique = TransformerFactory.newInstance();
                Transformer transformationIdentite = fabrique.newTransformer();
                transformationIdentite.setOutputProperty("encoding", "UTF-8");
                transformationIdentite.transform(domSource, fluxDestination);
            } while (document.jumpToNextFile());
        }
        catch (TransformerException e2) {
            e2.printStackTrace();
        }
    }

    protected Node cleanTags(Node currentNode, List<String> tagLabels, Node baseNode) throws InvalidContentException {
        String[] separated;
        if (baseNode == null) {
            return null;
        }
        StringBuffer newNodeContent = new StringBuffer(this.extractNodeTextValue(baseNode));
        while (baseNode != null && !this.containsOneOf(tagLabels, newNodeContent.toString())) {
            if ((baseNode = this.findNodeWithStartTag(baseNode, currentNode)) == null) continue;
            newNodeContent = new StringBuffer(this.extractNodeTextValue(baseNode));
        }
        if (baseNode == null) {
            return null;
        }
        boolean isCompleteTag = this.containsFullTags(newNodeContent.toString(), tagLabels);
        String[] currentNodeText = new String[]{};
        LinkedList<String> partsToRemove = new LinkedList<String>();
        String currentNodeContent = this.extractNodeTextValue(currentNode);
        if (!isCompleteTag) {
            currentNodeText = currentNodeContent.split("((<[^>]*>)*[^<>]*</[^<>]*>|(<[^>]*>))");
            NodeList followingNodes = this.getNextNodes(baseNode, baseNode.getNodeName());
            ArrayList<Node> nodesToRemove = new ArrayList<Node>();
            if (currentNodeText.length > 0) {
                newNodeContent.append(currentNodeText[0]);
                partsToRemove.add(currentNodeText[0]);
            }
            if (followingNodes != null) {
                int i = 0;
                while (i < followingNodes.getLength()) {
                    if (currentNodeText.length > i + 1) {
                        newNodeContent.append(currentNodeText[i + 1]);
                        partsToRemove.add(currentNodeText[i + 1]);
                    }
                    String textValue = this.extractNodeTextValue(followingNodes.item(i));
                    Node nodeToRemove = this.getBestAscendantUntil(currentNode, followingNodes.item(i));
                    if (nodeToRemove == null) break;
                    newNodeContent.append(textValue);
                    if (!nodesToRemove.contains(nodeToRemove)) {
                        nodesToRemove.add(nodeToRemove);
                    }
                    if (this.containsFullTags(newNodeContent.toString(), tagLabels)) {
                        isCompleteTag = true;
                        break;
                    }
                    ++i;
                }
                if (currentNodeText.length > followingNodes.getLength() + 1) {
                    newNodeContent.append(currentNodeText[followingNodes.getLength() + 1]);
                    partsToRemove.add(currentNodeText[followingNodes.getLength() + 1]);
                }
                for (Node nodeToRemove : nodesToRemove) {
                    if (nodeToRemove == null || !currentNode.equals(nodeToRemove.getParentNode())) continue;
                    currentNode.removeChild(nodeToRemove);
                }
            }
        }
        if ((separated = this.asText(baseNode).split(String.valueOf(XML_TAG_START) + "|" + XML_TAG_END)) != null && separated.length > 1) {
            newNodeContent.insert(0, String.valueOf(XML_TAG_START) + separated[1] + XML_TAG_END);
            newNodeContent.append(String.valueOf(XML_TAG_START) + separated[separated.length - 1] + XML_TAG_END);
        } else {
            newNodeContent.append(this.asText(baseNode));
        }
        String nodeContent = this.cleanXMLContent(newNodeContent.toString());
        Node result = this.injectNode(baseNode, nodeContent);
        baseNode.getParentNode().removeChild(baseNode);
        if (!partsToRemove.isEmpty()) {
            StringBuffer finalString;
            if (currentNode.getParentNode() == null) {
                finalString = new StringBuffer();
                finalString.append(nodeContent.substring(0, nodeContent.indexOf(XML_TAG_END) + 1));
                finalString.append(this.clearContents(result, partsToRemove, nodeContent));
                finalString.append(nodeContent.substring(nodeContent.lastIndexOf(XML_TAG_START)));
                Node newNode = this.injectNode(result, finalString.toString());
                result.getParentNode().removeChild(result);
                result = newNode;
            } else {
                finalString = new StringBuffer();
                String currentNodeContentString = this.asText(currentNode);
                finalString.append(currentNodeContentString.substring(0, currentNodeContentString.indexOf(XML_TAG_END) + 1));
                finalString.append(this.clearContents(currentNode, partsToRemove, nodeContent));
                finalString.append(currentNodeContentString.substring(currentNodeContentString.lastIndexOf(XML_TAG_START)));
                result = this.injectNode(currentNode, finalString.toString());
                currentNode.getParentNode().removeChild(currentNode);
            }
        }
        return result;
    }

    public String addNamingSpaces(String nodes) {
        String[] stringArray = this.getTextTagLabels();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String textNode = stringArray[n2];
            nodes = nodes.replaceAll("<" + textNode + " ", "<" + textNode + " " + this.getNamingSpaceURL() + " ");
            nodes = nodes.replaceAll("<" + textNode + ">", "<" + textNode + " " + this.getNamingSpaceURL() + ">");
            ++n2;
        }
        return nodes;
    }

    private String clearContents(Node currentNode, List<String> partsToRemove, String nodeContent) throws InvalidContentException {
        String currentNodeContent = this.extractNodeTextValue(currentNode);
        Matcher m = Pattern.compile("<[^>]*>[^<]*</[^>]*>").matcher(currentNodeContent);
        String[] currentNodeParts = currentNodeContent.split("(<[^>]*>[^<]*</[^>]*>)|<[^>]*/>");
        StringBuffer content = new StringBuffer();
        StringBuffer toRemove = new StringBuffer();
        for (String partToRemove : partsToRemove) {
            toRemove.append(partToRemove);
        }
        int i = 0;
        while (i < currentNodeParts.length) {
            if (!partsToRemove.contains(currentNodeParts[i]) && !toRemove.toString().equals(currentNodeParts[i])) {
                content.append(currentNodeParts[i]);
            }
            if (m.find()) {
                content.append(currentNodeContent.substring(m.start(), m.end()));
            }
            ++i;
        }
        return content.toString();
    }

    public IAdditionalResourceService getAdditionalResourceService() {
        return this.additionalResourceService;
    }

    public String getTableLabel() {
        return "table:table";
    }

    protected boolean areSimilarTags(String tagName1, String tagName2) {
        return "text:p".equals(tagName1) && "text:h".equals(tagName2) || "text:p".equals(tagName2) && "text:h".equals(tagName1);
    }

    protected String containsSimilarTag(Stack<String> tagStack, String tagName) {
        if ("text:p".equals(tagName) && tagStack.contains("text:h")) {
            return "text:h";
        }
        if ("text:h".equals(tagName) && tagStack.contains("text:p")) {
            return "text:p";
        }
        return null;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getListLabel() {
        return "text:list";
    }

    public String getListId(Node n) {
        NamedNodeMap map = n.getAttributes();
        if (map != null && map.getNamedItem("xml:id") != null) {
            return map.getNamedItem("xml:id").getNodeValue();
        }
        return null;
    }

    public Pattern getNobrReplacePattern() {
        return NOBR_REPLACE_PATTERN;
    }

    public String getContinueList(Node currentNode, String idList) throws InvalidContentException {
        NamedNodeMap m = currentNode.getAttributes();
        if (m.getNamedItem("text:continue-list") == null) {
            String curNodeString = this.asText(currentNode);
            curNodeString = curNodeString.replaceAll("<text:list ", "<text:list text:continue-list=\"" + idList + "\" ");
            return curNodeString;
        }
        return this.asText(currentNode);
    }

    public String format(String input) {
        return input.replace("&#xD;", "</text:p><text:p>").replace("\r", "</text:p><text:p>").replace("&#xA;", "<text:line-break/>").replace("\n", "<text:line-break/>").replace("&#x9;", "<text:tab/>").replace("\t", "<text:tab/>");
    }
}

