/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.documents.IDocumentManager;
import org.eclipse.gendoc.documents.SourceException;
import org.eclipse.gendoc.process.IProcessExtensionService;
import org.eclipse.gendoc.process.impl.ProcessExtension;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.ILogger;
import org.eclipse.gendoc.services.IProgressMonitorService;
import org.eclipse.gendoc.services.IService;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.services.exception.GenerationException;
import org.eclipse.gendoc.tags.handlers.IConfigurationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GendocProcess {
    private static final String SERVICES_DELIMITER = ";";
    public URL source = null;

    public String runProcess() throws GenDocException {
        if (this.source == null) {
            throw new SourceException("Please provide an input");
        }
        IDocumentManager documentManager = (IDocumentManager)GendocServices.getDefault().getService(IDocumentManager.class);
        Document document = null;
        try {
            document = documentManager.getDocument(this.source);
        }
        catch (RuntimeException e) {
            throw new GenerationException("Document " + this.source.toString() + " can not be loaded", (Throwable)e);
        }
        documentManager.setDocTemplate(document);
        IProcessExtensionService processExtensionService = (IProcessExtensionService)GendocServices.getDefault().getService(IProcessExtensionService.class);
        IProgressMonitorService progressMonitorService = (IProgressMonitorService)GendocServices.getDefault().getService(IProgressMonitorService.class);
        progressMonitorService.beginTask("Generating Document", processExtensionService.getNumProcesses());
        while (!progressMonitorService.isCanceled() && processExtensionService.next()) {
            try {
                List runNext = processExtensionService.getProcesses();
                if (runNext.size() == 1) {
                    ((ProcessExtension)runNext.get(0)).getProcess().run();
                    continue;
                }
                ArrayList<Semaphore> semaphores = new ArrayList<Semaphore>(runNext.size());
                for (final ProcessExtension processExtension : runNext) {
                    final Semaphore s = new Semaphore(0);
                    semaphores.add(s);
                    Thread t = new Thread(new Runnable(){

                        public void run() {
                            try {
                                processExtension.getProcess().run(s);
                            }
                            catch (GenDocException e) {
                                ((ILogger)GendocServices.getDefault().getService(ILogger.class)).log(e.getUIMessage(), 2);
                            }
                        }
                    });
                    t.start();
                }
                for (Semaphore s : semaphores) {
                    s.acquire();
                }
            }
            catch (InterruptedException interruptedException) {
                ((ILogger)GendocServices.getDefault().getService(ILogger.class)).log("Parallel process has been interrupted.", 4);
                break;
            }
        }
        IConfigurationService configurationService = (IConfigurationService)GendocServices.getDefault().getService(IConfigurationService.class);
        String outputPath = configurationService.getOutput();
        GendocServices.getDefault().clear();
        return outputPath;
    }

    public String runProcess(File templateDoc) throws GenDocException {
        this.setSource(templateDoc);
        return this.runProcess();
    }

    public String runProcess(URL templateDoc) throws GenDocException {
        this.setSource(templateDoc);
        return this.runProcess();
    }

    public void setSource(File templateDoc) throws SourceException {
        try {
            this.source = templateDoc.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new SourceException("Please provide a correct file");
        }
    }

    public void setSource(URL url) throws SourceException {
        this.source = url;
    }

    public String runProcess(File templateDoc, Map<Class<? extends IService>, IService> services) throws GenDocException {
        for (Class<? extends IService> key : services.keySet()) {
            GendocServices.getDefault().setService(key, services.get(key));
        }
        return this.runProcess(templateDoc);
    }

    public String runProcess(URL templateDoc, Map<Class<? extends IService>, IService> services) throws GenDocException {
        for (Class<? extends IService> key : services.keySet()) {
            GendocServices.getDefault().setService(key, services.get(key));
        }
        return this.runProcess(templateDoc);
    }

    public String runProcess(File templateDoc, String services) throws GenDocException {
        String[] serviceIds;
        String[] stringArray = serviceIds = services.split(SERVICES_DELIMITER);
        int n = serviceIds.length;
        int n2 = 0;
        while (n2 < n) {
            String serviceId = stringArray[n2];
            GendocServices.getDefault().setService(serviceId);
            ++n2;
        }
        return this.runProcess(templateDoc);
    }

    public String runProcess(URL templateDoc, String services) throws GenDocException {
        String[] serviceIds;
        String[] stringArray = serviceIds = services.split(SERVICES_DELIMITER);
        int n = serviceIds.length;
        int n2 = 0;
        while (n2 < n) {
            String serviceId = stringArray[n2];
            GendocServices.getDefault().setService(serviceId);
            ++n2;
        }
        return this.runProcess(templateDoc);
    }
}

