/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.documents;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.Path;
import org.eclipse.gendoc.document.parser.Activator;

public class Unzipper {
    private URL inFileName;
    private String path = null;
    private HashMap<String, File> files = new HashMap();

    public Unzipper(File file) {
        this(file, null);
        this.path = String.valueOf(this.path) + file.getName();
    }

    public Unzipper(URL file) {
        this(file, null);
        this.path = String.valueOf(this.path) + file.getPath().substring(file.getPath().lastIndexOf(47) + 1, file.getPath().length());
    }

    public Unzipper(File file, String thepath) {
        this.path = Activator.getDefault().getStateLocation() + File.separator + "unzipped" + File.separator;
        try {
            this.inFileName = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        if (thepath != null) {
            this.path = thepath;
        }
    }

    public Unzipper(URL url, String thepath) {
        this.path = Activator.getDefault().getStateLocation() + File.separator + "unzipped" + File.separator;
        this.inFileName = url;
        if (thepath != null) {
            this.path = thepath;
        }
    }

    public void unzip() {
        String locationToUnzip = this.path;
        try {
            InputStream openStream = this.inFileName.openStream();
            ZipInputStream zis = new ZipInputStream(openStream);
            ZipEntry zipEntry = zis.getNextEntry();
            while (zipEntry != null) {
                File file = new File(locationToUnzip, zipEntry.getName());
                if (zipEntry.isDirectory()) {
                    file.mkdirs();
                } else {
                    file.getParentFile().mkdirs();
                    BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));
                    try {
                        try {
                            int bytesRead;
                            byte[] buf = new byte[2048];
                            while (-1 != (bytesRead = zis.read(buf))) {
                                ((OutputStream)fos).write(buf, 0, bytesRead);
                            }
                        }
                        catch (IOException iOException) {
                            throw new IllegalArgumentException(String.format("can't open %s", this.inFileName.getPath()));
                        }
                    }
                    finally {
                        ((OutputStream)fos).close();
                    }
                    if (file.length() == 0L && Path.fromOSString((String)file.getAbsolutePath()).getFileExtension().length() == 0) {
                        String pathFile = file.getAbsolutePath();
                        file.delete();
                        new File(pathFile).mkdir();
                    } else {
                        this.files.put(file.getName(), file);
                        this.files.put(zipEntry.getName(), file);
                    }
                }
                zipEntry = zis.getNextEntry();
            }
            zis.close();
            openStream.close();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(String.format("can't open %s", this.inFileName.getPath()));
        }
    }

    public void clean() {
        File f = new Path(this.path).toFile();
        this.clean(f);
    }

    private void clean(File f) {
        File[] thefiles;
        File[] fileArray = thefiles = f.listFiles();
        int n = thefiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f2 = fileArray[n2];
            if (f2.isDirectory()) {
                this.clean(f2);
            } else {
                f2.deleteOnExit();
            }
            ++n2;
        }
        f.deleteOnExit();
    }

    public File getFile(String name) {
        File result = this.files.get(name);
        if (result == null) {
            for (File f : this.files.values()) {
                String pattern = "";
                if (File.separator.contains("\\")) {
                    pattern = "\\";
                }
                if (name.contains("..")) {
                    name = name.replace(".", "");
                }
                if (!f.getAbsolutePath().replaceAll(String.valueOf(pattern) + File.separator, "/").contains(name)) continue;
                result = f;
                break;
            }
        }
        return result;
    }

    static void main(String[] args) {
        new Unzipper(new File("toto")).unzip();
    }

    public File getDocumentFile() {
        return new File(this.inFileName.getFile());
    }

    public File getUnzipDocumentFile() {
        return new Path(this.path).toFile();
    }
}

