/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.ui.emfresource.exeed;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.hawk.emfresource.HawkResource;
import org.eclipse.hawk.ui.emfresource.Activator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class EClassSelectionDialog
extends Dialog {
    private final HawkResource resource;
    private EPackage ePackage;
    private EClass eClass;

    EClassSelectionDialog(Shell parentShell, HawkResource hawkResource) {
        super(parentShell);
        this.resource = hawkResource;
    }

    protected Control createDialogArea(Composite parent) {
        Object[] packages;
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        Label lblPackage = new Label(container, 0);
        lblPackage.setText("Package:");
        ComboViewer lPackages = new ComboViewer(container, 2048);
        lPackages.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        lPackages.setContentProvider((IContentProvider)new ArrayContentProvider());
        try {
            packages = this.resource.getRegisteredMetamodels().toArray();
        }
        catch (Exception e) {
            Activator.logError("Could not retrieve registered metamodels", e);
            packages = new Object[]{};
        }
        Arrays.sort(packages);
        lPackages.setInput((Object)packages);
        lPackages.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label lblClass = new Label(container, 0);
        lblClass.setText("EClass:");
        final ComboViewer lClasses = new ComboViewer(container, 4);
        lClasses.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        lClasses.setContentProvider((IContentProvider)new ArrayContentProvider());
        lClasses.setInput((Object)new Object[0]);
        lClasses.getCombo().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        lPackages.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ssel;
                EClassSelectionDialog.this.eClass = null;
                if (event.getSelection() instanceof IStructuredSelection && (ssel = (IStructuredSelection)event.getSelection()).getFirstElement() != null) {
                    String packageURI = (String)ssel.getFirstElement();
                    EClassSelectionDialog.this.ePackage = EClassSelectionDialog.this.resource.getResourceSet().getPackageRegistry().getEPackage(packageURI);
                    ArrayList<String> eClassNames = new ArrayList<String>();
                    if (EClassSelectionDialog.this.ePackage != null) {
                        for (EClassifier classifier : EClassSelectionDialog.this.ePackage.getEClassifiers()) {
                            if (!(classifier instanceof EClass)) continue;
                            eClassNames.add(classifier.getName());
                        }
                    }
                    Object[] arrClassNames = eClassNames.toArray();
                    Arrays.sort(arrClassNames);
                    lClasses.setInput((Object)arrClassNames);
                }
                EClassSelectionDialog.this.checkOKEnabled();
            }
        });
        lClasses.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection ssel;
                if (event.getSelection() instanceof IStructuredSelection && (ssel = (IStructuredSelection)event.getSelection()).getFirstElement() != null) {
                    String className = (String)ssel.getFirstElement();
                    EClassSelectionDialog.this.eClass = (EClass)EClassSelectionDialog.this.ePackage.getEClassifier(className);
                }
                EClassSelectionDialog.this.checkOKEnabled();
            }
        });
        return container;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.checkOKEnabled();
        return control;
    }

    public EClass getEClass() {
        return this.eClass;
    }

    private void checkOKEnabled() {
        this.getButton(0).setEnabled(this.eClass != null);
    }
}

