/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.ui.emfresource.exeed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.viewer.ColumnViewerInformationControlToolTipSupport;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.ecore.presentation.EcoreEditorPlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.celleditor.AdapterFactoryTreeEditor;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.DecoratingColumLabelProvider;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.epsilon.dt.exeed.ExeedEditor;
import org.eclipse.epsilon.dt.exeed.extensions.IExeedCustomizer;
import org.eclipse.epsilon.emc.emf.InMemoryEmfModel;
import org.eclipse.hawk.emfresource.HawkResource;
import org.eclipse.hawk.ui.emfresource.exeed.FetchByEClassAction;
import org.eclipse.hawk.ui.emfresource.exeed.UnloadResourceSetOnCloseListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;

public class HawkResourceExeedCustomizer
implements IExeedCustomizer {
    public void createPages(ExeedEditor editor, Composite container, AdapterFactory adapterFactory) {
        editor.setShowAllResources(true);
        editor.createModelGen();
        EditingDomain editingDomain = editor.getEditingDomain();
        if (!editingDomain.getResourceSet().getResources().isEmpty()) {
            Tree tree = new Tree(container, 2);
            TreeViewer selectionViewer = new TreeViewer(tree);
            editor.setCurrentViewer((Viewer)selectionViewer);
            selectionViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(adapterFactory));
            IDialogSettings dialogSettings = EcoreEditorPlugin.getPlugin().getDialogSettings();
            SingleNodeDiagnosticDecorator labelDecorator = new SingleNodeDiagnosticDecorator(editingDomain, (StructuredViewer)selectionViewer, dialogSettings);
            selectionViewer.setLabelProvider((IBaseLabelProvider)new DecoratingColumLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider(adapterFactory), (ILabelDecorator)labelDecorator));
            selectionViewer.setInput((Object)editingDomain.getResourceSet());
            selectionViewer.setSelection((ISelection)new StructuredSelection(editingDomain.getResourceSet().getResources().get(0)), true);
            new AdapterFactoryTreeEditor(selectionViewer.getTree(), adapterFactory);
            new ColumnViewerInformationControlToolTipSupport((ColumnViewer)selectionViewer, (LocationListener)new DiagnosticDecorator.EditingDomainLocationListener(editingDomain, (StructuredViewer)selectionViewer));
            editor.createContextMenuFor((StructuredViewer)selectionViewer);
            int pageIndex = editor.addPage((Control)tree);
            editor.setPageText(pageIndex, EcoreEditorPlugin.INSTANCE.getString("_UI_SelectionPage_label"));
        }
        IWorkbenchPage page = editor.getEditorSite().getPage();
        page.addPartListener((IPartListener2)new UnloadResourceSetOnCloseListener(page, (EcoreEditor)editor));
    }

    public boolean hasChildren(Resource r, EObject eob) {
        HawkResource hawkResource = (HawkResource)r;
        return hawkResource.hasChildren(eob);
    }

    public Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
        return Collections.emptyList();
    }

    public Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
        return Collections.emptyList();
    }

    public Collection<IAction> generateCustomizerActions(ISelection selection) {
        IStructuredSelection ssel;
        if (selection instanceof IStructuredSelection && (ssel = (IStructuredSelection)selection).getFirstElement() instanceof HawkResource) {
            HawkResource r = (HawkResource)ssel.getFirstElement();
            ArrayList<IAction> actions = new ArrayList<IAction>();
            FetchByEClassAction fetchByEClass = new FetchByEClassAction(r);
            fetchByEClass.setText("Fetch by EClass");
            actions.add((IAction)fetchByEClass);
            return actions;
        }
        return Collections.emptyList();
    }

    public boolean isEnabledFor(Resource r) {
        return r instanceof HawkResource;
    }

    public InMemoryEmfModel createInMemoryEmfModel(Resource mainResource) {
        return new InMemoryEmfModel(mainResource, false);
    }

    private static final class SingleNodeDiagnosticDecorator
    extends DiagnosticDecorator {
        private SingleNodeDiagnosticDecorator(EditingDomain editingDomain, StructuredViewer viewer, IDialogSettings dialogSettings) {
            super(editingDomain, viewer, dialogSettings);
        }

        protected BasicDiagnostic decorate(Map<Object, BasicDiagnostic> objects, ITreeContentProvider treeContentProvider, Set<Object> visited, Object object, List<Integer> path) {
            visited.add(object);
            return (BasicDiagnostic)this.decorations.get(object);
        }
    }
}

