/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.ui.emfresource.handlers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobFunction;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.framework.FrameworkUtil;

public class SaveXMICommand
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection0 = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection0 instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)selection0;
            IFile hawkModel = (IFile)selection.getFirstElement();
            File dest = hawkModel.getLocation().removeFileExtension().addFileExtension("xmi").toFile();
            String jobName = "Export " + hawkModel.getName() + " to " + dest;
            Job job = Job.create((String)jobName, (IJobFunction)new XMIDumpJobFunction(dest, hawkModel));
            job.schedule();
        }
        return null;
    }

    protected void dumpToXMI(IFile hawkModel, File dest, IProgressMonitor monitor) throws IOException, CoreException {
        monitor.beginTask("Saving " + hawkModel.getName() + " to XMI", 3);
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource rSource = rs.createResource(URI.createURI((String)hawkModel.getLocationURI().toString()));
        XMIResourceImpl rTarget = null;
        try {
            monitor.subTask("Loading graph as a model");
            rSource.load(null);
            monitor.worked(1);
            if (monitor.isCanceled()) {
                return;
            }
            monitor.subTask("Dumping graph to XMI");
            rTarget = new XMIResourceImpl(URI.createFileURI((String)dest.getAbsolutePath()));
            for (Resource r : new ArrayList(rs.getResources())) {
                rTarget.getContents().addAll(new ArrayList(r.getContents()));
            }
            rTarget.save(null);
            monitor.worked(1);
            if (monitor.isCanceled()) {
                return;
            }
            hawkModel.getParent().refreshLocal(1, null);
        }
        finally {
            if (rTarget != null && rTarget.isLoaded()) {
                rTarget.unload();
            }
            if (rSource.isLoaded()) {
                rSource.unload();
            }
        }
    }

    public class XMIDumpJobFunction
    implements IJobFunction {
        private File dest;
        private IFile hawkModel;

        public XMIDumpJobFunction(File dest, IFile hawkModel) {
            this.dest = dest;
            this.hawkModel = hawkModel;
        }

        public IStatus run(IProgressMonitor monitor) {
            String pluginId = FrameworkUtil.getBundle(SaveXMICommand.class).getSymbolicName();
            try {
                SaveXMICommand.this.dumpToXMI(this.hawkModel, this.dest, monitor);
                Status status = new Status(0, pluginId, "Completed export");
                return status;
            }
            catch (Exception e) {
                e.printStackTrace();
                Status status = new Status(4, pluginId, e.getMessage());
                return status;
            }
            finally {
                monitor.done();
            }
        }
    }
}

