/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.ui2.dialog;

import java.util.List;
import java.util.Map;
import org.eclipse.hawk.core.IModelUpdater;
import org.eclipse.hawk.osgiserver.HManager;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class HPluginsDialog
extends TitleAreaDialog {
    public HPluginsDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        HManager instance = HManager.getInstance();
        this.pluginTable(parent, "Updater", instance.getModelUpdaterInstances(), new LabelProvider(){

            public String getText(Object element) {
                IModelUpdater updater = (IModelUpdater)element;
                return updater.getHumanReadableName();
            }
        });
        return parent;
    }

    private CheckboxTableViewer pluginTable(Composite container, String tableLabel, Map<String, ?> plugins, LabelProvider labelProvider) {
        Label label = new Label(container, 0);
        GridData gd = new GridData(2);
        label.setLayoutData((Object)gd);
        String formatter = "&%s plugins:";
        label.setText(String.format(formatter, tableLabel));
        final CheckboxTableViewer tableviewer = CheckboxTableViewer.newCheckList((Composite)container, (int)2816);
        tableviewer.setContentProvider((IContentProvider)new ListContentProvider());
        tableviewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        tableviewer.setInput(plugins.entrySet());
        tableviewer.setAllChecked(true);
        tableviewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
            }
        });
        gd = new GridData(768);
        tableviewer.getTable().setLayoutData((Object)gd);
        tableviewer.getTable().setHeaderVisible(false);
        tableviewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
            }
        });
        Composite cTableButtons = new Composite(container, 0);
        gd = new GridData(4, 128, true, true);
        cTableButtons.setLayoutData((Object)gd);
        cTableButtons.setLayout((Layout)new FillLayout(512));
        Button btnEnableAll = new Button(cTableButtons, 0);
        btnEnableAll.setText("Enable all");
        btnEnableAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                tableviewer.setAllChecked(true);
            }
        });
        Button btnDisableAll = new Button(cTableButtons, 0);
        btnDisableAll.setText("Disable all");
        btnDisableAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                tableviewer.setAllChecked(false);
            }
        });
        return tableviewer;
    }

    private static final class ListContentProvider
    implements IStructuredContentProvider {
        private ListContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return new Object[0];
        }
    }
}

