/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.sqlite;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.hawk.core.graph.IGraphIterable;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.IGraphNodeIndex;
import org.eclipse.hawk.sqlite.SQLiteDatabase;
import org.eclipse.hawk.sqlite.iteration.StatementGraphNodeIterable;
import org.eclipse.hawk.sqlite.iteration.StatementSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLiteNodeIndex
implements IGraphNodeIndex {
    static final Logger LOGGER = LoggerFactory.getLogger(SQLiteNodeIndex.class);
    private final SQLiteDatabase db;
    private final String name;

    public SQLiteNodeIndex(SQLiteDatabase db, String name) {
        this.db = db;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public IGraphIterable<? extends IGraphNode> query(String key, Object valueOrPattern) {
        if (valueOrPattern instanceof String && ((String)valueOrPattern).contains("*")) {
            String pattern = (String)valueOrPattern;
            if ("*".equals(key) && "*".equals(pattern)) {
                return new StatementGraphNodeIterable(this.db, () -> this.db.getConnection().getQueryIndexValueAllPairsStatement(this.name), () -> this.db.getConnection().getQueryIndexValueAllPairsCountStatement(this.name), () -> this.db.getConnection().getQueryIndexValueAllPairsSingleStatement(this.name));
            }
            if ("*".equals(pattern)) {
                return new StatementGraphNodeIterable(this.db, () -> this.db.getConnection().getQueryIndexValueAllValuesStatement(this.name, key), () -> this.db.getConnection().getQueryIndexValueAllValuesCountStatement(this.name, key), () -> this.db.getConnection().getQueryIndexValueAllValuesSingleStatement(this.name, key));
            }
            return new StatementGraphNodeIterable(this.db, () -> this.db.getConnection().getQueryIndexValuePatternStatement(this.name, key, pattern), () -> this.db.getConnection().getQueryIndexValuePatternCountStatement(this.name, key, pattern), () -> this.db.getConnection().getQueryIndexValuePatternSingleStatement(this.name, key, pattern));
        }
        return this.get(key, valueOrPattern);
    }

    public IGraphIterable<? extends IGraphNode> query(String key, Number from, Number to, boolean fromInclusive, boolean toInclusive) {
        return new StatementGraphNodeIterable(this.db, () -> this.db.getConnection().getQueryIndexNumberRangeStatement(this.name, key, from, to, fromInclusive, toInclusive), () -> this.db.getConnection().getQueryIndexNumberRangeCountStatement(this.name, key, from, to, fromInclusive, toInclusive), () -> this.db.getConnection().getQueryIndexNumberRangeSingleStatement(this.name, key, from, to, fromInclusive, toInclusive));
    }

    public IGraphIterable<? extends IGraphNode> get(String key, Object exactValue) {
        return new StatementGraphNodeIterable(this.db, () -> this.db.getConnection().getQueryIndexValueExactStatement(this.name, key, exactValue), () -> this.db.getConnection().getQueryIndexValueExactCountStatement(this.name, key, exactValue), () -> this.db.getConnection().getQueryIndexValueExactSingleStatement(this.name, key, exactValue));
    }

    public void add(IGraphNode n, String key, Object value) {
        int rowCount = this.executeUpdate(() -> this.db.getConnection().getAddNodeIndexEntryStatement(this.name, (Integer)n.getId(), key, value));
        assert (rowCount == 1) : "One row should be inserted when adding an index entry";
    }

    public void remove(IGraphNode n) {
        this.executeUpdate(() -> this.db.getConnection().getRemoveNodeFromIndexStatement(this.name, (Integer)n.getId()));
    }

    public void remove(IGraphNode n, String key, Object value) {
        if (key == null) {
            if (value == null) {
                this.remove(n);
            } else {
                this.executeUpdate(() -> this.db.getConnection().getRemoveNodeValueFromIndexStatement(this.name, (Integer)n.getId(), value));
            }
        } else if (value == null) {
            this.executeUpdate(() -> this.db.getConnection().getRemoveNodeFieldFromIndexStatement(this.name, (Integer)n.getId(), key));
        }
        this.executeUpdate(() -> this.db.getConnection().getRemoveIndexEntryStatement(this.name, (Integer)n.getId(), key, value));
    }

    public void flush() {
    }

    public void delete() {
        try {
            SQLiteDatabase.SQLiteConnection conn = this.db.getConnection();
            PreparedStatement stmt = conn.getDeleteNodeIndexStatement(this.name);
            int rowCount = stmt.executeUpdate();
            assert (rowCount == 1) : "A row should have been deleted when deleting a node index";
            Throwable throwable = null;
            Object var5_7 = null;
            try (Statement dropStmt = conn.createStatement();){
                dropStmt.execute(conn.getClearNodeIndexTableSQL(this.name));
                conn.dropIndexTableOnCommit(this.name);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private int executeUpdate(StatementSupplier stmt) {
        try {
            return stmt.get().executeUpdate();
        }
        catch (SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return 0;
        }
    }
}

