/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.service.emf.dt.editors;

import org.eclipse.hawk.service.emf.dt.Activator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class HawkMultiPageEditorContributor
extends MultiPageEditorActionBarContributor {
    private static final String EXEED_EDITOR_ID = "org.eclipse.epsilon.dt.exeed.ExeedEditor";
    private IEditorPart activeEditorPart;
    private Action emfOpenAction;

    public HawkMultiPageEditorContributor() {
        this.createActions();
    }

    protected IAction getAction(ITextEditor editor, String actionID) {
        return editor == null ? null : editor.getAction(actionID);
    }

    public void setActivePage(IEditorPart part) {
        if (this.activeEditorPart == part) {
            return;
        }
        this.activeEditorPart = part;
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null) {
            ITextEditor editor = part instanceof ITextEditor ? (ITextEditor)part : null;
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.getAction(editor, ITextEditorActionConstants.DELETE));
            actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.getAction(editor, ITextEditorActionConstants.UNDO));
            actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.getAction(editor, ITextEditorActionConstants.REDO));
            actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.getAction(editor, ITextEditorActionConstants.CUT));
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.getAction(editor, ITextEditorActionConstants.COPY));
            actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.getAction(editor, ITextEditorActionConstants.PASTE));
            actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.getAction(editor, ITextEditorActionConstants.SELECT_ALL));
            actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.getAction(editor, ITextEditorActionConstants.FIND));
            actionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), this.getAction(editor, IDEActionFactory.BOOKMARK.getId()));
            actionBars.updateActionBars();
        }
    }

    private void createActions() {
        this.emfOpenAction = new Action(){

            public void run() {
                if (HawkMultiPageEditorContributor.this.activeEditorPart == null) {
                    return;
                }
                HawkMultiPageEditorContributor.reopenWithExeed(HawkMultiPageEditorContributor.this.activeEditorPart);
            }
        };
        this.emfOpenAction.setText("Open with Exeed");
        this.emfOpenAction.setToolTipText("Opens the model with the Epsilon Exeed editor");
        this.emfOpenAction.setImageDescriptor(Activator.getImageDescriptor("/icons/hawkmodel.png"));
    }

    public void contributeToMenu(IMenuManager manager) {
        MenuManager menu = new MenuManager("&Hawk");
        manager.prependToGroup("additions", (IContributionItem)menu);
        menu.add((IAction)this.emfOpenAction);
    }

    public void contributeToToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.emfOpenAction);
    }

    public static void reopenWithExeed(IEditorPart activeEditorPart) {
        IEditorInput existingInput = activeEditorPart.getEditorInput();
        if (existingInput instanceof IFileEditorInput) {
            IFileEditorInput existingFileInput = (IFileEditorInput)existingInput;
            FileEditorInput newFileInput = new FileEditorInput(existingFileInput.getFile());
            try {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
                page.openEditor((IEditorInput)newFileInput, EXEED_EDITOR_ID, true, 3);
            }
            catch (Throwable e) {
                Activator.getDefault().logError(e);
            }
        }
    }
}

